/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a GetApplicationRevision operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationRevisionResponse extends CodeDeployResponse implements
        ToCopyableBuilder<GetApplicationRevisionResponse.Builder, GetApplicationRevisionResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationRevisionResponse::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).getter(getter(GetApplicationRevisionResponse::revision))
            .setter(setter(Builder::revision)).constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<GenericRevisionInfo> REVISION_INFO_FIELD = SdkField
            .<GenericRevisionInfo> builder(MarshallingType.SDK_POJO).getter(getter(GetApplicationRevisionResponse::revisionInfo))
            .setter(setter(Builder::revisionInfo)).constructor(GenericRevisionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            REVISION_FIELD, REVISION_INFO_FIELD));

    private final String applicationName;

    private final RevisionLocation revision;

    private final GenericRevisionInfo revisionInfo;

    private GetApplicationRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.revision = builder.revision;
        this.revisionInfo = builder.revisionInfo;
    }

    /**
     * <p>
     * The name of the application that corresponds to the revision.
     * </p>
     * 
     * @return The name of the application that corresponds to the revision.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Additional information about the revision, including type and location.
     * </p>
     * 
     * @return Additional information about the revision, including type and location.
     */
    public RevisionLocation revision() {
        return revision;
    }

    /**
     * <p>
     * General information about the revision.
     * </p>
     * 
     * @return General information about the revision.
     */
    public GenericRevisionInfo revisionInfo() {
        return revisionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(revisionInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRevisionResponse)) {
            return false;
        }
        GetApplicationRevisionResponse other = (GetApplicationRevisionResponse) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(revision(), other.revision())
                && Objects.equals(revisionInfo(), other.revisionInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("GetApplicationRevisionResponse").add("ApplicationName", applicationName())
                .add("Revision", revision()).add("RevisionInfo", revisionInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "revisionInfo":
            return Optional.ofNullable(clazz.cast(revisionInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationRevisionResponse, T> g) {
        return obj -> g.apply((GetApplicationRevisionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationRevisionResponse> {
        /**
         * <p>
         * The name of the application that corresponds to the revision.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that corresponds to the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Additional information about the revision, including type and location.
         * </p>
         * 
         * @param revision
         *        Additional information about the revision, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * Additional information about the revision, including type and location.
         * </p>
         * This is a convenience that creates an instance of the {@link RevisionLocation.Builder} avoiding the need to
         * create one manually via {@link RevisionLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #revision(RevisionLocation)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(RevisionLocation)
         */
        default Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return revision(RevisionLocation.builder().applyMutation(revision).build());
        }

        /**
         * <p>
         * General information about the revision.
         * </p>
         * 
         * @param revisionInfo
         *        General information about the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionInfo(GenericRevisionInfo revisionInfo);

        /**
         * <p>
         * General information about the revision.
         * </p>
         * This is a convenience that creates an instance of the {@link GenericRevisionInfo.Builder} avoiding the need
         * to create one manually via {@link GenericRevisionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link GenericRevisionInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #revisionInfo(GenericRevisionInfo)}.
         * 
         * @param revisionInfo
         *        a consumer that will call methods on {@link GenericRevisionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionInfo(GenericRevisionInfo)
         */
        default Builder revisionInfo(Consumer<GenericRevisionInfo.Builder> revisionInfo) {
            return revisionInfo(GenericRevisionInfo.builder().applyMutation(revisionInfo).build());
        }
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private String applicationName;

        private RevisionLocation revision;

        private GenericRevisionInfo revisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRevisionResponse model) {
            super(model);
            applicationName(model.applicationName);
            revision(model.revision);
            revisionInfo(model.revisionInfo);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final RevisionLocation.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public final GenericRevisionInfo.Builder getRevisionInfo() {
            return revisionInfo != null ? revisionInfo.toBuilder() : null;
        }

        @Override
        public final Builder revisionInfo(GenericRevisionInfo revisionInfo) {
            this.revisionInfo = revisionInfo;
            return this;
        }

        public final void setRevisionInfo(GenericRevisionInfo.BuilderImpl revisionInfo) {
            this.revisionInfo = revisionInfo != null ? revisionInfo.build() : null;
        }

        @Override
        public GetApplicationRevisionResponse build() {
            return new GetApplicationRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
