/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentTargetResponse extends CodeDeployResponse implements
        ToCopyableBuilder<GetDeploymentTargetResponse.Builder, GetDeploymentTargetResponse> {
    private static final SdkField<DeploymentTarget> DEPLOYMENT_TARGET_FIELD = SdkField
            .<DeploymentTarget> builder(MarshallingType.SDK_POJO).getter(getter(GetDeploymentTargetResponse::deploymentTarget))
            .setter(setter(Builder::deploymentTarget)).constructor(DeploymentTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TARGET_FIELD));

    private final DeploymentTarget deploymentTarget;

    private GetDeploymentTargetResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentTarget = builder.deploymentTarget;
    }

    /**
     * <p>
     * A deployment target that contains information about a deployment such as its status, lifecyle events, and when it
     * was updated last. It also contains metadata about the deployment target. The deployment target metadata depends
     * on the deployment target's type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or
     * <code>ecsTarget</code>).
     * </p>
     * 
     * @return A deployment target that contains information about a deployment such as its status, lifecyle events, and
     *         when it was updated last. It also contains metadata about the deployment target. The deployment target
     *         metadata depends on the deployment target's type (<code>instanceTarget</code>, <code>lambdaTarget</code>,
     *         or <code>ecsTarget</code>).
     */
    public DeploymentTarget deploymentTarget() {
        return deploymentTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTarget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentTargetResponse)) {
            return false;
        }
        GetDeploymentTargetResponse other = (GetDeploymentTargetResponse) obj;
        return Objects.equals(deploymentTarget(), other.deploymentTarget());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDeploymentTargetResponse").add("DeploymentTarget", deploymentTarget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentTarget":
            return Optional.ofNullable(clazz.cast(deploymentTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentTargetResponse, T> g) {
        return obj -> g.apply((GetDeploymentTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentTargetResponse> {
        /**
         * <p>
         * A deployment target that contains information about a deployment such as its status, lifecyle events, and
         * when it was updated last. It also contains metadata about the deployment target. The deployment target
         * metadata depends on the deployment target's type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or
         * <code>ecsTarget</code>).
         * </p>
         * 
         * @param deploymentTarget
         *        A deployment target that contains information about a deployment such as its status, lifecyle events,
         *        and when it was updated last. It also contains metadata about the deployment target. The deployment
         *        target metadata depends on the deployment target's type (<code>instanceTarget</code>,
         *        <code>lambdaTarget</code>, or <code>ecsTarget</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentTarget(DeploymentTarget deploymentTarget);

        /**
         * <p>
         * A deployment target that contains information about a deployment such as its status, lifecyle events, and
         * when it was updated last. It also contains metadata about the deployment target. The deployment target
         * metadata depends on the deployment target's type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or
         * <code>ecsTarget</code>).
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentTarget.Builder} avoiding the need to
         * create one manually via {@link DeploymentTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentTarget(DeploymentTarget)}.
         * 
         * @param deploymentTarget
         *        a consumer that will call methods on {@link DeploymentTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentTarget(DeploymentTarget)
         */
        default Builder deploymentTarget(Consumer<DeploymentTarget.Builder> deploymentTarget) {
            return deploymentTarget(DeploymentTarget.builder().applyMutation(deploymentTarget).build());
        }
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private DeploymentTarget deploymentTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentTargetResponse model) {
            super(model);
            deploymentTarget(model.deploymentTarget);
        }

        public final DeploymentTarget.Builder getDeploymentTarget() {
            return deploymentTarget != null ? deploymentTarget.toBuilder() : null;
        }

        @Override
        public final Builder deploymentTarget(DeploymentTarget deploymentTarget) {
            this.deploymentTarget = deploymentTarget;
            return this;
        }

        public final void setDeploymentTarget(DeploymentTarget.BuilderImpl deploymentTarget) {
            this.deploymentTarget = deploymentTarget != null ? deploymentTarget.build() : null;
        }

        @Override
        public GetDeploymentTargetResponse build() {
            return new GetDeploymentTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
