/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevisionInfo implements SdkPojo, Serializable, ToCopyableBuilder<RevisionInfo.Builder, RevisionInfo> {
    private static final SdkField<RevisionLocation> REVISION_LOCATION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).getter(getter(RevisionInfo::revisionLocation))
            .setter(setter(Builder::revisionLocation)).constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionLocation").build()).build();

    private static final SdkField<GenericRevisionInfo> GENERIC_REVISION_INFO_FIELD = SdkField
            .<GenericRevisionInfo> builder(MarshallingType.SDK_POJO).getter(getter(RevisionInfo::genericRevisionInfo))
            .setter(setter(Builder::genericRevisionInfo)).constructor(GenericRevisionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genericRevisionInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_LOCATION_FIELD,
            GENERIC_REVISION_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final RevisionLocation revisionLocation;

    private final GenericRevisionInfo genericRevisionInfo;

    private RevisionInfo(BuilderImpl builder) {
        this.revisionLocation = builder.revisionLocation;
        this.genericRevisionInfo = builder.genericRevisionInfo;
    }

    /**
     * <p>
     * Information about the location and type of an application revision.
     * </p>
     * 
     * @return Information about the location and type of an application revision.
     */
    public RevisionLocation revisionLocation() {
        return revisionLocation;
    }

    /**
     * <p>
     * Information about an application revision, including usage details and associated deployment groups.
     * </p>
     * 
     * @return Information about an application revision, including usage details and associated deployment groups.
     */
    public GenericRevisionInfo genericRevisionInfo() {
        return genericRevisionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisionLocation());
        hashCode = 31 * hashCode + Objects.hashCode(genericRevisionInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionInfo)) {
            return false;
        }
        RevisionInfo other = (RevisionInfo) obj;
        return Objects.equals(revisionLocation(), other.revisionLocation())
                && Objects.equals(genericRevisionInfo(), other.genericRevisionInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("RevisionInfo").add("RevisionLocation", revisionLocation())
                .add("GenericRevisionInfo", genericRevisionInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionLocation":
            return Optional.ofNullable(clazz.cast(revisionLocation()));
        case "genericRevisionInfo":
            return Optional.ofNullable(clazz.cast(genericRevisionInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevisionInfo, T> g) {
        return obj -> g.apply((RevisionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevisionInfo> {
        /**
         * <p>
         * Information about the location and type of an application revision.
         * </p>
         * 
         * @param revisionLocation
         *        Information about the location and type of an application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionLocation(RevisionLocation revisionLocation);

        /**
         * <p>
         * Information about the location and type of an application revision.
         * </p>
         * This is a convenience that creates an instance of the {@link RevisionLocation.Builder} avoiding the need to
         * create one manually via {@link RevisionLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #revisionLocation(RevisionLocation)}.
         * 
         * @param revisionLocation
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionLocation(RevisionLocation)
         */
        default Builder revisionLocation(Consumer<RevisionLocation.Builder> revisionLocation) {
            return revisionLocation(RevisionLocation.builder().applyMutation(revisionLocation).build());
        }

        /**
         * <p>
         * Information about an application revision, including usage details and associated deployment groups.
         * </p>
         * 
         * @param genericRevisionInfo
         *        Information about an application revision, including usage details and associated deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genericRevisionInfo(GenericRevisionInfo genericRevisionInfo);

        /**
         * <p>
         * Information about an application revision, including usage details and associated deployment groups.
         * </p>
         * This is a convenience that creates an instance of the {@link GenericRevisionInfo.Builder} avoiding the need
         * to create one manually via {@link GenericRevisionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link GenericRevisionInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #genericRevisionInfo(GenericRevisionInfo)}.
         * 
         * @param genericRevisionInfo
         *        a consumer that will call methods on {@link GenericRevisionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #genericRevisionInfo(GenericRevisionInfo)
         */
        default Builder genericRevisionInfo(Consumer<GenericRevisionInfo.Builder> genericRevisionInfo) {
            return genericRevisionInfo(GenericRevisionInfo.builder().applyMutation(genericRevisionInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RevisionLocation revisionLocation;

        private GenericRevisionInfo genericRevisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionInfo model) {
            revisionLocation(model.revisionLocation);
            genericRevisionInfo(model.genericRevisionInfo);
        }

        public final RevisionLocation.Builder getRevisionLocation() {
            return revisionLocation != null ? revisionLocation.toBuilder() : null;
        }

        @Override
        public final Builder revisionLocation(RevisionLocation revisionLocation) {
            this.revisionLocation = revisionLocation;
            return this;
        }

        public final void setRevisionLocation(RevisionLocation.BuilderImpl revisionLocation) {
            this.revisionLocation = revisionLocation != null ? revisionLocation.build() : null;
        }

        public final GenericRevisionInfo.Builder getGenericRevisionInfo() {
            return genericRevisionInfo != null ? genericRevisionInfo.toBuilder() : null;
        }

        @Override
        public final Builder genericRevisionInfo(GenericRevisionInfo genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo;
            return this;
        }

        public final void setGenericRevisionInfo(GenericRevisionInfo.BuilderImpl genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo != null ? genericRevisionInfo.build() : null;
        }

        @Override
        public RevisionInfo build() {
            return new RevisionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
