/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a time range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRange implements SdkPojo, Serializable, ToCopyableBuilder<TimeRange.Builder, TimeRange> {
    private static final SdkField<Instant> START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TimeRange::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TimeRange::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant start;

    private final Instant end;

    private TimeRange(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The start time of the time range.
     * </p>
     * <note>
     * <p>
     * Specify null to leave the start time open-ended.
     * </p>
     * </note>
     * 
     * @return The start time of the time range.</p> <note>
     *         <p>
     *         Specify null to leave the start time open-ended.
     *         </p>
     */
    public Instant start() {
        return start;
    }

    /**
     * <p>
     * The end time of the time range.
     * </p>
     * <note>
     * <p>
     * Specify null to leave the end time open-ended.
     * </p>
     * </note>
     * 
     * @return The end time of the time range.</p> <note>
     *         <p>
     *         Specify null to leave the end time open-ended.
     *         </p>
     */
    public Instant end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    @Override
    public String toString() {
        return ToString.builder("TimeRange").add("Start", start()).add("End", end()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeRange, T> g) {
        return obj -> g.apply((TimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRange> {
        /**
         * <p>
         * The start time of the time range.
         * </p>
         * <note>
         * <p>
         * Specify null to leave the start time open-ended.
         * </p>
         * </note>
         * 
         * @param start
         *        The start time of the time range.</p> <note>
         *        <p>
         *        Specify null to leave the start time open-ended.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The end time of the time range.
         * </p>
         * <note>
         * <p>
         * Specify null to leave the end time open-ended.
         * </p>
         * </note>
         * 
         * @param end
         *        The end time of the time range.</p> <note>
         *        <p>
         *        Specify null to leave the end time open-ended.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);
    }

    static final class BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            start(model.start);
            end(model.end);
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public TimeRange build() {
            return new TimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
