/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrafficRoutingType {
    TIME_BASED_CANARY("TimeBasedCanary"),
    TIME_BASED_LINEAR("TimeBasedLinear"),
    ALL_AT_ONCE("AllAtOnce"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrafficRoutingType> VALUE_MAP;
    private final String value;

    private TrafficRoutingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrafficRoutingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrafficRoutingType> knownValues() {
        EnumSet<TrafficRoutingType> knownValues = EnumSet.allOf(TrafficRoutingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrafficRoutingType.class, TrafficRoutingType::toString);
    }
}

