/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about two target groups and how traffic is routed during an Amazon ECS deployment. An optional test
 * traffic route can be specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroupPairInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetGroupPairInfo.Builder, TargetGroupPairInfo> {
    private static final SdkField<List<TargetGroupInfo>> TARGET_GROUPS_FIELD = SdkField
            .<List<TargetGroupInfo>> builder(MarshallingType.LIST)
            .memberName("targetGroups")
            .getter(getter(TargetGroupPairInfo::targetGroups))
            .setter(setter(Builder::targetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetGroupInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetGroupInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TrafficRoute> PROD_TRAFFIC_ROUTE_FIELD = SdkField
            .<TrafficRoute> builder(MarshallingType.SDK_POJO).memberName("prodTrafficRoute")
            .getter(getter(TargetGroupPairInfo::prodTrafficRoute)).setter(setter(Builder::prodTrafficRoute))
            .constructor(TrafficRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prodTrafficRoute").build()).build();

    private static final SdkField<TrafficRoute> TEST_TRAFFIC_ROUTE_FIELD = SdkField
            .<TrafficRoute> builder(MarshallingType.SDK_POJO).memberName("testTrafficRoute")
            .getter(getter(TargetGroupPairInfo::testTrafficRoute)).setter(setter(Builder::testTrafficRoute))
            .constructor(TrafficRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testTrafficRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD,
            PROD_TRAFFIC_ROUTE_FIELD, TEST_TRAFFIC_ROUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TargetGroupInfo> targetGroups;

    private final TrafficRoute prodTrafficRoute;

    private final TrafficRoute testTrafficRoute;

    private TargetGroupPairInfo(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
        this.prodTrafficRoute = builder.prodTrafficRoute;
        this.testTrafficRoute = builder.testTrafficRoute;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetGroups() {
        return targetGroups != null && !(targetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One pair of target groups. One is associated with the original task set. The second is associated with the task
     * set that serves traffic after the deployment is complete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetGroups} method.
     * </p>
     * 
     * @return One pair of target groups. One is associated with the original task set. The second is associated with
     *         the task set that serves traffic after the deployment is complete.
     */
    public final List<TargetGroupInfo> targetGroups() {
        return targetGroups;
    }

    /**
     * <p>
     * The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
     * </p>
     * 
     * @return The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
     */
    public final TrafficRoute prodTrafficRoute() {
        return prodTrafficRoute;
    }

    /**
     * <p>
     * An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can
     * occur while test traffic is served during a deployment.
     * </p>
     * 
     * @return An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation
     *         can occur while test traffic is served during a deployment.
     */
    public final TrafficRoute testTrafficRoute() {
        return testTrafficRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroups() ? targetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prodTrafficRoute());
        hashCode = 31 * hashCode + Objects.hashCode(testTrafficRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupPairInfo)) {
            return false;
        }
        TargetGroupPairInfo other = (TargetGroupPairInfo) obj;
        return hasTargetGroups() == other.hasTargetGroups() && Objects.equals(targetGroups(), other.targetGroups())
                && Objects.equals(prodTrafficRoute(), other.prodTrafficRoute())
                && Objects.equals(testTrafficRoute(), other.testTrafficRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetGroupPairInfo").add("TargetGroups", hasTargetGroups() ? targetGroups() : null)
                .add("ProdTrafficRoute", prodTrafficRoute()).add("TestTrafficRoute", testTrafficRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetGroups":
            return Optional.ofNullable(clazz.cast(targetGroups()));
        case "prodTrafficRoute":
            return Optional.ofNullable(clazz.cast(prodTrafficRoute()));
        case "testTrafficRoute":
            return Optional.ofNullable(clazz.cast(testTrafficRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupPairInfo, T> g) {
        return obj -> g.apply((TargetGroupPairInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroupPairInfo> {
        /**
         * <p>
         * One pair of target groups. One is associated with the original task set. The second is associated with the
         * task set that serves traffic after the deployment is complete.
         * </p>
         * 
         * @param targetGroups
         *        One pair of target groups. One is associated with the original task set. The second is associated with
         *        the task set that serves traffic after the deployment is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(Collection<TargetGroupInfo> targetGroups);

        /**
         * <p>
         * One pair of target groups. One is associated with the original task set. The second is associated with the
         * task set that serves traffic after the deployment is complete.
         * </p>
         * 
         * @param targetGroups
         *        One pair of target groups. One is associated with the original task set. The second is associated with
         *        the task set that serves traffic after the deployment is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(TargetGroupInfo... targetGroups);

        /**
         * <p>
         * One pair of target groups. One is associated with the original task set. The second is associated with the
         * task set that serves traffic after the deployment is complete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #targetGroups(List<TargetGroupInfo>)}.
         * 
         * @param targetGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroups(java.util.Collection<TargetGroupInfo>)
         */
        Builder targetGroups(Consumer<TargetGroupInfo.Builder>... targetGroups);

        /**
         * <p>
         * The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
         * </p>
         * 
         * @param prodTrafficRoute
         *        The path used by a load balancer to route production traffic when an Amazon ECS deployment is
         *        complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prodTrafficRoute(TrafficRoute prodTrafficRoute);

        /**
         * <p>
         * The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficRoute.Builder} avoiding the need
         * to create one manually via {@link TrafficRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #prodTrafficRoute(TrafficRoute)}.
         * 
         * @param prodTrafficRoute
         *        a consumer that will call methods on {@link TrafficRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prodTrafficRoute(TrafficRoute)
         */
        default Builder prodTrafficRoute(Consumer<TrafficRoute.Builder> prodTrafficRoute) {
            return prodTrafficRoute(TrafficRoute.builder().applyMutation(prodTrafficRoute).build());
        }

        /**
         * <p>
         * An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can
         * occur while test traffic is served during a deployment.
         * </p>
         * 
         * @param testTrafficRoute
         *        An optional path used by a load balancer to route test traffic after an Amazon ECS deployment.
         *        Validation can occur while test traffic is served during a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testTrafficRoute(TrafficRoute testTrafficRoute);

        /**
         * <p>
         * An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can
         * occur while test traffic is served during a deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficRoute.Builder} avoiding the need
         * to create one manually via {@link TrafficRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #testTrafficRoute(TrafficRoute)}.
         * 
         * @param testTrafficRoute
         *        a consumer that will call methods on {@link TrafficRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testTrafficRoute(TrafficRoute)
         */
        default Builder testTrafficRoute(Consumer<TrafficRoute.Builder> testTrafficRoute) {
            return testTrafficRoute(TrafficRoute.builder().applyMutation(testTrafficRoute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<TargetGroupInfo> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private TrafficRoute prodTrafficRoute;

        private TrafficRoute testTrafficRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupPairInfo model) {
            targetGroups(model.targetGroups);
            prodTrafficRoute(model.prodTrafficRoute);
            testTrafficRoute(model.testTrafficRoute);
        }

        public final List<TargetGroupInfo.Builder> getTargetGroups() {
            List<TargetGroupInfo.Builder> result = TargetGroupInfoListCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<TargetGroupInfo.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupInfoListCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroupInfo> targetGroups) {
            this.targetGroups = TargetGroupInfoListCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroupInfo... targetGroups) {
            targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroupInfo.Builder>... targetGroups) {
            targetGroups(Stream.of(targetGroups).map(c -> TargetGroupInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TrafficRoute.Builder getProdTrafficRoute() {
            return prodTrafficRoute != null ? prodTrafficRoute.toBuilder() : null;
        }

        public final void setProdTrafficRoute(TrafficRoute.BuilderImpl prodTrafficRoute) {
            this.prodTrafficRoute = prodTrafficRoute != null ? prodTrafficRoute.build() : null;
        }

        @Override
        public final Builder prodTrafficRoute(TrafficRoute prodTrafficRoute) {
            this.prodTrafficRoute = prodTrafficRoute;
            return this;
        }

        public final TrafficRoute.Builder getTestTrafficRoute() {
            return testTrafficRoute != null ? testTrafficRoute.toBuilder() : null;
        }

        public final void setTestTrafficRoute(TrafficRoute.BuilderImpl testTrafficRoute) {
            this.testTrafficRoute = testTrafficRoute != null ? testTrafficRoute.build() : null;
        }

        @Override
        public final Builder testTrafficRoute(TrafficRoute testTrafficRoute) {
            this.testTrafficRoute = testTrafficRoute;
            return this;
        }

        @Override
        public TargetGroupPairInfo build() {
            return new TargetGroupPairInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
