/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.CodeDeployClientBuilder;
import software.amazon.awssdk.services.codedeploy.CodeDeployServiceClientConfiguration;
import software.amazon.awssdk.services.codedeploy.DefaultCodeDeployBaseClientBuilder;
import software.amazon.awssdk.services.codedeploy.DefaultCodeDeployClient;
import software.amazon.awssdk.services.codedeploy.endpoints.CodeDeployEndpointProvider;

@SdkInternalApi
final class DefaultCodeDeployClientBuilder
extends DefaultCodeDeployBaseClientBuilder<CodeDeployClientBuilder, CodeDeployClient>
implements CodeDeployClientBuilder {
    DefaultCodeDeployClientBuilder() {
    }

    @Override
    public DefaultCodeDeployClientBuilder endpointProvider(CodeDeployEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeDeployClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeDeployClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeDeployServiceClientConfiguration serviceClientConfiguration = CodeDeployServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeDeployClient(serviceClientConfiguration, clientConfiguration);
    }
}

