/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.internal.UserAgentUtils;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;

public class ListDeploymentConfigsPublisher
implements SdkPublisher<ListDeploymentConfigsResponse> {
    private final CodeDeployAsyncClient client;
    private final ListDeploymentConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentConfigsPublisher(CodeDeployAsyncClient client, ListDeploymentConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentConfigsPublisher(CodeDeployAsyncClient client, ListDeploymentConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> deploymentConfigsList() {
        Function<ListDeploymentConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentConfigsList() != null) {
                return response.deploymentConfigsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeploymentConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeploymentConfigsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentConfigsResponse> {
        private ListDeploymentConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentConfigsResponse> nextPage(ListDeploymentConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentConfigsPublisher.this.client.listDeploymentConfigs(ListDeploymentConfigsPublisher.this.firstRequest);
            }
            return ListDeploymentConfigsPublisher.this.client.listDeploymentConfigs((ListDeploymentConfigsRequest)((Object)ListDeploymentConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

