/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    AGENT_ISSUE("AGENT_ISSUE"),
    ALARM_ACTIVE("ALARM_ACTIVE"),
    APPLICATION_MISSING("APPLICATION_MISSING"),
    AUTOSCALING_VALIDATION_ERROR("AUTOSCALING_VALIDATION_ERROR"),
    AUTO_SCALING_CONFIGURATION("AUTO_SCALING_CONFIGURATION"),
    AUTO_SCALING_IAM_ROLE_PERMISSIONS("AUTO_SCALING_IAM_ROLE_PERMISSIONS"),
    CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND("CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND"),
    CUSTOMER_APPLICATION_UNHEALTHY("CUSTOMER_APPLICATION_UNHEALTHY"),
    DEPLOYMENT_GROUP_MISSING("DEPLOYMENT_GROUP_MISSING"),
    ECS_UPDATE_ERROR("ECS_UPDATE_ERROR"),
    ELASTIC_LOAD_BALANCING_INVALID("ELASTIC_LOAD_BALANCING_INVALID"),
    ELB_INVALID_INSTANCE("ELB_INVALID_INSTANCE"),
    HEALTH_CONSTRAINTS("HEALTH_CONSTRAINTS"),
    HEALTH_CONSTRAINTS_INVALID("HEALTH_CONSTRAINTS_INVALID"),
    HOOK_EXECUTION_FAILURE("HOOK_EXECUTION_FAILURE"),
    IAM_ROLE_MISSING("IAM_ROLE_MISSING"),
    IAM_ROLE_PERMISSIONS("IAM_ROLE_PERMISSIONS"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    INVALID_ECS_SERVICE("INVALID_ECS_SERVICE"),
    INVALID_LAMBDA_CONFIGURATION("INVALID_LAMBDA_CONFIGURATION"),
    INVALID_LAMBDA_FUNCTION("INVALID_LAMBDA_FUNCTION"),
    INVALID_REVISION("INVALID_REVISION"),
    MANUAL_STOP("MANUAL_STOP"),
    MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION("MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION"),
    MISSING_ELB_INFORMATION("MISSING_ELB_INFORMATION"),
    MISSING_GITHUB_TOKEN("MISSING_GITHUB_TOKEN"),
    NO_EC2_SUBSCRIPTION("NO_EC2_SUBSCRIPTION"),
    NO_INSTANCES("NO_INSTANCES"),
    OVER_MAX_INSTANCES("OVER_MAX_INSTANCES"),
    RESOURCE_LIMIT_EXCEEDED("RESOURCE_LIMIT_EXCEEDED"),
    REVISION_MISSING("REVISION_MISSING"),
    THROTTLED("THROTTLED"),
    TIMEOUT("TIMEOUT"),
    CLOUDFORMATION_STACK_FAILURE("CLOUDFORMATION_STACK_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

