/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutLifecycleEventHookExecutionStatusRequest extends CodeDeployRequest implements
        ToCopyableBuilder<PutLifecycleEventHookExecutionStatusRequest.Builder, PutLifecycleEventHookExecutionStatusRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(PutLifecycleEventHookExecutionStatusRequest::deploymentId))
            .setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> LIFECYCLE_EVENT_HOOK_EXECUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lifecycleEventHookExecutionId")
            .getter(getter(PutLifecycleEventHookExecutionStatusRequest::lifecycleEventHookExecutionId))
            .setter(setter(Builder::lifecycleEventHookExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEventHookExecutionId")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PutLifecycleEventHookExecutionStatusRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            LIFECYCLE_EVENT_HOOK_EXECUTION_ID_FIELD, STATUS_FIELD));

    private final String deploymentId;

    private final String lifecycleEventHookExecutionId;

    private final String status;

    private PutLifecycleEventHookExecutionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.lifecycleEventHookExecutionId = builder.lifecycleEventHookExecutionId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event.
     * </p>
     * 
     * @return The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle
     *         event.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the
     * <code>hooks</code> section of the AppSpec file.
     * </p>
     * 
     * @return The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the
     *         <code>hooks</code> section of the AppSpec file.
     */
    public final String lifecycleEventHookExecutionId() {
        return lifecycleEventHookExecutionId;
    }

    /**
     * <p>
     * The result of a Lambda function that validates a deployment lifecycle event. The values listed in <b>Valid
     * Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and
     * <code>Failed</code> can be passed successfully in your API call.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecycleEventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The result of a Lambda function that validates a deployment lifecycle event. The values listed in
     *         <b>Valid Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and
     *         <code>Failed</code> can be passed successfully in your API call.
     * @see LifecycleEventStatus
     */
    public final LifecycleEventStatus status() {
        return LifecycleEventStatus.fromValue(status);
    }

    /**
     * <p>
     * The result of a Lambda function that validates a deployment lifecycle event. The values listed in <b>Valid
     * Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and
     * <code>Failed</code> can be passed successfully in your API call.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecycleEventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The result of a Lambda function that validates a deployment lifecycle event. The values listed in
     *         <b>Valid Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and
     *         <code>Failed</code> can be passed successfully in your API call.
     * @see LifecycleEventStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleEventHookExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleEventHookExecutionStatusRequest)) {
            return false;
        }
        PutLifecycleEventHookExecutionStatusRequest other = (PutLifecycleEventHookExecutionStatusRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(lifecycleEventHookExecutionId(), other.lifecycleEventHookExecutionId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutLifecycleEventHookExecutionStatusRequest").add("DeploymentId", deploymentId())
                .add("LifecycleEventHookExecutionId", lifecycleEventHookExecutionId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "lifecycleEventHookExecutionId":
            return Optional.ofNullable(clazz.cast(lifecycleEventHookExecutionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLifecycleEventHookExecutionStatusRequest, T> g) {
        return obj -> g.apply((PutLifecycleEventHookExecutionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutLifecycleEventHookExecutionStatusRequest> {
        /**
         * <p>
         * The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle
         *        event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the
         * <code>hooks</code> section of the AppSpec file.
         * </p>
         * 
         * @param lifecycleEventHookExecutionId
         *        The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the
         *        <code>hooks</code> section of the AppSpec file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventHookExecutionId(String lifecycleEventHookExecutionId);

        /**
         * <p>
         * The result of a Lambda function that validates a deployment lifecycle event. The values listed in <b>Valid
         * Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and
         * <code>Failed</code> can be passed successfully in your API call.
         * </p>
         * 
         * @param status
         *        The result of a Lambda function that validates a deployment lifecycle event. The values listed in
         *        <b>Valid Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code>
         *        and <code>Failed</code> can be passed successfully in your API call.
         * @see LifecycleEventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleEventStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The result of a Lambda function that validates a deployment lifecycle event. The values listed in <b>Valid
         * Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and
         * <code>Failed</code> can be passed successfully in your API call.
         * </p>
         * 
         * @param status
         *        The result of a Lambda function that validates a deployment lifecycle event. The values listed in
         *        <b>Valid Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code>
         *        and <code>Failed</code> can be passed successfully in your API call.
         * @see LifecycleEventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleEventStatus
         */
        Builder status(LifecycleEventStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private String lifecycleEventHookExecutionId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleEventHookExecutionStatusRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            lifecycleEventHookExecutionId(model.lifecycleEventHookExecutionId);
            status(model.status);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getLifecycleEventHookExecutionId() {
            return lifecycleEventHookExecutionId;
        }

        public final void setLifecycleEventHookExecutionId(String lifecycleEventHookExecutionId) {
            this.lifecycleEventHookExecutionId = lifecycleEventHookExecutionId;
        }

        @Override
        public final Builder lifecycleEventHookExecutionId(String lifecycleEventHookExecutionId) {
            this.lifecycleEventHookExecutionId = lifecycleEventHookExecutionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecycleEventStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLifecycleEventHookExecutionStatusRequest build() {
            return new PutLifecycleEventHookExecutionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
