/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the most recent attempted or successful deployment to a deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastDeploymentInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LastDeploymentInfo.Builder, LastDeploymentInfo> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(LastDeploymentInfo::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LastDeploymentInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(LastDeploymentInfo::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(LastDeploymentInfo::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            STATUS_FIELD, END_TIME_FIELD, CREATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deploymentId", DEPLOYMENT_ID_FIELD);
                    put("status", STATUS_FIELD);
                    put("endTime", END_TIME_FIELD);
                    put("createTime", CREATE_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String status;

    private final Instant endTime;

    private final Instant createTime;

    private LastDeploymentInfo(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The status of the most recent deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the most recent deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the most recent deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the most recent deployment.
     * @see DeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that indicates when the most recent deployment to the deployment group was complete.
     * </p>
     * 
     * @return A timestamp that indicates when the most recent deployment to the deployment group was complete.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the most recent deployment to the deployment group started.
     * </p>
     * 
     * @return A timestamp that indicates when the most recent deployment to the deployment group started.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastDeploymentInfo)) {
            return false;
        }
        LastDeploymentInfo other = (LastDeploymentInfo) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastDeploymentInfo").add("DeploymentId", deploymentId()).add("Status", statusAsString())
                .add("EndTime", endTime()).add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LastDeploymentInfo, T> g) {
        return obj -> g.apply((LastDeploymentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastDeploymentInfo> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The status of the most recent deployment.
         * </p>
         * 
         * @param status
         *        The status of the most recent deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the most recent deployment.
         * </p>
         * 
         * @param status
         *        The status of the most recent deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * A timestamp that indicates when the most recent deployment to the deployment group was complete.
         * </p>
         * 
         * @param endTime
         *        A timestamp that indicates when the most recent deployment to the deployment group was complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A timestamp that indicates when the most recent deployment to the deployment group started.
         * </p>
         * 
         * @param createTime
         *        A timestamp that indicates when the most recent deployment to the deployment group started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String status;

        private Instant endTime;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastDeploymentInfo model) {
            deploymentId(model.deploymentId);
            status(model.status);
            endTime(model.endTime);
            createTime(model.createTime);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public LastDeploymentInfo build() {
            return new LastDeploymentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
