/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListDeploymentConfigs</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentConfigsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<ListDeploymentConfigsResponse.Builder, ListDeploymentConfigsResponse> {
    private static final SdkField<List<String>> DEPLOYMENT_CONFIGS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deploymentConfigsList")
            .getter(getter(ListDeploymentConfigsResponse::deploymentConfigsList))
            .setter(setter(Builder::deploymentConfigsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeploymentConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIGS_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deploymentConfigsList", DEPLOYMENT_CONFIGS_LIST_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> deploymentConfigsList;

    private final String nextToken;

    private ListDeploymentConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigsList = builder.deploymentConfigsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentConfigsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeploymentConfigsList() {
        return deploymentConfigsList != null && !(deploymentConfigsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of deployment configurations, including built-in configurations such as
     * <code>CodeDeployDefault.OneAtATime</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentConfigsList} method.
     * </p>
     * 
     * @return A list of deployment configurations, including built-in configurations such as
     *         <code>CodeDeployDefault.OneAtATime</code>.
     */
    public final List<String> deploymentConfigsList() {
        return deploymentConfigsList;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * deployment configurations call to return the next set of deployment configurations in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list deployment configurations call to return the next set of deployment configurations in the
     *         list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentConfigsList() ? deploymentConfigsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentConfigsResponse)) {
            return false;
        }
        ListDeploymentConfigsResponse other = (ListDeploymentConfigsResponse) obj;
        return hasDeploymentConfigsList() == other.hasDeploymentConfigsList()
                && Objects.equals(deploymentConfigsList(), other.deploymentConfigsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeploymentConfigsResponse")
                .add("DeploymentConfigsList", hasDeploymentConfigsList() ? deploymentConfigsList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentConfigsList":
            return Optional.ofNullable(clazz.cast(deploymentConfigsList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentConfigsResponse, T> g) {
        return obj -> g.apply((ListDeploymentConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDeploymentConfigsResponse> {
        /**
         * <p>
         * A list of deployment configurations, including built-in configurations such as
         * <code>CodeDeployDefault.OneAtATime</code>.
         * </p>
         * 
         * @param deploymentConfigsList
         *        A list of deployment configurations, including built-in configurations such as
         *        <code>CodeDeployDefault.OneAtATime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigsList(Collection<String> deploymentConfigsList);

        /**
         * <p>
         * A list of deployment configurations, including built-in configurations such as
         * <code>CodeDeployDefault.OneAtATime</code>.
         * </p>
         * 
         * @param deploymentConfigsList
         *        A list of deployment configurations, including built-in configurations such as
         *        <code>CodeDeployDefault.OneAtATime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigsList(String... deploymentConfigsList);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list deployment configurations call to return the next set of deployment configurations in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list deployment configurations call to return the next set of deployment configurations in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<String> deploymentConfigsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentConfigsResponse model) {
            super(model);
            deploymentConfigsList(model.deploymentConfigsList);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDeploymentConfigsList() {
            if (deploymentConfigsList instanceof SdkAutoConstructList) {
                return null;
            }
            return deploymentConfigsList;
        }

        public final void setDeploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
        }

        @Override
        public final Builder deploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentConfigsList(String... deploymentConfigsList) {
            deploymentConfigsList(Arrays.asList(deploymentConfigsList));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeploymentConfigsResponse build() {
            return new ListDeploymentConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
