/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a RegisterApplicationRevision operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterApplicationRevisionRequest extends CodeDeployRequest implements
        ToCopyableBuilder<RegisterApplicationRevisionRequest.Builder, RegisterApplicationRevisionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(RegisterApplicationRevisionRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RegisterApplicationRevisionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).memberName("revision")
            .getter(getter(RegisterApplicationRevisionRequest::revision)).setter(setter(Builder::revision))
            .constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DESCRIPTION_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("applicationName", APPLICATION_NAME_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("revision", REVISION_FIELD);
                }
            });

    private final String applicationName;

    private final String description;

    private final RevisionLocation revision;

    private RegisterApplicationRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The name of an CodeDeploy application associated with the user or Amazon Web Services account.
     * </p>
     * 
     * @return The name of an CodeDeploy application associated with the user or Amazon Web Services account.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * A comment about the revision.
     * </p>
     * 
     * @return A comment about the revision.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the application revision to register, including type and location.
     * </p>
     * 
     * @return Information about the application revision to register, including type and location.
     */
    public final RevisionLocation revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterApplicationRevisionRequest)) {
            return false;
        }
        RegisterApplicationRevisionRequest other = (RegisterApplicationRevisionRequest) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(description(), other.description())
                && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterApplicationRevisionRequest").add("ApplicationName", applicationName())
                .add("Description", description()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterApplicationRevisionRequest, T> g) {
        return obj -> g.apply((RegisterApplicationRevisionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterApplicationRevisionRequest> {
        /**
         * <p>
         * The name of an CodeDeploy application associated with the user or Amazon Web Services account.
         * </p>
         * 
         * @param applicationName
         *        The name of an CodeDeploy application associated with the user or Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * A comment about the revision.
         * </p>
         * 
         * @param description
         *        A comment about the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the application revision to register, including type and location.
         * </p>
         * 
         * @param revision
         *        Information about the application revision to register, including type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * Information about the application revision to register, including type and location.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevisionLocation.Builder} avoiding the
         * need to create one manually via {@link RevisionLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #revision(RevisionLocation)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(RevisionLocation)
         */
        default Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return revision(RevisionLocation.builder().applyMutation(revision).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String description;

        private RevisionLocation revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterApplicationRevisionRequest model) {
            super(model);
            applicationName(model.applicationName);
            description(model.description);
            revision(model.revision);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RevisionLocation.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterApplicationRevisionRequest build() {
            return new RegisterApplicationRevisionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
