/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateDeploymentGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeploymentGroupRequest extends CodeDeployRequest implements
        ToCopyableBuilder<UpdateDeploymentGroupRequest.Builder, UpdateDeploymentGroupRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(UpdateDeploymentGroupRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> CURRENT_DEPLOYMENT_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("currentDeploymentGroupName")
            .getter(getter(UpdateDeploymentGroupRequest::currentDeploymentGroupName))
            .setter(setter(Builder::currentDeploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentDeploymentGroupName").build())
            .build();

    private static final SdkField<String> NEW_DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newDeploymentGroupName").getter(getter(UpdateDeploymentGroupRequest::newDeploymentGroupName))
            .setter(setter(Builder::newDeploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newDeploymentGroupName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentConfigName").getter(getter(UpdateDeploymentGroupRequest::deploymentConfigName))
            .setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<List<EC2TagFilter>> EC2_TAG_FILTERS_FIELD = SdkField
            .<List<EC2TagFilter>> builder(MarshallingType.LIST)
            .memberName("ec2TagFilters")
            .getter(getter(UpdateDeploymentGroupRequest::ec2TagFilters))
            .setter(setter(Builder::ec2TagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("onPremisesInstanceTagFilters")
            .getter(getter(UpdateDeploymentGroupRequest::onPremisesInstanceTagFilters))
            .setter(setter(Builder::onPremisesInstanceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesInstanceTagFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoScalingGroups")
            .getter(getter(UpdateDeploymentGroupRequest::autoScalingGroups))
            .setter(setter(Builder::autoScalingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRoleArn").getter(getter(UpdateDeploymentGroupRequest::serviceRoleArn))
            .setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()).build();

    private static final SdkField<List<TriggerConfig>> TRIGGER_CONFIGURATIONS_FIELD = SdkField
            .<List<TriggerConfig>> builder(MarshallingType.LIST)
            .memberName("triggerConfigurations")
            .getter(getter(UpdateDeploymentGroupRequest::triggerConfigurations))
            .setter(setter(Builder::triggerConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TriggerConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(TriggerConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO).memberName("alarmConfiguration")
            .getter(getter(UpdateDeploymentGroupRequest::alarmConfiguration)).setter(setter(Builder::alarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmConfiguration").build())
            .build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration")
            .getter(getter(UpdateDeploymentGroupRequest::autoRollbackConfiguration))
            .setter(setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<String> OUTDATED_INSTANCES_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outdatedInstancesStrategy")
            .getter(getter(UpdateDeploymentGroupRequest::outdatedInstancesStrategyAsString))
            .setter(setter(Builder::outdatedInstancesStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outdatedInstancesStrategy").build())
            .build();

    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField
            .<DeploymentStyle> builder(MarshallingType.SDK_POJO).memberName("deploymentStyle")
            .getter(getter(UpdateDeploymentGroupRequest::deploymentStyle)).setter(setter(Builder::deploymentStyle))
            .constructor(DeploymentStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()).build();

    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<BlueGreenDeploymentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("blueGreenDeploymentConfiguration")
            .getter(getter(UpdateDeploymentGroupRequest::blueGreenDeploymentConfiguration))
            .setter(setter(Builder::blueGreenDeploymentConfiguration))
            .constructor(BlueGreenDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration")
                    .build()).build();

    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField
            .<LoadBalancerInfo> builder(MarshallingType.SDK_POJO).memberName("loadBalancerInfo")
            .getter(getter(UpdateDeploymentGroupRequest::loadBalancerInfo)).setter(setter(Builder::loadBalancerInfo))
            .constructor(LoadBalancerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()).build();

    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.<EC2TagSet> builder(MarshallingType.SDK_POJO)
            .memberName("ec2TagSet").getter(getter(UpdateDeploymentGroupRequest::ec2TagSet)).setter(setter(Builder::ec2TagSet))
            .constructor(EC2TagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()).build();

    private static final SdkField<List<ECSService>> ECS_SERVICES_FIELD = SdkField
            .<List<ECSService>> builder(MarshallingType.LIST)
            .memberName("ecsServices")
            .getter(getter(UpdateDeploymentGroupRequest::ecsServices))
            .setter(setter(Builder::ecsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSService> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OnPremisesTagSet> ON_PREMISES_TAG_SET_FIELD = SdkField
            .<OnPremisesTagSet> builder(MarshallingType.SDK_POJO).memberName("onPremisesTagSet")
            .getter(getter(UpdateDeploymentGroupRequest::onPremisesTagSet)).setter(setter(Builder::onPremisesTagSet))
            .constructor(OnPremisesTagSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSet").build()).build();

    private static final SdkField<Boolean> TERMINATION_HOOK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("terminationHookEnabled").getter(getter(UpdateDeploymentGroupRequest::terminationHookEnabled))
            .setter(setter(Builder::terminationHookEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminationHookEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_DEPLOYMENT_GROUP_NAME_FIELD, NEW_DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD,
            EC2_TAG_FILTERS_FIELD, ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, SERVICE_ROLE_ARN_FIELD,
            TRIGGER_CONFIGURATIONS_FIELD, ALARM_CONFIGURATION_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD,
            OUTDATED_INSTANCES_STRATEGY_FIELD, DEPLOYMENT_STYLE_FIELD, BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD,
            LOAD_BALANCER_INFO_FIELD, EC2_TAG_SET_FIELD, ECS_SERVICES_FIELD, ON_PREMISES_TAG_SET_FIELD,
            TERMINATION_HOOK_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("applicationName", APPLICATION_NAME_FIELD);
                    put("currentDeploymentGroupName", CURRENT_DEPLOYMENT_GROUP_NAME_FIELD);
                    put("newDeploymentGroupName", NEW_DEPLOYMENT_GROUP_NAME_FIELD);
                    put("deploymentConfigName", DEPLOYMENT_CONFIG_NAME_FIELD);
                    put("ec2TagFilters", EC2_TAG_FILTERS_FIELD);
                    put("onPremisesInstanceTagFilters", ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD);
                    put("autoScalingGroups", AUTO_SCALING_GROUPS_FIELD);
                    put("serviceRoleArn", SERVICE_ROLE_ARN_FIELD);
                    put("triggerConfigurations", TRIGGER_CONFIGURATIONS_FIELD);
                    put("alarmConfiguration", ALARM_CONFIGURATION_FIELD);
                    put("autoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
                    put("outdatedInstancesStrategy", OUTDATED_INSTANCES_STRATEGY_FIELD);
                    put("deploymentStyle", DEPLOYMENT_STYLE_FIELD);
                    put("blueGreenDeploymentConfiguration", BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD);
                    put("loadBalancerInfo", LOAD_BALANCER_INFO_FIELD);
                    put("ec2TagSet", EC2_TAG_SET_FIELD);
                    put("ecsServices", ECS_SERVICES_FIELD);
                    put("onPremisesTagSet", ON_PREMISES_TAG_SET_FIELD);
                    put("terminationHookEnabled", TERMINATION_HOOK_ENABLED_FIELD);
                }
            });

    private final String applicationName;

    private final String currentDeploymentGroupName;

    private final String newDeploymentGroupName;

    private final String deploymentConfigName;

    private final List<EC2TagFilter> ec2TagFilters;

    private final List<TagFilter> onPremisesInstanceTagFilters;

    private final List<String> autoScalingGroups;

    private final String serviceRoleArn;

    private final List<TriggerConfig> triggerConfigurations;

    private final AlarmConfiguration alarmConfiguration;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final String outdatedInstancesStrategy;

    private final DeploymentStyle deploymentStyle;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private final EC2TagSet ec2TagSet;

    private final List<ECSService> ecsServices;

    private final OnPremisesTagSet onPremisesTagSet;

    private final Boolean terminationHookEnabled;

    private UpdateDeploymentGroupRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentDeploymentGroupName = builder.currentDeploymentGroupName;
        this.newDeploymentGroupName = builder.newDeploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.outdatedInstancesStrategy = builder.outdatedInstancesStrategy;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.ec2TagSet = builder.ec2TagSet;
        this.ecsServices = builder.ecsServices;
        this.onPremisesTagSet = builder.onPremisesTagSet;
        this.terminationHookEnabled = builder.terminationHookEnabled;
    }

    /**
     * <p>
     * The application name that corresponds to the deployment group to update.
     * </p>
     * 
     * @return The application name that corresponds to the deployment group to update.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current name of the deployment group.
     * </p>
     * 
     * @return The current name of the deployment group.
     */
    public final String currentDeploymentGroupName() {
        return currentDeploymentGroupName;
    }

    /**
     * <p>
     * The new name of the deployment group, if you want to change it.
     * </p>
     * 
     * @return The new name of the deployment group, if you want to change it.
     */
    public final String newDeploymentGroupName() {
        return newDeploymentGroupName;
    }

    /**
     * <p>
     * The replacement deployment configuration name to use, if you want to change it.
     * </p>
     * 
     * @return The replacement deployment configuration name to use, if you want to change it.
     */
    public final String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2TagFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2TagFilters() {
        return ec2TagFilters != null && !(ec2TagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags,
     * enter their names. To remove tags, do not enter any tag names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2TagFilters} method.
     * </p>
     * 
     * @return The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
     *         existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public final List<EC2TagFilter> ec2TagFilters() {
        return ec2TagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnPremisesInstanceTagFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOnPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters != null && !(onPremisesInstanceTagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
     * existing tags, enter their names. To remove tags, do not enter any tag names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnPremisesInstanceTagFilters} method.
     * </p>
     * 
     * @return The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep
     *         the existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public final List<TagFilter> onPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoScalingGroups() {
        return autoScalingGroups != null && !(autoScalingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To keep the Auto Scaling groups, enter their names or do not specify this parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all
     * CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat"
     * >Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error
     * "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingGroups} method.
     * </p>
     * 
     * @return The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
     *         them.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To keep the Auto Scaling groups, enter their names or do not specify this parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all
     *         CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat"
     *         >Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error
     *         "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.
     *         </p>
     *         </li>
     */
    public final List<String> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * A replacement ARN for the service role, if you want to change it.
     * </p>
     * 
     * @return A replacement ARN for the service role, if you want to change it.
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TriggerConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTriggerConfigurations() {
        return triggerConfigurations != null && !(triggerConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about triggers to change when the deployment group is updated. For examples, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
     * CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggerConfigurations} method.
     * </p>
     * 
     * @return Information about triggers to change when the deployment group is updated. For examples, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in
     *         a CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
     */
    public final List<TriggerConfig> triggerConfigurations() {
        return triggerConfigurations;
    }

    /**
     * <p>
     * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     * </p>
     * 
     * @return Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     */
    public final AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * <p>
     * Information for an automatic rollback configuration that is added or changed when a deployment group is updated.
     * </p>
     * 
     * @return Information for an automatic rollback configuration that is added or changed when a deployment group is
     *         updated.
     */
    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed
     * application revision.
     * </p>
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
     * outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     * </p>
     * <p>
     * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new Amazon
     * EC2 instances. This may result in instances having different revisions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outdatedInstancesStrategy} will return {@link OutdatedInstancesStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #outdatedInstancesStrategyAsString}.
     * </p>
     * 
     * @return Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the
     *         deployed application revision.</p>
     *         <p>
     *         If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
     *         'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon
     *         EC2 instances.
     *         </p>
     *         <p>
     *         If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new
     *         Amazon EC2 instances. This may result in instances having different revisions.
     * @see OutdatedInstancesStrategy
     */
    public final OutdatedInstancesStrategy outdatedInstancesStrategy() {
        return OutdatedInstancesStrategy.fromValue(outdatedInstancesStrategy);
    }

    /**
     * <p>
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed
     * application revision.
     * </p>
     * <p>
     * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
     * outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     * </p>
     * <p>
     * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new Amazon
     * EC2 instances. This may result in instances having different revisions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outdatedInstancesStrategy} will return {@link OutdatedInstancesStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #outdatedInstancesStrategyAsString}.
     * </p>
     * 
     * @return Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the
     *         deployed application revision.</p>
     *         <p>
     *         If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
     *         'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon
     *         EC2 instances.
     *         </p>
     *         <p>
     *         If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new
     *         Amazon EC2 instances. This may result in instances having different revisions.
     * @see OutdatedInstancesStrategy
     */
    public final String outdatedInstancesStrategyAsString() {
        return outdatedInstancesStrategy;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public final DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about blue/green deployment options for a deployment group.
     * </p>
     * 
     * @return Information about blue/green deployment options for a deployment group.
     */
    public final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer used in a deployment.
     * </p>
     * 
     * @return Information about the load balancer used in a deployment.
     */
    public final LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    /**
     * <p>
     * Information about groups of tags applied to on-premises instances. The deployment group includes only Amazon EC2
     * instances identified by all the tag groups.
     * </p>
     * 
     * @return Information about groups of tags applied to on-premises instances. The deployment group includes only
     *         Amazon EC2 instances identified by all the tag groups.
     */
    public final EC2TagSet ec2TagSet() {
        return ec2TagSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcsServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcsServices() {
        return ecsServices != null && !(ecsServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
     * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name
     * pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcsServices} method.
     * </p>
     * 
     * @return The target Amazon ECS services in the deployment group. This applies only to deployment groups that use
     *         the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and
     *         service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
     */
    public final List<ECSService> ecsServices() {
        return ecsServices;
    }

    /**
     * <p>
     * Information about an on-premises instance tag set. The deployment group includes only on-premises instances
     * identified by all the tag groups.
     * </p>
     * 
     * @return Information about an on-premises instance tag set. The deployment group includes only on-premises
     *         instances identified by all the tag groups.
     */
    public final OnPremisesTagSet onPremisesTagSet() {
        return onPremisesTagSet;
    }

    /**
     * <p>
     * This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more information, see
     * <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html">Integrating
     * CodeDeploy with Amazon EC2 Auto Scaling</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * <p>
     * Set <code>terminationHookEnabled</code> to <code>true</code> to have CodeDeploy install a termination hook into
     * your Auto Scaling group when you update a deployment group. When this hook is installed, CodeDeploy will perform
     * termination deployments.
     * </p>
     * <p>
     * For information about termination deployments, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
     * >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * <p>
     * For more information about Auto Scaling scale-in events, see the <a href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in"
     * >Scale in</a> topic in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html"
     *         >Integrating CodeDeploy with Amazon EC2 Auto Scaling</a> in the <i>CodeDeploy User Guide</i>.</p>
     *         <p>
     *         Set <code>terminationHookEnabled</code> to <code>true</code> to have CodeDeploy install a termination
     *         hook into your Auto Scaling group when you update a deployment group. When this hook is installed,
     *         CodeDeploy will perform termination deployments.
     *         </p>
     *         <p>
     *         For information about termination deployments, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
     *         >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         For more information about Auto Scaling scale-in events, see the <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in"
     *         >Scale in</a> topic in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean terminationHookEnabled() {
        return terminationHookEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentDeploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(newDeploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2TagFilters() ? ec2TagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOnPremisesInstanceTagFilters() ? onPremisesInstanceTagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroups() ? autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggerConfigurations() ? triggerConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(outdatedInstancesStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(hasEcsServices() ? ecsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(onPremisesTagSet());
        hashCode = 31 * hashCode + Objects.hashCode(terminationHookEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentDeploymentGroupName(), other.currentDeploymentGroupName())
                && Objects.equals(newDeploymentGroupName(), other.newDeploymentGroupName())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && hasEc2TagFilters() == other.hasEc2TagFilters() && Objects.equals(ec2TagFilters(), other.ec2TagFilters())
                && hasOnPremisesInstanceTagFilters() == other.hasOnPremisesInstanceTagFilters()
                && Objects.equals(onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters())
                && hasAutoScalingGroups() == other.hasAutoScalingGroups()
                && Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && hasTriggerConfigurations() == other.hasTriggerConfigurations()
                && Objects.equals(triggerConfigurations(), other.triggerConfigurations())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(outdatedInstancesStrategyAsString(), other.outdatedInstancesStrategyAsString())
                && Objects.equals(deploymentStyle(), other.deploymentStyle())
                && Objects.equals(blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration())
                && Objects.equals(loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(ec2TagSet(), other.ec2TagSet())
                && hasEcsServices() == other.hasEcsServices() && Objects.equals(ecsServices(), other.ecsServices())
                && Objects.equals(onPremisesTagSet(), other.onPremisesTagSet())
                && Objects.equals(terminationHookEnabled(), other.terminationHookEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeploymentGroupRequest").add("ApplicationName", applicationName())
                .add("CurrentDeploymentGroupName", currentDeploymentGroupName())
                .add("NewDeploymentGroupName", newDeploymentGroupName()).add("DeploymentConfigName", deploymentConfigName())
                .add("Ec2TagFilters", hasEc2TagFilters() ? ec2TagFilters() : null)
                .add("OnPremisesInstanceTagFilters", hasOnPremisesInstanceTagFilters() ? onPremisesInstanceTagFilters() : null)
                .add("AutoScalingGroups", hasAutoScalingGroups() ? autoScalingGroups() : null)
                .add("ServiceRoleArn", serviceRoleArn())
                .add("TriggerConfigurations", hasTriggerConfigurations() ? triggerConfigurations() : null)
                .add("AlarmConfiguration", alarmConfiguration()).add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .add("OutdatedInstancesStrategy", outdatedInstancesStrategyAsString()).add("DeploymentStyle", deploymentStyle())
                .add("BlueGreenDeploymentConfiguration", blueGreenDeploymentConfiguration())
                .add("LoadBalancerInfo", loadBalancerInfo()).add("Ec2TagSet", ec2TagSet())
                .add("EcsServices", hasEcsServices() ? ecsServices() : null).add("OnPremisesTagSet", onPremisesTagSet())
                .add("TerminationHookEnabled", terminationHookEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "currentDeploymentGroupName":
            return Optional.ofNullable(clazz.cast(currentDeploymentGroupName()));
        case "newDeploymentGroupName":
            return Optional.ofNullable(clazz.cast(newDeploymentGroupName()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "ec2TagFilters":
            return Optional.ofNullable(clazz.cast(ec2TagFilters()));
        case "onPremisesInstanceTagFilters":
            return Optional.ofNullable(clazz.cast(onPremisesInstanceTagFilters()));
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "serviceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "triggerConfigurations":
            return Optional.ofNullable(clazz.cast(triggerConfigurations()));
        case "alarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "outdatedInstancesStrategy":
            return Optional.ofNullable(clazz.cast(outdatedInstancesStrategyAsString()));
        case "deploymentStyle":
            return Optional.ofNullable(clazz.cast(deploymentStyle()));
        case "blueGreenDeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentConfiguration()));
        case "loadBalancerInfo":
            return Optional.ofNullable(clazz.cast(loadBalancerInfo()));
        case "ec2TagSet":
            return Optional.ofNullable(clazz.cast(ec2TagSet()));
        case "ecsServices":
            return Optional.ofNullable(clazz.cast(ecsServices()));
        case "onPremisesTagSet":
            return Optional.ofNullable(clazz.cast(onPremisesTagSet()));
        case "terminationHookEnabled":
            return Optional.ofNullable(clazz.cast(terminationHookEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentGroupRequest, T> g) {
        return obj -> g.apply((UpdateDeploymentGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeploymentGroupRequest> {
        /**
         * <p>
         * The application name that corresponds to the deployment group to update.
         * </p>
         * 
         * @param applicationName
         *        The application name that corresponds to the deployment group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current name of the deployment group.
         * </p>
         * 
         * @param currentDeploymentGroupName
         *        The current name of the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDeploymentGroupName(String currentDeploymentGroupName);

        /**
         * <p>
         * The new name of the deployment group, if you want to change it.
         * </p>
         * 
         * @param newDeploymentGroupName
         *        The new name of the deployment group, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDeploymentGroupName(String newDeploymentGroupName);

        /**
         * <p>
         * The replacement deployment configuration name to use, if you want to change it.
         * </p>
         * 
         * @param deploymentConfigName
         *        The replacement deployment configuration name to use, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param ec2TagFilters
         *        The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
         *        existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param ec2TagFilters
         *        The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
         *        existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(EC2TagFilter... ec2TagFilters);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.EC2TagFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codedeploy.model.EC2TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.EC2TagFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2TagFilters(List<EC2TagFilter>)}.
         * 
         * @param ec2TagFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.EC2TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagFilters(java.util.Collection<EC2TagFilter>)
         */
        Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The replacement set of on-premises instance tags on which to filter, if you want to change them. To
         *        keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The replacement set of on-premises instance tags on which to filter, if you want to change them. To
         *        keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.TagFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codedeploy.model.TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.TagFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #onPremisesInstanceTagFilters(List<TagFilter>)}.
         * 
         * @param onPremisesInstanceTagFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesInstanceTagFilters(java.util.Collection<TagFilter>)
         */
        Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
         * them.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To keep the Auto Scaling groups, enter their names or do not specify this parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all
         * CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat"
         * >Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error
         * "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoScalingGroups
         *        The replacement list of Auto Scaling groups to be included in the deployment group, if you want to
         *        change them.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To keep the Auto Scaling groups, enter their names or do not specify this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all
         *        CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat"
         *        >Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error
         *        "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<String> autoScalingGroups);

        /**
         * <p>
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
         * them.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To keep the Auto Scaling groups, enter their names or do not specify this parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all
         * CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat"
         * >Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error
         * "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoScalingGroups
         *        The replacement list of Auto Scaling groups to be included in the deployment group, if you want to
         *        change them.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To keep the Auto Scaling groups, enter their names or do not specify this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all
         *        CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat"
         *        >Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error
         *        "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(String... autoScalingGroups);

        /**
         * <p>
         * A replacement ARN for the service role, if you want to change it.
         * </p>
         * 
         * @param serviceRoleArn
         *        A replacement ARN for the service role, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
         * CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers to change when the deployment group is updated. For examples, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger
         *        in a CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
         * CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers to change when the deployment group is updated. For examples, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger
         *        in a CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(TriggerConfig... triggerConfigurations);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a
         * CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.TriggerConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codedeploy.model.TriggerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.TriggerConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #triggerConfigurations(List<TriggerConfig>)}.
         * 
         * @param triggerConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.TriggerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfigurations(java.util.Collection<TriggerConfig>)
         */
        Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations);

        /**
         * <p>
         * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * </p>
         * 
         * @param alarmConfiguration
         *        Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the
         * need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }

        /**
         * <p>
         * Information for an automatic rollback configuration that is added or changed when a deployment group is
         * updated.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information for an automatic rollback configuration that is added or changed when a deployment group
         *        is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information for an automatic rollback configuration that is added or changed when a deployment group is
         * updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoRollbackConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the
         * deployed application revision.
         * </p>
         * <p>
         * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
         * outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
         * </p>
         * <p>
         * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new
         * Amazon EC2 instances. This may result in instances having different revisions.
         * </p>
         * 
         * @param outdatedInstancesStrategy
         *        Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive
         *        the deployed application revision.</p>
         *        <p>
         *        If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
         *        'auto-update outdated instances' deployments to apply the deployed application revision to the new
         *        Amazon EC2 instances.
         *        </p>
         *        <p>
         *        If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the
         *        new Amazon EC2 instances. This may result in instances having different revisions.
         * @see OutdatedInstancesStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutdatedInstancesStrategy
         */
        Builder outdatedInstancesStrategy(String outdatedInstancesStrategy);

        /**
         * <p>
         * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the
         * deployed application revision.
         * </p>
         * <p>
         * If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more 'auto-update
         * outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
         * </p>
         * <p>
         * If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new
         * Amazon EC2 instances. This may result in instances having different revisions.
         * </p>
         * 
         * @param outdatedInstancesStrategy
         *        Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive
         *        the deployed application revision.</p>
         *        <p>
         *        If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more
         *        'auto-update outdated instances' deployments to apply the deployed application revision to the new
         *        Amazon EC2 instances.
         *        </p>
         *        <p>
         *        If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the
         *        new Amazon EC2 instances. This may result in instances having different revisions.
         * @see OutdatedInstancesStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutdatedInstancesStrategy
         */
        Builder outdatedInstancesStrategy(OutdatedInstancesStrategy outdatedInstancesStrategy);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentStyle.Builder} avoiding the
         * need to create one manually via {@link DeploymentStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentStyle(DeploymentStyle)}.
         * 
         * @param deploymentStyle
         *        a consumer that will call methods on {@link DeploymentStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentStyle(DeploymentStyle)
         */
        default Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return deploymentStyle(DeploymentStyle.builder().applyMutation(deploymentStyle).build());
        }

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for a deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlueGreenDeploymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlueGreenDeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlueGreenDeploymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)}.
         * 
         * @param blueGreenDeploymentConfiguration
         *        a consumer that will call methods on {@link BlueGreenDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration)
         */
        default Builder blueGreenDeploymentConfiguration(
                Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.builder()
                    .applyMutation(blueGreenDeploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about the load balancer used in a deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer used in a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);

        /**
         * <p>
         * Information about the load balancer used in a deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadBalancerInfo.Builder} avoiding the
         * need to create one manually via {@link LoadBalancerInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoadBalancerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancerInfo(LoadBalancerInfo)}.
         * 
         * @param loadBalancerInfo
         *        a consumer that will call methods on {@link LoadBalancerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerInfo(LoadBalancerInfo)
         */
        default Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return loadBalancerInfo(LoadBalancerInfo.builder().applyMutation(loadBalancerInfo).build());
        }

        /**
         * <p>
         * Information about groups of tags applied to on-premises instances. The deployment group includes only Amazon
         * EC2 instances identified by all the tag groups.
         * </p>
         * 
         * @param ec2TagSet
         *        Information about groups of tags applied to on-premises instances. The deployment group includes only
         *        Amazon EC2 instances identified by all the tag groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSet(EC2TagSet ec2TagSet);

        /**
         * <p>
         * Information about groups of tags applied to on-premises instances. The deployment group includes only Amazon
         * EC2 instances identified by all the tag groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link EC2TagSet.Builder} avoiding the need to
         * create one manually via {@link EC2TagSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EC2TagSet.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2TagSet(EC2TagSet)}.
         * 
         * @param ec2TagSet
         *        a consumer that will call methods on {@link EC2TagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2TagSet(EC2TagSet)
         */
        default Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return ec2TagSet(EC2TagSet.builder().applyMutation(ec2TagSet).build());
        }

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target Amazon ECS services in the deployment group. This applies only to deployment groups that
         *        use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster
         *        and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(Collection<ECSService> ecsServices);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * 
         * @param ecsServices
         *        The target Amazon ECS services in the deployment group. This applies only to deployment groups that
         *        use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster
         *        and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsServices(ECSService... ecsServices);

        /**
         * <p>
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the
         * Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service
         * name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.ECSService.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codedeploy.model.ECSService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.ECSService.Builder#build()} is called immediately and
         * its result is passed to {@link #ecsServices(List<ECSService>)}.
         * 
         * @param ecsServices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.ECSService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsServices(java.util.Collection<ECSService>)
         */
        Builder ecsServices(Consumer<ECSService.Builder>... ecsServices);

        /**
         * <p>
         * Information about an on-premises instance tag set. The deployment group includes only on-premises instances
         * identified by all the tag groups.
         * </p>
         * 
         * @param onPremisesTagSet
         *        Information about an on-premises instance tag set. The deployment group includes only on-premises
         *        instances identified by all the tag groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet);

        /**
         * <p>
         * Information about an on-premises instance tag set. The deployment group includes only on-premises instances
         * identified by all the tag groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnPremisesTagSet.Builder} avoiding the
         * need to create one manually via {@link OnPremisesTagSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnPremisesTagSet.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremisesTagSet(OnPremisesTagSet)}.
         * 
         * @param onPremisesTagSet
         *        a consumer that will call methods on {@link OnPremisesTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremisesTagSet(OnPremisesTagSet)
         */
        default Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return onPremisesTagSet(OnPremisesTagSet.builder().applyMutation(onPremisesTagSet).build());
        }

        /**
         * <p>
         * This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more information,
         * see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html">
         * Integrating CodeDeploy with Amazon EC2 Auto Scaling</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * <p>
         * Set <code>terminationHookEnabled</code> to <code>true</code> to have CodeDeploy install a termination hook
         * into your Auto Scaling group when you update a deployment group. When this hook is installed, CodeDeploy will
         * perform termination deployments.
         * </p>
         * <p>
         * For information about termination deployments, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
         * >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User
         * Guide</i>.
         * </p>
         * <p>
         * For more information about Auto Scaling scale-in events, see the <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in"
         * >Scale in</a> topic in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationHookEnabled
         *        This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html"
         *        >Integrating CodeDeploy with Amazon EC2 Auto Scaling</a> in the <i>CodeDeploy User Guide</i>.</p>
         *        <p>
         *        Set <code>terminationHookEnabled</code> to <code>true</code> to have CodeDeploy install a termination
         *        hook into your Auto Scaling group when you update a deployment group. When this hook is installed,
         *        CodeDeploy will perform termination deployments.
         *        </p>
         *        <p>
         *        For information about termination deployments, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable"
         *        >Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        For more information about Auto Scaling scale-in events, see the <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in"
         *        >Scale in</a> topic in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationHookEnabled(Boolean terminationHookEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String currentDeploymentGroupName;

        private String newDeploymentGroupName;

        private String deploymentConfigName;

        private List<EC2TagFilter> ec2TagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> onPremisesInstanceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();

        private String serviceRoleArn;

        private List<TriggerConfig> triggerConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AlarmConfiguration alarmConfiguration;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private String outdatedInstancesStrategy;

        private DeploymentStyle deploymentStyle;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private EC2TagSet ec2TagSet;

        private List<ECSService> ecsServices = DefaultSdkAutoConstructList.getInstance();

        private OnPremisesTagSet onPremisesTagSet;

        private Boolean terminationHookEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentGroupRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentDeploymentGroupName(model.currentDeploymentGroupName);
            newDeploymentGroupName(model.newDeploymentGroupName);
            deploymentConfigName(model.deploymentConfigName);
            ec2TagFilters(model.ec2TagFilters);
            onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            autoScalingGroups(model.autoScalingGroups);
            serviceRoleArn(model.serviceRoleArn);
            triggerConfigurations(model.triggerConfigurations);
            alarmConfiguration(model.alarmConfiguration);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            outdatedInstancesStrategy(model.outdatedInstancesStrategy);
            deploymentStyle(model.deploymentStyle);
            blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            loadBalancerInfo(model.loadBalancerInfo);
            ec2TagSet(model.ec2TagSet);
            ecsServices(model.ecsServices);
            onPremisesTagSet(model.onPremisesTagSet);
            terminationHookEnabled(model.terminationHookEnabled);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getCurrentDeploymentGroupName() {
            return currentDeploymentGroupName;
        }

        public final void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
        }

        @Override
        public final Builder currentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
            return this;
        }

        public final String getNewDeploymentGroupName() {
            return newDeploymentGroupName;
        }

        public final void setNewDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
        }

        @Override
        public final Builder newDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
            return this;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final List<EC2TagFilter.Builder> getEc2TagFilters() {
            List<EC2TagFilter.Builder> result = EC2TagFilterListCopier.copyToBuilder(this.ec2TagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter... ec2TagFilters) {
            ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(Consumer<EC2TagFilter.Builder>... ec2TagFilters) {
            ec2TagFilters(Stream.of(ec2TagFilters).map(c -> EC2TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.onPremisesInstanceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder>... onPremisesInstanceTagFilters) {
            onPremisesInstanceTagFilters(Stream.of(onPremisesInstanceTagFilters)
                    .map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAutoScalingGroups() {
            if (autoScalingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingGroups;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String... autoScalingGroups) {
            autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final List<TriggerConfig.Builder> getTriggerConfigurations() {
            List<TriggerConfig.Builder> result = TriggerConfigListCopier.copyToBuilder(this.triggerConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig... triggerConfigurations) {
            triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(Consumer<TriggerConfig.Builder>... triggerConfigurations) {
            triggerConfigurations(Stream.of(triggerConfigurations).map(c -> TriggerConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final String getOutdatedInstancesStrategy() {
            return outdatedInstancesStrategy;
        }

        public final void setOutdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
        }

        @Override
        public final Builder outdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
            return this;
        }

        @Override
        public final Builder outdatedInstancesStrategy(OutdatedInstancesStrategy outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy(outdatedInstancesStrategy == null ? null : outdatedInstancesStrategy.toString());
            return this;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return deploymentStyle != null ? deploymentStyle.toBuilder() : null;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        public final void setBlueGreenDeploymentConfiguration(
                BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return loadBalancerInfo != null ? loadBalancerInfo.toBuilder() : null;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return ec2TagSet != null ? ec2TagSet.toBuilder() : null;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final List<ECSService.Builder> getEcsServices() {
            List<ECSService.Builder> result = ECSServiceListCopier.copyToBuilder(this.ecsServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcsServices(Collection<ECSService.BuilderImpl> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copyFromBuilder(ecsServices);
        }

        @Override
        public final Builder ecsServices(Collection<ECSService> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copy(ecsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(ECSService... ecsServices) {
            ecsServices(Arrays.asList(ecsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(Consumer<ECSService.Builder>... ecsServices) {
            ecsServices(Stream.of(ecsServices).map(c -> ECSService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return onPremisesTagSet != null ? onPremisesTagSet.toBuilder() : null;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        @Override
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final Boolean getTerminationHookEnabled() {
            return terminationHookEnabled;
        }

        public final void setTerminationHookEnabled(Boolean terminationHookEnabled) {
            this.terminationHookEnabled = terminationHookEnabled;
        }

        @Override
        public final Builder terminationHookEnabled(Boolean terminationHookEnabled) {
            this.terminationHookEnabled = terminationHookEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeploymentGroupRequest build() {
            return new UpdateDeploymentGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
