/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDeploymentsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, BatchGetDeploymentsRequest> {
    private static final SdkField<List<String>> DEPLOYMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentIds").getter(BatchGetDeploymentsRequest.getter(BatchGetDeploymentsRequest::deploymentIds)).setter(BatchGetDeploymentsRequest.setter(Builder::deploymentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("deploymentIds", DEPLOYMENT_IDS_FIELD);
        }
    });
    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentIds = builder.deploymentIds;
    }

    public final boolean hasDeploymentIds() {
        return this.deploymentIds != null && !(this.deploymentIds instanceof SdkAutoConstructList);
    }

    public final List<String> deploymentIds() {
        return this.deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentIds() ? this.deploymentIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest)((Object)obj);
        return this.hasDeploymentIds() == other.hasDeploymentIds() && Objects.equals(this.deploymentIds(), other.deploymentIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDeploymentsRequest").add("DeploymentIds", this.hasDeploymentIds() ? this.deploymentIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentIds": {
                return Optional.ofNullable(clazz.cast(this.deploymentIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentsRequest, T> g) {
        return obj -> g.apply((BatchGetDeploymentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private List<String> deploymentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            super(model);
            this.deploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            if (this.deploymentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deploymentIds;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String ... deploymentIds) {
            this.deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        public Builder deploymentIds(Collection<String> var1);

        public Builder deploymentIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

