/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchGetDeploymentGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentGroupsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<BatchGetDeploymentGroupsResponse.Builder, BatchGetDeploymentGroupsResponse> {
    private static final SdkField<List<DeploymentGroupInfo>> DEPLOYMENT_GROUPS_INFO_FIELD = SdkField
            .<List<DeploymentGroupInfo>> builder(MarshallingType.LIST)
            .memberName("deploymentGroupsInfo")
            .getter(getter(BatchGetDeploymentGroupsResponse::deploymentGroupsInfo))
            .setter(setter(Builder::deploymentGroupsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentGroupInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentGroupInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchGetDeploymentGroupsResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_GROUPS_INFO_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deploymentGroupsInfo", DEPLOYMENT_GROUPS_INFO_FIELD);
                    put("errorMessage", ERROR_MESSAGE_FIELD);
                }
            });

    private final List<DeploymentGroupInfo> deploymentGroupsInfo;

    private final String errorMessage;

    private BatchGetDeploymentGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentGroupsInfo = builder.deploymentGroupsInfo;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentGroupsInfo property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentGroupsInfo() {
        return deploymentGroupsInfo != null && !(deploymentGroupsInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the deployment groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentGroupsInfo} method.
     * </p>
     * 
     * @return Information about the deployment groups.
     */
    public final List<DeploymentGroupInfo> deploymentGroupsInfo() {
        return deploymentGroupsInfo;
    }

    /**
     * <p>
     * Information about errors that might have occurred during the API call.
     * </p>
     * 
     * @return Information about errors that might have occurred during the API call.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentGroupsInfo() ? deploymentGroupsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsResponse)) {
            return false;
        }
        BatchGetDeploymentGroupsResponse other = (BatchGetDeploymentGroupsResponse) obj;
        return hasDeploymentGroupsInfo() == other.hasDeploymentGroupsInfo()
                && Objects.equals(deploymentGroupsInfo(), other.deploymentGroupsInfo())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDeploymentGroupsResponse")
                .add("DeploymentGroupsInfo", hasDeploymentGroupsInfo() ? deploymentGroupsInfo() : null)
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentGroupsInfo":
            return Optional.ofNullable(clazz.cast(deploymentGroupsInfo()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentGroupsResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * 
         * @param deploymentGroupsInfo
         *        Information about the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo);

        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * 
         * @param deploymentGroupsInfo
         *        Information about the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo);

        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #deploymentGroupsInfo(List<DeploymentGroupInfo>)}.
         * 
         * @param deploymentGroupsInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentGroupsInfo(java.util.Collection<DeploymentGroupInfo>)
         */
        Builder deploymentGroupsInfo(Consumer<DeploymentGroupInfo.Builder>... deploymentGroupsInfo);

        /**
         * <p>
         * Information about errors that might have occurred during the API call.
         * </p>
         * 
         * @param errorMessage
         *        Information about errors that might have occurred during the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<DeploymentGroupInfo> deploymentGroupsInfo = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsResponse model) {
            super(model);
            deploymentGroupsInfo(model.deploymentGroupsInfo);
            errorMessage(model.errorMessage);
        }

        public final List<DeploymentGroupInfo.Builder> getDeploymentGroupsInfo() {
            List<DeploymentGroupInfo.Builder> result = DeploymentGroupInfoListCopier.copyToBuilder(this.deploymentGroupsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentGroupsInfo(Collection<DeploymentGroupInfo.BuilderImpl> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copyFromBuilder(deploymentGroupsInfo);
        }

        @Override
        public final Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo) {
            deploymentGroupsInfo(Arrays.asList(deploymentGroupsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(Consumer<DeploymentGroupInfo.Builder>... deploymentGroupsInfo) {
            deploymentGroupsInfo(Stream.of(deploymentGroupsInfo).map(c -> DeploymentGroupInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchGetDeploymentGroupsResponse build() {
            return new BatchGetDeploymentGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
