/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>BatchGetDeployments</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<BatchGetDeploymentsRequest.Builder, BatchGetDeploymentsRequest> {
    private static final SdkField<List<String>> DEPLOYMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deploymentIds")
            .getter(getter(BatchGetDeploymentsRequest::deploymentIds))
            .setter(setter(Builder::deploymentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deploymentIds", DEPLOYMENT_IDS_FIELD);
                }
            });

    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentIds = builder.deploymentIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentIds() {
        return deploymentIds != null && !(deploymentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentIds} method.
     * </p>
     * 
     * @return A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is
     *         25.
     */
    public final List<String> deploymentIds() {
        return deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentIds() ? deploymentIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest) obj;
        return hasDeploymentIds() == other.hasDeploymentIds() && Objects.equals(deploymentIds(), other.deploymentIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDeploymentsRequest").add("DeploymentIds", hasDeploymentIds() ? deploymentIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentIds":
            return Optional.ofNullable(clazz.cast(deploymentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentsRequest, T> g) {
        return obj -> g.apply((BatchGetDeploymentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        /**
         * <p>
         * A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.
         * </p>
         * 
         * @param deploymentIds
         *        A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is
         *        25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(Collection<String> deploymentIds);

        /**
         * <p>
         * A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.
         * </p>
         * 
         * @param deploymentIds
         *        A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is
         *        25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(String... deploymentIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private List<String> deploymentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            super(model);
            deploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            if (deploymentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return deploymentIds;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String... deploymentIds) {
            deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
