/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateDeploymentConfig</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentConfigRequest extends CodeDeployRequest implements
        ToCopyableBuilder<CreateDeploymentConfigRequest.Builder, CreateDeploymentConfigRequest> {
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentConfigName").getter(getter(CreateDeploymentConfigRequest::deploymentConfigName))
            .setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<MinimumHealthyHosts> MINIMUM_HEALTHY_HOSTS_FIELD = SdkField
            .<MinimumHealthyHosts> builder(MarshallingType.SDK_POJO).memberName("minimumHealthyHosts")
            .getter(getter(CreateDeploymentConfigRequest::minimumHealthyHosts)).setter(setter(Builder::minimumHealthyHosts))
            .constructor(MinimumHealthyHosts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHosts").build())
            .build();

    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIG_FIELD = SdkField
            .<TrafficRoutingConfig> builder(MarshallingType.SDK_POJO).memberName("trafficRoutingConfig")
            .getter(getter(CreateDeploymentConfigRequest::trafficRoutingConfig)).setter(setter(Builder::trafficRoutingConfig))
            .constructor(TrafficRoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficRoutingConfig").build())
            .build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computePlatform").getter(getter(CreateDeploymentConfigRequest::computePlatformAsString))
            .setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<ZonalConfig> ZONAL_CONFIG_FIELD = SdkField.<ZonalConfig> builder(MarshallingType.SDK_POJO)
            .memberName("zonalConfig").getter(getter(CreateDeploymentConfigRequest::zonalConfig))
            .setter(setter(Builder::zonalConfig)).constructor(ZonalConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_NAME_FIELD,
            MINIMUM_HEALTHY_HOSTS_FIELD, TRAFFIC_ROUTING_CONFIG_FIELD, COMPUTE_PLATFORM_FIELD, ZONAL_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deploymentConfigName", DEPLOYMENT_CONFIG_NAME_FIELD);
                    put("minimumHealthyHosts", MINIMUM_HEALTHY_HOSTS_FIELD);
                    put("trafficRoutingConfig", TRAFFIC_ROUTING_CONFIG_FIELD);
                    put("computePlatform", COMPUTE_PLATFORM_FIELD);
                    put("zonalConfig", ZONAL_CONFIG_FIELD);
                }
            });

    private final String deploymentConfigName;

    private final MinimumHealthyHosts minimumHealthyHosts;

    private final TrafficRoutingConfig trafficRoutingConfig;

    private final String computePlatform;

    private final ZonalConfig zonalConfig;

    private CreateDeploymentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
        this.computePlatform = builder.computePlatform;
        this.zonalConfig = builder.zonalConfig;
    }

    /**
     * <p>
     * The name of the deployment configuration to create.
     * </p>
     * 
     * @return The name of the deployment configuration to create.
     */
    public final String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The minimum number of healthy instances that should be available at any time during the deployment. There are two
     * parameters expected in the input: type and value.
     * </p>
     * <p>
     * The type parameter takes either of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
     * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
     * CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * </p>
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * </p>
     * 
     * @return The minimum number of healthy instances that should be available at any time during the deployment. There
     *         are two parameters expected in the input: type and value.</p>
     *         <p>
     *         The type parameter takes either of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of
     *         the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
     *         deployment, CodeDeploy converts the percentage to the equivalent number of instances and rounds up
     *         fractional instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The value parameter takes an integer.
     *         </p>
     *         <p>
     *         For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     */
    public final MinimumHealthyHosts minimumHealthyHosts() {
        return minimumHealthyHosts;
    }

    /**
     * <p>
     * The configuration that specifies how the deployment traffic is routed.
     * </p>
     * 
     * @return The configuration that specifies how the deployment traffic is routed.
     */
    public final TrafficRoutingConfig trafficRoutingConfig() {
        return trafficRoutingConfig;
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public final String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * <p>
     * Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
     * >Availability Zone</a> at a time, within an Amazon Web Services Region.
     * </p>
     * <p>
     * For more information about the zonal configuration feature, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a
     *         href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
     *         >Availability Zone</a> at a time, within an Amazon Web Services Region.</p>
     *         <p>
     *         For more information about the zonal configuration feature, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     *         >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     */
    public final ZonalConfig zonalConfig() {
        return zonalConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(trafficRoutingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zonalConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigRequest)) {
            return false;
        }
        CreateDeploymentConfigRequest other = (CreateDeploymentConfigRequest) obj;
        return Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(minimumHealthyHosts(), other.minimumHealthyHosts())
                && Objects.equals(trafficRoutingConfig(), other.trafficRoutingConfig())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && Objects.equals(zonalConfig(), other.zonalConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentConfigRequest").add("DeploymentConfigName", deploymentConfigName())
                .add("MinimumHealthyHosts", minimumHealthyHosts()).add("TrafficRoutingConfig", trafficRoutingConfig())
                .add("ComputePlatform", computePlatformAsString()).add("ZonalConfig", zonalConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "minimumHealthyHosts":
            return Optional.ofNullable(clazz.cast(minimumHealthyHosts()));
        case "trafficRoutingConfig":
            return Optional.ofNullable(clazz.cast(trafficRoutingConfig()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "zonalConfig":
            return Optional.ofNullable(clazz.cast(zonalConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentConfigRequest, T> g) {
        return obj -> g.apply((CreateDeploymentConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentConfigRequest> {
        /**
         * <p>
         * The name of the deployment configuration to create.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of the deployment configuration to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The minimum number of healthy instances that should be available at any time during the deployment. There are
         * two parameters expected in the input: type and value.
         * </p>
         * <p>
         * The type parameter takes either of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
         * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
         * CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * </p>
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * </p>
         * 
         * @param minimumHealthyHosts
         *        The minimum number of healthy instances that should be available at any time during the deployment.
         *        There are two parameters expected in the input: type and value.</p>
         *        <p>
         *        The type parameter takes either of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute
         *        value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage
         *        of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the
         *        deployment, CodeDeploy converts the percentage to the equivalent number of instances and rounds up
         *        fractional instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The value parameter takes an integer.
         *        </p>
         *        <p>
         *        For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of
         *        95.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts);

        /**
         * <p>
         * The minimum number of healthy instances that should be available at any time during the deployment. There are
         * two parameters expected in the input: type and value.
         * </p>
         * <p>
         * The type parameter takes either of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the
         * total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
         * CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * </p>
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * </p>
         * This is a convenience method that creates an instance of the {@link MinimumHealthyHosts.Builder} avoiding the
         * need to create one manually via {@link MinimumHealthyHosts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimumHealthyHosts.Builder#build()} is called immediately and
         * its result is passed to {@link #minimumHealthyHosts(MinimumHealthyHosts)}.
         * 
         * @param minimumHealthyHosts
         *        a consumer that will call methods on {@link MinimumHealthyHosts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumHealthyHosts(MinimumHealthyHosts)
         */
        default Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return minimumHealthyHosts(MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts).build());
        }

        /**
         * <p>
         * The configuration that specifies how the deployment traffic is routed.
         * </p>
         * 
         * @param trafficRoutingConfig
         *        The configuration that specifies how the deployment traffic is routed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig);

        /**
         * <p>
         * The configuration that specifies how the deployment traffic is routed.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficRoutingConfig.Builder} avoiding
         * the need to create one manually via {@link TrafficRoutingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficRoutingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficRoutingConfig(TrafficRoutingConfig)}.
         * 
         * @param trafficRoutingConfig
         *        a consumer that will call methods on {@link TrafficRoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficRoutingConfig(TrafficRoutingConfig)
         */
        default Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return trafficRoutingConfig(TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig).build());
        }

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a
         * href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
         * >Availability Zone</a> at a time, within an Amazon Web Services Region.
         * </p>
         * <p>
         * For more information about the zonal configuration feature, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param zonalConfig
         *        Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
         *        >Availability Zone</a> at a time, within an Amazon Web Services Region.</p>
         *        <p>
         *        For more information about the zonal configuration feature, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         *        >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalConfig(ZonalConfig zonalConfig);

        /**
         * <p>
         * Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a
         * href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
         * >Availability Zone</a> at a time, within an Amazon Web Services Region.
         * </p>
         * <p>
         * For more information about the zonal configuration feature, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZonalConfig.Builder} avoiding the need to
         * create one manually via {@link ZonalConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZonalConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #zonalConfig(ZonalConfig)}.
         * 
         * @param zonalConfig
         *        a consumer that will call methods on {@link ZonalConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zonalConfig(ZonalConfig)
         */
        default Builder zonalConfig(Consumer<ZonalConfig.Builder> zonalConfig) {
            return zonalConfig(ZonalConfig.builder().applyMutation(zonalConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentConfigName;

        private MinimumHealthyHosts minimumHealthyHosts;

        private TrafficRoutingConfig trafficRoutingConfig;

        private String computePlatform;

        private ZonalConfig zonalConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigRequest model) {
            super(model);
            deploymentConfigName(model.deploymentConfigName);
            minimumHealthyHosts(model.minimumHealthyHosts);
            trafficRoutingConfig(model.trafficRoutingConfig);
            computePlatform(model.computePlatform);
            zonalConfig(model.zonalConfig);
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return minimumHealthyHosts != null ? minimumHealthyHosts.toBuilder() : null;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return trafficRoutingConfig != null ? trafficRoutingConfig.toBuilder() : null;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public final String getComputePlatform() {
            return computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final ZonalConfig.Builder getZonalConfig() {
            return zonalConfig != null ? zonalConfig.toBuilder() : null;
        }

        public final void setZonalConfig(ZonalConfig.BuilderImpl zonalConfig) {
            this.zonalConfig = zonalConfig != null ? zonalConfig.build() : null;
        }

        @Override
        public final Builder zonalConfig(ZonalConfig zonalConfig) {
            this.zonalConfig = zonalConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentConfigRequest build() {
            return new CreateDeploymentConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
