/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.ApplicationInfo;
import software.amazon.awssdk.services.codedeploy.model.ApplicationsInfoListCopier;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetApplicationsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetApplicationsResponse> {
    private static final SdkField<List<ApplicationInfo>> APPLICATIONS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationsInfo").getter(BatchGetApplicationsResponse.getter(BatchGetApplicationsResponse::applicationsInfo)).setter(BatchGetApplicationsResponse.setter(Builder::applicationsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationsInfo", APPLICATIONS_INFO_FIELD);
        }
    });
    private final List<ApplicationInfo> applicationsInfo;

    private BatchGetApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationsInfo = builder.applicationsInfo;
    }

    public final boolean hasApplicationsInfo() {
        return this.applicationsInfo != null && !(this.applicationsInfo instanceof SdkAutoConstructList);
    }

    public final List<ApplicationInfo> applicationsInfo() {
        return this.applicationsInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationsInfo() ? this.applicationsInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationsResponse)) {
            return false;
        }
        BatchGetApplicationsResponse other = (BatchGetApplicationsResponse)((Object)obj);
        return this.hasApplicationsInfo() == other.hasApplicationsInfo() && Objects.equals(this.applicationsInfo(), other.applicationsInfo());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetApplicationsResponse").add("ApplicationsInfo", this.hasApplicationsInfo() ? this.applicationsInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationsInfo": {
                return Optional.ofNullable(clazz.cast(this.applicationsInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetApplicationsResponse, T> g) {
        return obj -> g.apply((BatchGetApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<ApplicationInfo> applicationsInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationsResponse model) {
            super(model);
            this.applicationsInfo(model.applicationsInfo);
        }

        public final List<ApplicationInfo.Builder> getApplicationsInfo() {
            List<ApplicationInfo.Builder> result = ApplicationsInfoListCopier.copyToBuilder(this.applicationsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationsInfo(Collection<ApplicationInfo.BuilderImpl> applicationsInfo) {
            this.applicationsInfo = ApplicationsInfoListCopier.copyFromBuilder(applicationsInfo);
        }

        @Override
        public final Builder applicationsInfo(Collection<ApplicationInfo> applicationsInfo) {
            this.applicationsInfo = ApplicationsInfoListCopier.copy(applicationsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationsInfo(ApplicationInfo ... applicationsInfo) {
            this.applicationsInfo(Arrays.asList(applicationsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationsInfo(Consumer<ApplicationInfo.Builder> ... applicationsInfo) {
            this.applicationsInfo(Stream.of(applicationsInfo).map(c -> (ApplicationInfo)((ApplicationInfo.Builder)ApplicationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetApplicationsResponse build() {
            return new BatchGetApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetApplicationsResponse> {
        public Builder applicationsInfo(Collection<ApplicationInfo> var1);

        public Builder applicationsInfo(ApplicationInfo ... var1);

        public Builder applicationsInfo(Consumer<ApplicationInfo.Builder> ... var1);
    }
}

