/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputePlatform {
    SERVER("Server"),
    LAMBDA("Lambda"),
    ECS("ECS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputePlatform> VALUE_MAP;
    private final String value;

    private ComputePlatform(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputePlatform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputePlatform> knownValues() {
        EnumSet<ComputePlatform> knownValues = EnumSet.allOf(ComputePlatform.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputePlatform.class, ComputePlatform::toString);
    }
}

