/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DeleteGitHubAccount</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGitHubAccountTokenRequest extends CodeDeployRequest implements
        ToCopyableBuilder<DeleteGitHubAccountTokenRequest.Builder, DeleteGitHubAccountTokenRequest> {
    private static final SdkField<String> TOKEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenName").getter(getter(DeleteGitHubAccountTokenRequest::tokenName))
            .setter(setter(Builder::tokenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tokenName", TOKEN_NAME_FIELD);
                }
            });

    private final String tokenName;

    private DeleteGitHubAccountTokenRequest(BuilderImpl builder) {
        super(builder);
        this.tokenName = builder.tokenName;
    }

    /**
     * <p>
     * The name of the GitHub account connection to delete.
     * </p>
     * 
     * @return The name of the GitHub account connection to delete.
     */
    public final String tokenName() {
        return tokenName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tokenName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGitHubAccountTokenRequest)) {
            return false;
        }
        DeleteGitHubAccountTokenRequest other = (DeleteGitHubAccountTokenRequest) obj;
        return Objects.equals(tokenName(), other.tokenName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGitHubAccountTokenRequest").add("TokenName", tokenName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tokenName":
            return Optional.ofNullable(clazz.cast(tokenName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteGitHubAccountTokenRequest, T> g) {
        return obj -> g.apply((DeleteGitHubAccountTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteGitHubAccountTokenRequest> {
        /**
         * <p>
         * The name of the GitHub account connection to delete.
         * </p>
         * 
         * @param tokenName
         *        The name of the GitHub account connection to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenName(String tokenName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String tokenName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGitHubAccountTokenRequest model) {
            super(model);
            tokenName(model.tokenName);
        }

        public final String getTokenName() {
            return tokenName;
        }

        public final void setTokenName(String tokenName) {
            this.tokenName = tokenName;
        }

        @Override
        public final Builder tokenName(String tokenName) {
            this.tokenName = tokenName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGitHubAccountTokenRequest build() {
            return new DeleteGitHubAccountTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
