/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListApplicationRevisions</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationRevisionsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<ListApplicationRevisionsRequest.Builder, ListApplicationRevisionsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(ListApplicationRevisionsRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListApplicationRevisionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListApplicationRevisionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(ListApplicationRevisionsRequest::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3KeyPrefix").getter(getter(ListApplicationRevisionsRequest::s3KeyPrefix))
            .setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3KeyPrefix").build()).build();

    private static final SdkField<String> DEPLOYED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deployed").getter(getter(ListApplicationRevisionsRequest::deployedAsString))
            .setter(setter(Builder::deployed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployed").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListApplicationRevisionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD, S3_BUCKET_FIELD, S3_KEY_PREFIX_FIELD, DEPLOYED_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("applicationName", APPLICATION_NAME_FIELD);
                    put("sortBy", SORT_BY_FIELD);
                    put("sortOrder", SORT_ORDER_FIELD);
                    put("s3Bucket", S3_BUCKET_FIELD);
                    put("s3KeyPrefix", S3_KEY_PREFIX_FIELD);
                    put("deployed", DEPLOYED_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String applicationName;

    private final String sortBy;

    private final String sortOrder;

    private final String s3Bucket;

    private final String s3KeyPrefix;

    private final String deployed;

    private final String nextToken;

    private ListApplicationRevisionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.deployed = builder.deployed;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of an CodeDeploy application associated with the user or Amazon Web Services account.
     * </p>
     * 
     * @return The name of an CodeDeploy application associated with the user or Amazon Web Services account.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The column name to use to sort the list results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If not specified or set to null, the results are returned in an arbitrary order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ApplicationRevisionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The column name to use to sort the list results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If not specified or set to null, the results are returned in an arbitrary order.
     * @see ApplicationRevisionSortBy
     */
    public final ApplicationRevisionSortBy sortBy() {
        return ApplicationRevisionSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The column name to use to sort the list results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If not specified or set to null, the results are returned in an arbitrary order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ApplicationRevisionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The column name to use to sort the list results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If not specified or set to null, the results are returned in an arbitrary order.
     * @see ApplicationRevisionSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order in which to sort the list results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ascending</code>: ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>descending</code>: descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If not specified, the results are sorted in ascending order.
     * </p>
     * <p>
     * If set to null, the results are sorted in an arbitrary order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to sort the list results: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ascending</code>: ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>descending</code>: descending order.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If not specified, the results are sorted in ascending order.
     *         </p>
     *         <p>
     *         If set to null, the results are sorted in an arbitrary order.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order in which to sort the list results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ascending</code>: ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>descending</code>: descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If not specified, the results are sorted in ascending order.
     * </p>
     * <p>
     * If set to null, the results are sorted in an arbitrary order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to sort the list results: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ascending</code>: ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>descending</code>: descending order.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If not specified, the results are sorted in ascending order.
     *         </p>
     *         <p>
     *         If set to null, the results are sorted in an arbitrary order.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * An Amazon S3 bucket name to limit the search for revisions.
     * </p>
     * <p>
     * If set to null, all of the user's buckets are searched.
     * </p>
     * 
     * @return An Amazon S3 bucket name to limit the search for revisions. </p>
     *         <p>
     *         If set to null, all of the user's buckets are searched.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     * </p>
     * 
     * @return A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * Whether to list revisions based on whether the revision is the target revision of a deployment group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>include</code>: List revisions that are target revisions of a deployment group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ignore</code>: List all revisions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deployed} will
     * return {@link ListStateFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deployedAsString}.
     * </p>
     * 
     * @return Whether to list revisions based on whether the revision is the target revision of a deployment group:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>include</code>: List revisions that are target revisions of a deployment group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ignore</code>: List all revisions.
     *         </p>
     *         </li>
     * @see ListStateFilterAction
     */
    public final ListStateFilterAction deployed() {
        return ListStateFilterAction.fromValue(deployed);
    }

    /**
     * <p>
     * Whether to list revisions based on whether the revision is the target revision of a deployment group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>include</code>: List revisions that are target revisions of a deployment group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ignore</code>: List all revisions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deployed} will
     * return {@link ListStateFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deployedAsString}.
     * </p>
     * 
     * @return Whether to list revisions based on whether the revision is the target revision of a deployment group:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>include</code>: List revisions that are target revisions of a deployment group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ignore</code>: List all revisions.
     *         </p>
     *         </li>
     * @see ListStateFilterAction
     */
    public final String deployedAsString() {
        return deployed;
    }

    /**
     * <p>
     * An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the
     * next set of applications in the list.
     * </p>
     * 
     * @return An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to
     *         return the next set of applications in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(deployedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsRequest)) {
            return false;
        }
        ListApplicationRevisionsRequest other = (ListApplicationRevisionsRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix())
                && Objects.equals(deployedAsString(), other.deployedAsString()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationRevisionsRequest").add("ApplicationName", applicationName())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).add("S3Bucket", s3Bucket())
                .add("S3KeyPrefix", s3KeyPrefix()).add("Deployed", deployedAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "deployed":
            return Optional.ofNullable(clazz.cast(deployedAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationRevisionsRequest, T> g) {
        return obj -> g.apply((ListApplicationRevisionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationRevisionsRequest> {
        /**
         * <p>
         * The name of an CodeDeploy application associated with the user or Amazon Web Services account.
         * </p>
         * 
         * @param applicationName
         *        The name of an CodeDeploy application associated with the user or Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The column name to use to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified or set to null, the results are returned in an arbitrary order.
         * </p>
         * 
         * @param sortBy
         *        The column name to use to sort the list results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified or set to null, the results are returned in an arbitrary order.
         * @see ApplicationRevisionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationRevisionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The column name to use to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified or set to null, the results are returned in an arbitrary order.
         * </p>
         * 
         * @param sortBy
         *        The column name to use to sort the list results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified or set to null, the results are returned in an arbitrary order.
         * @see ApplicationRevisionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationRevisionSortBy
         */
        Builder sortBy(ApplicationRevisionSortBy sortBy);

        /**
         * <p>
         * The order in which to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ascending</code>: ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>descending</code>: descending order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified, the results are sorted in ascending order.
         * </p>
         * <p>
         * If set to null, the results are sorted in an arbitrary order.
         * </p>
         * 
         * @param sortOrder
         *        The order in which to sort the list results: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ascending</code>: ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>descending</code>: descending order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified, the results are sorted in ascending order.
         *        </p>
         *        <p>
         *        If set to null, the results are sorted in an arbitrary order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which to sort the list results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ascending</code>: ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>descending</code>: descending order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If not specified, the results are sorted in ascending order.
         * </p>
         * <p>
         * If set to null, the results are sorted in an arbitrary order.
         * </p>
         * 
         * @param sortOrder
         *        The order in which to sort the list results: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ascending</code>: ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>descending</code>: descending order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If not specified, the results are sorted in ascending order.
         *        </p>
         *        <p>
         *        If set to null, the results are sorted in an arbitrary order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * An Amazon S3 bucket name to limit the search for revisions.
         * </p>
         * <p>
         * If set to null, all of the user's buckets are searched.
         * </p>
         * 
         * @param s3Bucket
         *        An Amazon S3 bucket name to limit the search for revisions. </p>
         *        <p>
         *        If set to null, all of the user's buckets are searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         * </p>
         * 
         * @param s3KeyPrefix
         *        A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * Whether to list revisions based on whether the revision is the target revision of a deployment group:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>include</code>: List revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ignore</code>: List all revisions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deployed
         *        Whether to list revisions based on whether the revision is the target revision of a deployment group:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>include</code>: List revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ignore</code>: List all revisions.
         *        </p>
         *        </li>
         * @see ListStateFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListStateFilterAction
         */
        Builder deployed(String deployed);

        /**
         * <p>
         * Whether to list revisions based on whether the revision is the target revision of a deployment group:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>include</code>: List revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ignore</code>: List all revisions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deployed
         *        Whether to list revisions based on whether the revision is the target revision of a deployment group:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>include</code>: List revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ignore</code>: List all revisions.
         *        </p>
         *        </li>
         * @see ListStateFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListStateFilterAction
         */
        Builder deployed(ListStateFilterAction deployed);

        /**
         * <p>
         * An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return
         * the next set of applications in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to
         *        return the next set of applications in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String sortBy;

        private String sortOrder;

        private String s3Bucket;

        private String s3KeyPrefix;

        private String deployed;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsRequest model) {
            super(model);
            applicationName(model.applicationName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            s3Bucket(model.s3Bucket);
            s3KeyPrefix(model.s3KeyPrefix);
            deployed(model.deployed);
            nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ApplicationRevisionSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final String getDeployed() {
            return deployed;
        }

        public final void setDeployed(String deployed) {
            this.deployed = deployed;
        }

        @Override
        public final Builder deployed(String deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public final Builder deployed(ListStateFilterAction deployed) {
            this.deployed(deployed == null ? null : deployed.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationRevisionsRequest build() {
            return new ListApplicationRevisionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
