/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a href=
 * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
 * >Availability Zone</a> at a time, within an Amazon Web Services Region. By deploying to one Availability Zone at a
 * time, you can expose your deployment to a progressively larger audience as confidence in the deployment's performance
 * and viability grows. If you don't configure the <code>ZonalConfig</code> object, CodeDeploy deploys your application
 * to a random selection of hosts across a Region.
 * </p>
 * <p>
 * For more information about the zonal configuration feature, see <a
 * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
 * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZonalConfig implements SdkPojo, Serializable, ToCopyableBuilder<ZonalConfig.Builder, ZonalConfig> {
    private static final SdkField<Long> FIRST_ZONE_MONITOR_DURATION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("firstZoneMonitorDurationInSeconds")
            .getter(getter(ZonalConfig::firstZoneMonitorDurationInSeconds))
            .setter(setter(Builder::firstZoneMonitorDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstZoneMonitorDurationInSeconds")
                    .build()).build();

    private static final SdkField<Long> MONITOR_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("monitorDurationInSeconds").getter(getter(ZonalConfig::monitorDurationInSeconds))
            .setter(setter(Builder::monitorDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorDurationInSeconds").build())
            .build();

    private static final SdkField<MinimumHealthyHostsPerZone> MINIMUM_HEALTHY_HOSTS_PER_ZONE_FIELD = SdkField
            .<MinimumHealthyHostsPerZone> builder(MarshallingType.SDK_POJO)
            .memberName("minimumHealthyHostsPerZone")
            .getter(getter(ZonalConfig::minimumHealthyHostsPerZone))
            .setter(setter(Builder::minimumHealthyHostsPerZone))
            .constructor(MinimumHealthyHostsPerZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHostsPerZone").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIRST_ZONE_MONITOR_DURATION_IN_SECONDS_FIELD, MONITOR_DURATION_IN_SECONDS_FIELD,
                    MINIMUM_HEALTHY_HOSTS_PER_ZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("firstZoneMonitorDurationInSeconds", FIRST_ZONE_MONITOR_DURATION_IN_SECONDS_FIELD);
                    put("monitorDurationInSeconds", MONITOR_DURATION_IN_SECONDS_FIELD);
                    put("minimumHealthyHostsPerZone", MINIMUM_HEALTHY_HOSTS_PER_ZONE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long firstZoneMonitorDurationInSeconds;

    private final Long monitorDurationInSeconds;

    private final MinimumHealthyHostsPerZone minimumHealthyHostsPerZone;

    private ZonalConfig(BuilderImpl builder) {
        this.firstZoneMonitorDurationInSeconds = builder.firstZoneMonitorDurationInSeconds;
        this.monitorDurationInSeconds = builder.monitorDurationInSeconds;
        this.minimumHealthyHostsPerZone = builder.minimumHealthyHostsPerZone;
    }

    /**
     * <p>
     * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the <i>first</i>
     * Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the second
     * Availability Zone. You might set this option if you want to allow extra bake time for the first Availability
     * Zone. If you don't specify a value for <code>firstZoneMonitorDurationInSeconds</code>, then CodeDeploy uses the
     * <code>monitorDurationInSeconds</code> value for the first Availability Zone.
     * </p>
     * <p>
     * For more information about the zonal configuration feature, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the
     *         <i>first</i> Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to
     *         the second Availability Zone. You might set this option if you want to allow extra bake time for the
     *         first Availability Zone. If you don't specify a value for <code>firstZoneMonitorDurationInSeconds</code>,
     *         then CodeDeploy uses the <code>monitorDurationInSeconds</code> value for the first Availability Zone.</p>
     *         <p>
     *         For more information about the zonal configuration feature, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     *         >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     */
    public final Long firstZoneMonitorDurationInSeconds() {
        return firstZoneMonitorDurationInSeconds;
    }

    /**
     * <p>
     * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an Availability Zone.
     * CodeDeploy will wait this amount of time before starting a deployment to the next Availability Zone. Consider
     * adding a monitor duration to give the deployment some time to prove itself (or 'bake') in one Availability Zone
     * before it is released in the next zone. If you don't specify a <code>monitorDurationInSeconds</code>, CodeDeploy
     * starts deploying to the next Availability Zone immediately.
     * </p>
     * <p>
     * For more information about the zonal configuration feature, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an
     *         Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the next
     *         Availability Zone. Consider adding a monitor duration to give the deployment some time to prove itself
     *         (or 'bake') in one Availability Zone before it is released in the next zone. If you don't specify a
     *         <code>monitorDurationInSeconds</code>, CodeDeploy starts deploying to the next Availability Zone
     *         immediately.</p>
     *         <p>
     *         For more information about the zonal configuration feature, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     *         >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     */
    public final Long monitorDurationInSeconds() {
        return monitorDurationInSeconds;
    }

    /**
     * <p>
     * The number or percentage of instances that must remain available per Availability Zone during a deployment. This
     * option works in conjunction with the <code>MinimumHealthyHosts</code> option. For more information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az"
     * >About the minimum number of healthy hosts per Availability Zone</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * <p>
     * If you don't specify the <code>minimumHealthyHostsPerZone</code> option, then CodeDeploy uses a default value of
     * <code>0</code> percent.
     * </p>
     * <p>
     * For more information about the zonal configuration feature, see <a href=
     * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return The number or percentage of instances that must remain available per Availability Zone during a
     *         deployment. This option works in conjunction with the <code>MinimumHealthyHosts</code> option. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az"
     *         >About the minimum number of healthy hosts per Availability Zone</a> in the <i>CodeDeploy User
     *         Guide</i>.</p>
     *         <p>
     *         If you don't specify the <code>minimumHealthyHostsPerZone</code> option, then CodeDeploy uses a default
     *         value of <code>0</code> percent.
     *         </p>
     *         <p>
     *         For more information about the zonal configuration feature, see <a href=
     *         "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
     *         >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
     */
    public final MinimumHealthyHostsPerZone minimumHealthyHostsPerZone() {
        return minimumHealthyHostsPerZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstZoneMonitorDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(monitorDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minimumHealthyHostsPerZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalConfig)) {
            return false;
        }
        ZonalConfig other = (ZonalConfig) obj;
        return Objects.equals(firstZoneMonitorDurationInSeconds(), other.firstZoneMonitorDurationInSeconds())
                && Objects.equals(monitorDurationInSeconds(), other.monitorDurationInSeconds())
                && Objects.equals(minimumHealthyHostsPerZone(), other.minimumHealthyHostsPerZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZonalConfig").add("FirstZoneMonitorDurationInSeconds", firstZoneMonitorDurationInSeconds())
                .add("MonitorDurationInSeconds", monitorDurationInSeconds())
                .add("MinimumHealthyHostsPerZone", minimumHealthyHostsPerZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "firstZoneMonitorDurationInSeconds":
            return Optional.ofNullable(clazz.cast(firstZoneMonitorDurationInSeconds()));
        case "monitorDurationInSeconds":
            return Optional.ofNullable(clazz.cast(monitorDurationInSeconds()));
        case "minimumHealthyHostsPerZone":
            return Optional.ofNullable(clazz.cast(minimumHealthyHostsPerZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ZonalConfig, T> g) {
        return obj -> g.apply((ZonalConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZonalConfig> {
        /**
         * <p>
         * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the <i>first</i>
         * Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the second
         * Availability Zone. You might set this option if you want to allow extra bake time for the first Availability
         * Zone. If you don't specify a value for <code>firstZoneMonitorDurationInSeconds</code>, then CodeDeploy uses
         * the <code>monitorDurationInSeconds</code> value for the first Availability Zone.
         * </p>
         * <p>
         * For more information about the zonal configuration feature, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param firstZoneMonitorDurationInSeconds
         *        The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the
         *        <i>first</i> Availability Zone. CodeDeploy will wait this amount of time before starting a deployment
         *        to the second Availability Zone. You might set this option if you want to allow extra bake time for
         *        the first Availability Zone. If you don't specify a value for
         *        <code>firstZoneMonitorDurationInSeconds</code>, then CodeDeploy uses the
         *        <code>monitorDurationInSeconds</code> value for the first Availability Zone.</p>
         *        <p>
         *        For more information about the zonal configuration feature, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         *        >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstZoneMonitorDurationInSeconds(Long firstZoneMonitorDurationInSeconds);

        /**
         * <p>
         * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an Availability
         * Zone. CodeDeploy will wait this amount of time before starting a deployment to the next Availability Zone.
         * Consider adding a monitor duration to give the deployment some time to prove itself (or 'bake') in one
         * Availability Zone before it is released in the next zone. If you don't specify a
         * <code>monitorDurationInSeconds</code>, CodeDeploy starts deploying to the next Availability Zone immediately.
         * </p>
         * <p>
         * For more information about the zonal configuration feature, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param monitorDurationInSeconds
         *        The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an
         *        Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the next
         *        Availability Zone. Consider adding a monitor duration to give the deployment some time to prove itself
         *        (or 'bake') in one Availability Zone before it is released in the next zone. If you don't specify a
         *        <code>monitorDurationInSeconds</code>, CodeDeploy starts deploying to the next Availability Zone
         *        immediately.</p>
         *        <p>
         *        For more information about the zonal configuration feature, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         *        >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorDurationInSeconds(Long monitorDurationInSeconds);

        /**
         * <p>
         * The number or percentage of instances that must remain available per Availability Zone during a deployment.
         * This option works in conjunction with the <code>MinimumHealthyHosts</code> option. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az"
         * >About the minimum number of healthy hosts per Availability Zone</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * <p>
         * If you don't specify the <code>minimumHealthyHostsPerZone</code> option, then CodeDeploy uses a default value
         * of <code>0</code> percent.
         * </p>
         * <p>
         * For more information about the zonal configuration feature, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param minimumHealthyHostsPerZone
         *        The number or percentage of instances that must remain available per Availability Zone during a
         *        deployment. This option works in conjunction with the <code>MinimumHealthyHosts</code> option. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az"
         *        >About the minimum number of healthy hosts per Availability Zone</a> in the <i>CodeDeploy User
         *        Guide</i>.</p>
         *        <p>
         *        If you don't specify the <code>minimumHealthyHostsPerZone</code> option, then CodeDeploy uses a
         *        default value of <code>0</code> percent.
         *        </p>
         *        <p>
         *        For more information about the zonal configuration feature, see <a href=
         *        "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         *        >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone minimumHealthyHostsPerZone);

        /**
         * <p>
         * The number or percentage of instances that must remain available per Availability Zone during a deployment.
         * This option works in conjunction with the <code>MinimumHealthyHosts</code> option. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az"
         * >About the minimum number of healthy hosts per Availability Zone</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * <p>
         * If you don't specify the <code>minimumHealthyHostsPerZone</code> option, then CodeDeploy uses a default value
         * of <code>0</code> percent.
         * </p>
         * <p>
         * For more information about the zonal configuration feature, see <a href=
         * "https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config"
         * >zonal configuration</a> in the <i>CodeDeploy User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MinimumHealthyHostsPerZone.Builder}
         * avoiding the need to create one manually via {@link MinimumHealthyHostsPerZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimumHealthyHostsPerZone.Builder#build()} is called immediately
         * and its result is passed to {@link #minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone)}.
         * 
         * @param minimumHealthyHostsPerZone
         *        a consumer that will call methods on {@link MinimumHealthyHostsPerZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone)
         */
        default Builder minimumHealthyHostsPerZone(Consumer<MinimumHealthyHostsPerZone.Builder> minimumHealthyHostsPerZone) {
            return minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone.builder().applyMutation(minimumHealthyHostsPerZone)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long firstZoneMonitorDurationInSeconds;

        private Long monitorDurationInSeconds;

        private MinimumHealthyHostsPerZone minimumHealthyHostsPerZone;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalConfig model) {
            firstZoneMonitorDurationInSeconds(model.firstZoneMonitorDurationInSeconds);
            monitorDurationInSeconds(model.monitorDurationInSeconds);
            minimumHealthyHostsPerZone(model.minimumHealthyHostsPerZone);
        }

        public final Long getFirstZoneMonitorDurationInSeconds() {
            return firstZoneMonitorDurationInSeconds;
        }

        public final void setFirstZoneMonitorDurationInSeconds(Long firstZoneMonitorDurationInSeconds) {
            this.firstZoneMonitorDurationInSeconds = firstZoneMonitorDurationInSeconds;
        }

        @Override
        public final Builder firstZoneMonitorDurationInSeconds(Long firstZoneMonitorDurationInSeconds) {
            this.firstZoneMonitorDurationInSeconds = firstZoneMonitorDurationInSeconds;
            return this;
        }

        public final Long getMonitorDurationInSeconds() {
            return monitorDurationInSeconds;
        }

        public final void setMonitorDurationInSeconds(Long monitorDurationInSeconds) {
            this.monitorDurationInSeconds = monitorDurationInSeconds;
        }

        @Override
        public final Builder monitorDurationInSeconds(Long monitorDurationInSeconds) {
            this.monitorDurationInSeconds = monitorDurationInSeconds;
            return this;
        }

        public final MinimumHealthyHostsPerZone.Builder getMinimumHealthyHostsPerZone() {
            return minimumHealthyHostsPerZone != null ? minimumHealthyHostsPerZone.toBuilder() : null;
        }

        public final void setMinimumHealthyHostsPerZone(MinimumHealthyHostsPerZone.BuilderImpl minimumHealthyHostsPerZone) {
            this.minimumHealthyHostsPerZone = minimumHealthyHostsPerZone != null ? minimumHealthyHostsPerZone.build() : null;
        }

        @Override
        public final Builder minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone minimumHealthyHostsPerZone) {
            this.minimumHealthyHostsPerZone = minimumHealthyHostsPerZone;
            return this;
        }

        @Override
        public ZonalConfig build() {
            return new ZonalConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
