/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about groups of EC2 instance tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2TagSet implements SdkPojo, Serializable, ToCopyableBuilder<EC2TagSet.Builder, EC2TagSet> {
    private static final SdkField<List<List<EC2TagFilter>>> EC2_TAG_SET_LIST_FIELD = SdkField
            .<List<List<EC2TagFilter>>> builder(MarshallingType.LIST)
            .getter(getter(EC2TagSet::ec2TagSetList))
            .setter(setter(Builder::ec2TagSetList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSetList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<EC2TagFilter>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<EC2TagFilter> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(EC2TagFilter::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_TAG_SET_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<List<EC2TagFilter>> ec2TagSetList;

    private EC2TagSet(BuilderImpl builder) {
        this.ec2TagSetList = builder.ec2TagSetList;
    }

    /**
     * <p>
     * A list containing other lists of EC2 instance tag groups. In order for an instance to be included in the
     * deployment group, it must be identified by all the tag groups in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list containing other lists of EC2 instance tag groups. In order for an instance to be included in the
     *         deployment group, it must be identified by all the tag groups in the list.
     */
    public List<List<EC2TagFilter>> ec2TagSetList() {
        return ec2TagSetList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2TagSetList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2TagSet)) {
            return false;
        }
        EC2TagSet other = (EC2TagSet) obj;
        return Objects.equals(ec2TagSetList(), other.ec2TagSetList());
    }

    @Override
    public String toString() {
        return ToString.builder("EC2TagSet").add("Ec2TagSetList", ec2TagSetList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2TagSetList":
            return Optional.ofNullable(clazz.cast(ec2TagSetList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2TagSet, T> g) {
        return obj -> g.apply((EC2TagSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2TagSet> {
        /**
         * <p>
         * A list containing other lists of EC2 instance tag groups. In order for an instance to be included in the
         * deployment group, it must be identified by all the tag groups in the list.
         * </p>
         * 
         * @param ec2TagSetList
         *        A list containing other lists of EC2 instance tag groups. In order for an instance to be included in
         *        the deployment group, it must be identified by all the tag groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSetList(Collection<? extends Collection<EC2TagFilter>> ec2TagSetList);

        /**
         * <p>
         * A list containing other lists of EC2 instance tag groups. In order for an instance to be included in the
         * deployment group, it must be identified by all the tag groups in the list.
         * </p>
         * 
         * @param ec2TagSetList
         *        A list containing other lists of EC2 instance tag groups. In order for an instance to be included in
         *        the deployment group, it must be identified by all the tag groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagSetList(Collection<EC2TagFilter>... ec2TagSetList);
    }

    static final class BuilderImpl implements Builder {
        private List<List<EC2TagFilter>> ec2TagSetList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EC2TagSet model) {
            ec2TagSetList(model.ec2TagSetList);
        }

        public final Collection<? extends Collection<EC2TagFilter>> getEc2TagSetList() {
            return ec2TagSetList;
        }

        @Override
        public final Builder ec2TagSetList(Collection<? extends Collection<EC2TagFilter>> ec2TagSetList) {
            this.ec2TagSetList = EC2TagSetListCopier.copy(ec2TagSetList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagSetList(Collection<EC2TagFilter>... ec2TagSetList) {
            ec2TagSetList(Arrays.asList(ec2TagSetList));
            return this;
        }

        public final void setEc2TagSetList(Collection<? extends Collection<EC2TagFilter>> ec2TagSetList) {
            this.ec2TagSetList = EC2TagSetListCopier.copy(ec2TagSetList);
        }

        @Override
        public EC2TagSet build() {
            return new EC2TagSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
