/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codedeploy.internal.CodeDeployServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ArnNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetListSizeExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.EcsServiceMappingLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidComputePlatformException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentTargetIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentWaitTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEcsServiceException;
import software.amazon.awssdk.services.codedeploy.model.InvalidExternalIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIgnoreApplicationStopFailuresValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInputException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOnPremisesTagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagsToAddException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetFilterNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetGroupPairException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTrafficRoutingConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidUpdateOutdatedInstancesOnlyValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidZonalDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.OperationNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.TagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.TagSetListLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ThrottlingException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteGitHubAccountTokenRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteResourcesByExternalIdRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentTargetRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.PutLifecycleEventHookExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CodeDeployAsyncClient}.
 *
 * @see CodeDeployAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeDeployAsyncClient implements CodeDeployAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeDeployAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultCodeDeployAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return A Java Future containing the result of the AddTagsToOnPremisesInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToOnPremisesInstancesResponse> addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToOnPremisesInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToOnPremisesInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddTagsToOnPremisesInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToOnPremisesInstancesRequest, AddTagsToOnPremisesInstancesResponse>()
                            .withOperationName("AddTagsToOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddTagsToOnPremisesInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsToOnPremisesInstancesRequest));
            CompletableFuture<AddTagsToOnPremisesInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the BatchGetApplicationRevisions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetApplicationRevisionsResponse> batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetApplicationRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetApplicationRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetApplicationRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetApplicationRevisionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetApplicationRevisionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetApplicationRevisionsRequest, BatchGetApplicationRevisionsResponse>()
                            .withOperationName("BatchGetApplicationRevisions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetApplicationRevisionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetApplicationRevisionsRequest));
            CompletableFuture<BatchGetApplicationRevisionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        Represents the input of a <code>BatchGetApplications</code> operation.
     * @return A Java Future containing the result of the BatchGetApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetApplicationsResponse> batchGetApplications(
            BatchGetApplicationsRequest batchGetApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetApplicationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetApplicationsRequest, BatchGetApplicationsResponse>()
                            .withOperationName("BatchGetApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetApplicationsRequest));
            CompletableFuture<BatchGetApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return A Java Future containing the result of the BatchGetDeploymentGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentGroupsResponse> batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeploymentGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDeploymentGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetDeploymentGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentGroupsRequest, BatchGetDeploymentGroupsResponse>()
                            .withOperationName("BatchGetDeploymentGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDeploymentGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDeploymentGroupsRequest));
            CompletableFuture<BatchGetDeploymentGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about Amazon EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchGetDeploymentTargetsRequest
     * @return A Java Future containing the result of the BatchGetDeploymentTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>DeploymentTargetListSizeExceededException The maximum number of targets that can be associated with
     *         an Amazon ECS or Lambda deployment was exceeded. The target list of both types of deployments must have
     *         exactly one item. This exception does not apply to EC2/On-premises deployments.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentTargetsResponse> batchGetDeploymentTargets(
            BatchGetDeploymentTargetsRequest batchGetDeploymentTargetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeploymentTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDeploymentTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDeploymentTargetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetDeploymentTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentTargetsRequest, BatchGetDeploymentTargetsResponse>()
                            .withOperationName("BatchGetDeploymentTargets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDeploymentTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDeploymentTargetsRequest));
            CompletableFuture<BatchGetDeploymentTargetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return A Java Future containing the result of the BatchGetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentsResponse> batchGetDeployments(
            BatchGetDeploymentsRequest batchGetDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetDeploymentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentsRequest, BatchGetDeploymentsResponse>()
                            .withOperationName("BatchGetDeployments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetDeploymentsRequest));
            CompletableFuture<BatchGetDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return A Java Future containing the result of the BatchGetOnPremisesInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetOnPremisesInstancesResponse> batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetOnPremisesInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetOnPremisesInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetOnPremisesInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResponse>()
                            .withOperationName("BatchGetOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetOnPremisesInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetOnPremisesInstancesRequest));
            CompletableFuture<BatchGetOnPremisesInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     *
     * @param continueDeploymentRequest
     * @return A Java Future containing the result of the ContinueDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIsNotInReadyStateException The deployment does not have a status of Ready and can't
     *         continue yet.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>InvalidDeploymentWaitTypeException The wait type is invalid.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ContinueDeploymentResponse> continueDeployment(ContinueDeploymentRequest continueDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(continueDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, continueDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ContinueDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ContinueDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ContinueDeploymentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ContinueDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ContinueDeploymentRequest, ContinueDeploymentResponse>()
                            .withOperationName("ContinueDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ContinueDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(continueDeploymentRequest));
            CompletableFuture<ContinueDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createApplicationRequest
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name with the user or Amazon Web
     *         Services account already exists.</li>
     *         <li>ApplicationLimitExceededException More applications were attempted to be created than are allowed.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                            .withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createApplicationRequest));
            CompletableFuture<CreateApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     *
     * @param createDeploymentRequest
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>DeploymentLimitExceededException The number of allowed deployments was exceeded.</li>
     *         <li>InvalidTargetInstancesException The target instance configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li></li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidFileExistsBehaviorException An invalid fileExistsBehavior option was specified to determine
     *         how CodeDeploy handles files or directories that already exist in a deployment target location, but
     *         weren't part of the previous successful deployment. Valid values include "DISALLOW," "OVERWRITE," and
     *         "RETAIN."</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidUpdateOutdatedInstancesOnlyValueException The UpdateOutdatedInstancesOnly value is invalid.
     *         For Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidIgnoreApplicationStopFailuresValueException The IgnoreApplicationStopFailures value is
     *         invalid. For Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments,
     *         <code>true</code> or <code>false</code> is expected.</li>
     *         <li>InvalidGitHubAccountTokenException The GitHub token is not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                            .withOperationName("CreateDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentRequest));
            CompletableFuture<CreateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigAlreadyExistsException A deployment configuration with the specified name with the
     *         user or Amazon Web Services account already exists.</li>
     *         <li>InvalidMinimumHealthyHostValueException The minimum healthy instance value was specified in an
     *         invalid format.</li>
     *         <li>DeploymentConfigLimitExceededException The deployment configurations limit was exceeded.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>InvalidZonalDeploymentConfigurationException The <code>ZonalConfig</code> object is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentConfigResponse> createDeploymentConfig(
            CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDeploymentConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentConfigRequest, CreateDeploymentConfigResponse>()
                            .withOperationName("CreateDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentConfigRequest));
            CompletableFuture<CreateDeploymentConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the CreateDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name with the user or
     *         Amazon Web Services account already exists.</li>
     *         <li>InvalidEc2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>RoleRequiredException The role ID was not specified.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>DeploymentGroupLimitExceededException The deployment groups limit was exceeded.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled, but an invalid triggering event type or no event
     *         types were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL."</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>InvalidEc2TagCombinationException A call was submitted that specified both Ec2TagFilters and
     *         Ec2TagSet, but only one of these data types can be used in a single call.</li>
     *         <li>InvalidOnPremisesTagCombinationException A call was submitted that specified both
     *         OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.
     *         </li>
     *         <li>TagSetListLimitExceededException The number of tag groups included in the tag set list exceeded the
     *         maximum allowed limit of 3.</li>
     *         <li>InvalidInputException The input was specified in an invalid format.</li>
     *         <li>ThrottlingException An API function was called too frequently.</li>
     *         <li>InvalidEcsServiceException The Amazon ECS service identifier is not valid.</li>
     *         <li>InvalidTargetGroupPairException A target group pair associated with this deployment is not valid.</li>
     *         <li>EcsServiceMappingLimitExceededException The Amazon ECS service is associated with more than one
     *         deployment groups. An Amazon ECS service can be associated with only one deployment group.</li>
     *         <li>InvalidTagsToAddException The specified tags are not valid.</li>
     *         <li>InvalidTrafficRoutingConfigurationException The configuration that specifies how traffic is routed
     *         during a deployment is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(
            CreateDeploymentGroupRequest createDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentGroupRequest, CreateDeploymentGroupResponse>()
                            .withOperationName("CreateDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentGroupRequest));
            CompletableFuture<CreateDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                            .withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApplicationRequest));
            CompletableFuture<DeleteApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     *
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigInUseException The deployment configuration is still in use.</li>
     *         <li>InvalidOperationException An invalid operation was detected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeploymentConfigResponse> deleteDeploymentConfig(
            DeleteDeploymentConfigRequest deleteDeploymentConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeploymentConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeploymentConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDeploymentConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentConfigRequest, DeleteDeploymentConfigResponse>()
                            .withOperationName("DeleteDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeploymentConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeploymentConfigRequest));
            CompletableFuture<DeleteDeploymentConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the DeleteDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2
     *         Auto Scaling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeploymentGroupResponse> deleteDeploymentGroup(
            DeleteDeploymentGroupRequest deleteDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeploymentGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResponse>()
                            .withOperationName("DeleteDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeploymentGroupRequest));
            CompletableFuture<DeleteDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return A Java Future containing the result of the DeleteGitHubAccountToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GitHubAccountTokenNameRequiredException The call is missing a required GitHub account connection
     *         name.</li>
     *         <li>GitHubAccountTokenDoesNotExistException No GitHub account connection exists with the named specified
     *         in the call.</li>
     *         <li>InvalidGitHubAccountTokenNameException The format of the specified GitHub account connection name is
     *         invalid.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>OperationNotSupportedException The API used does not support the deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGitHubAccountTokenResponse> deleteGitHubAccountToken(
            DeleteGitHubAccountTokenRequest deleteGitHubAccountTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGitHubAccountTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGitHubAccountTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGitHubAccountToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGitHubAccountTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGitHubAccountTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGitHubAccountTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGitHubAccountTokenRequest, DeleteGitHubAccountTokenResponse>()
                            .withOperationName("DeleteGitHubAccountToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGitHubAccountTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGitHubAccountTokenRequest));
            CompletableFuture<DeleteGitHubAccountTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes resources linked to an external ID. This action only applies if you have configured blue/green
     * deployments through CloudFormation.
     * </p>
     * <note>
     * <p>
     * It is not necessary to call this action directly. CloudFormation calls it on your behalf when it needs to delete
     * stack resources. This action is offered publicly in case you need to delete resources to comply with General Data
     * Protection Regulation (GDPR) requirements.
     * </p>
     * </note>
     *
     * @param deleteResourcesByExternalIdRequest
     * @return A Java Future containing the result of the DeleteResourcesByExternalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcesByExternalIdResponse> deleteResourcesByExternalId(
            DeleteResourcesByExternalIdRequest deleteResourcesByExternalIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcesByExternalIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcesByExternalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcesByExternalId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcesByExternalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcesByExternalIdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourcesByExternalIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcesByExternalIdRequest, DeleteResourcesByExternalIdResponse>()
                            .withOperationName("DeleteResourcesByExternalId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcesByExternalIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcesByExternalIdRequest));
            CompletableFuture<DeleteResourcesByExternalIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the DeregisterOnPremisesInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterOnPremisesInstanceResponse> deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterOnPremisesInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterOnPremisesInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterOnPremisesInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterOnPremisesInstanceRequest, DeregisterOnPremisesInstanceResponse>()
                            .withOperationName("DeregisterOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterOnPremisesInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterOnPremisesInstanceRequest));
            CompletableFuture<DeregisterOnPremisesInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     *
     * @param getApplicationRequest
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                            .withOperationName("GetApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationRequest));
            CompletableFuture<GetApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return A Java Future containing the result of the GetApplicationRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationRevisionResponse> getApplicationRevision(
            GetApplicationRevisionRequest getApplicationRevisionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRevisionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRevisionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationRevision");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationRevisionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetApplicationRevisionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationRevisionRequest, GetApplicationRevisionResponse>()
                            .withOperationName("GetApplicationRevision").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationRevisionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationRevisionRequest));
            CompletableFuture<GetApplicationRevisionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note>
     *
     * @param getDeploymentRequest
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeploymentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                            .withOperationName("GetDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentRequest));
            CompletableFuture<GetDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return A Java Future containing the result of the GetDeploymentConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>InvalidComputePlatformException The computePlatform is invalid. The computePlatform should be
     *         <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentConfigResponse> getDeploymentConfig(
            GetDeploymentConfigRequest getDeploymentConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDeploymentConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentConfigRequest, GetDeploymentConfigResponse>()
                            .withOperationName("GetDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentConfigRequest));
            CompletableFuture<GetDeploymentConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return A Java Future containing the result of the GetDeploymentGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group with the user or Amazon Web Services
     *         account does not exist.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the user or
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentGroupResponse> getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDeploymentGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentGroupRequest, GetDeploymentGroupResponse>()
                            .withOperationName("GetDeploymentGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentGroupRequest));
            CompletableFuture<GetDeploymentGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     *
     * @param getDeploymentTargetRequest
     * @return A Java Future containing the result of the GetDeploymentTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment with the user or Amazon Web Services account does not
     *         exist.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>DeploymentTargetIdRequiredException A deployment target ID was not provided.</li>
     *         <li>InvalidDeploymentTargetIdException The target ID provided was not valid.</li>
     *         <li>DeploymentTargetDoesNotExistException The provided target ID does not belong to the attempted
     *         deployment.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentTargetResponse> getDeploymentTarget(
            GetDeploymentTargetRequest getDeploymentTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDeploymentTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentTargetRequest, GetDeploymentTargetResponse>()
                            .withOperationName("GetDeploymentTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentTargetRequest));
            CompletableFuture<GetDeploymentTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return A Java Future containing the result of the GetOnPremisesInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>InvalidInstanceNameException The on-premises instance name was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOnPremisesInstanceResponse> getOnPremisesInstance(
            GetOnPremisesInstanceRequest getOnPremisesInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOnPremisesInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOnPremisesInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
                case "ResourceArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
                case "OperationNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
                case "DeploymentGroupLimitExceededException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder)
                                    .build());
                case "InvalidDeploymentGroupNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
                case "DeploymentTargetDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder)
                                    .build());
                case "AlarmsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "InvalidGitHubAccountTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
                case "TriggerTargetsLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
                case "ECSServiceMappingLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder)
                            .build());
                case "InvalidLoadBalancerInfoException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
                case "MultipleIamArnsProvidedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
                case "InvalidEC2TagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
                case "InvalidDeploymentConfigNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
                case "LifecycleHookLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
                case "IamUserArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
                case "RevisionRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
                case "DeploymentIsNotInReadyStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
                case "InvalidGitHubAccountTokenNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder)
                            .build());
                case "InstanceNotRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
                case "InvalidBlueGreenDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder).build());
                case "ApplicationAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
                case "InvalidDeployedStateFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
                case "DeploymentTargetIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
                case "InvalidAlarmConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
                case "DescriptionTooLongException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
                case "InvalidInstanceStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
                case "InstanceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
                case "DeploymentIdRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
                case "InvalidIgnoreApplicationStopFailuresValueException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("InvalidIgnoreApplicationStopFailuresValueException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
                case "DeploymentConfigNameRequiredException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder)
                                    .build());
                case "InvalidTargetGroupPairException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
                case "InvalidTargetFilterNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
                case "ApplicationLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
                case "InvalidRegistrationStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
                case "InvalidLifecycleEventHookExecutionStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder).build());
                case "InvalidExternalIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
                case "DeploymentGroupDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
                case "UnsupportedActionForDeploymentTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                            .build());
                case "InvalidMinimumHealthyHostValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder)
                            .build());
                case "BatchLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
                case "ApplicationDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
                case "InvalidTargetInstancesException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
                case "TagRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagRequiredException::builder).build());
                case "BucketNameFilterRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
                case "InvalidIamUserArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
                case "InvalidInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
                case "InvalidTriggerConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
                case "IamArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
                case "InvalidKeyPrefixFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
                case "GitHubAccountTokenNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder)
                            .build());
                case "InvalidBucketNameFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
                case "InvalidComputePlatformException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
                case "RoleRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RoleRequiredException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "DeploymentNotStartedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
                case "LifecycleEventAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder)
                            .build());
                case "InvalidIamSessionArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
                case "DeploymentGroupAlreadyExistsException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder)
                                    .build());
                case "InvalidOnPremisesTagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder)
                            .build());
                case "InstanceNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
                case "DeploymentConfigLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder)
                            .build());
                case "InvalidRevisionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
                case "IamUserArnRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
                case "InvalidUpdateOutdatedInstancesOnlyValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder).build());
                case "InvalidEC2TagCombinationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
                case "InvalidDeploymentIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
                case "ArnNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
                case "DeploymentTargetListSizeExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                            .build());
                case "InvalidDeploymentStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
                case "InvalidInstanceNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
                case "DeploymentConfigInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
                case "DeploymentConfigAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder)
                            .build());
                case "IamSessionArnAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder)
                            .build());
                case "InstanceNameAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder)
                            .build());
                case "InvalidTagException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagException::builder).build());
                case "InvalidApplicationNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
                case "InvalidDeploymentStyleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                case "InvalidSortByException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortByException::builder).build());
                case "InvalidDeploymentInstanceTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder)
                            .build());
                case "DeploymentDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
                case "InvalidSortOrderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
                case "DeploymentGroupNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
                case "RevisionDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                case "InvalidFileExistsBehaviorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
                case "InvalidDeploymentTargetIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "InvalidDeploymentWaitTypeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
                case "InvalidAutoScalingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
                case "InvalidTrafficRoutingConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                            .build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetOnPremisesInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResponse>()
                            .withOperationName("GetOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOnPremisesInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOnPremisesInstanceRequest));
            CompletableFuture<GetOnPremisesInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return A Java Future containing the result of the ListApplicationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the user or Amazon Web Services
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationRevisionsResponse> listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationRevisions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListApplicationRevisionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ResourceValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceValidationException::builder).build());
                case "InvalidZonalDeploymentConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                            .build());
                case "GitHubAccountTokenDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder)
                            .build());
                case "InvalidOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidTagsToAddException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
                case "TagSetListLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
                case "DeploymentConfigDoesNotExistException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder)
                                    .build());
                case "ApplicationNameRequiredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
                case "InvalidLifecycleEventHookExecutionIdException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                            .build());
                case "InvalidAutoRollbackConfigException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
                case "DeploymentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
                case "InvalidECSServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
                case "InvalidArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidArnException::builder).build());
                case "InvalidTagFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
                case "DeploymentAlreadyCompletedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                            .httpStatusCode(400).exceptionBuilderSu