/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codedeploy.internal.CodeDeployServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ArnNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetListSizeExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.EcsServiceMappingLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidComputePlatformException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentTargetIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentWaitTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEc2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEcsServiceException;
import software.amazon.awssdk.services.codedeploy.model.InvalidExternalIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidGitHubAccountTokenNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIgnoreApplicationStopFailuresValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInputException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLifecycleEventHookExecutionStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOnPremisesTagCombinationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagsToAddException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetFilterNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetGroupPairException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTrafficRoutingConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidUpdateOutdatedInstancesOnlyValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidZonalDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.OperationNotSupportedException;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest;
import software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.TagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.TagSetListLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ThrottlingException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest;
import software.amazon.awssdk.services.codedeploy.model.UntagResourceResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteGitHubAccountTokenRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteResourcesByExternalIdRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentTargetRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.PutLifecycleEventHookExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CodeDeployClient}.
 *
 * @see CodeDeployClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeDeployClient implements CodeDeployClient {
    private static final Logger log = Logger.loggerFor(DefaultCodeDeployClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeDeployClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     *
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return Result of the AddTagsToOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.AddTagsToOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddTagsToOnPremisesInstancesResponse addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, TagRequiredException, InvalidTagException, TagLimitExceededException,
            InstanceLimitExceededException, InstanceNotRegisteredException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsToOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddTagsToOnPremisesInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToOnPremisesInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<AddTagsToOnPremisesInstancesRequest, AddTagsToOnPremisesInstancesResponse>()
                            .withOperationName("AddTagsToOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addTagsToOnPremisesInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddTagsToOnPremisesInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about one or more application revisions. The maximum number of application revisions that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a <code>BatchGetApplicationRevisions</code> operation.
     * @return Result of the BatchGetApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetApplicationRevisionsResponse batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, RevisionRequiredException,
            InvalidRevisionException, BatchLimitExceededException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetApplicationRevisionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetApplicationRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetApplicationRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetApplicationRevisions");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetApplicationRevisionsRequest, BatchGetApplicationRevisionsResponse>()
                            .withOperationName("BatchGetApplicationRevisions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetApplicationRevisionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetApplicationRevisionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     * </p>
     *
     * @param batchGetApplicationsRequest
     *        Represents the input of a <code>BatchGetApplications</code> operation.
     * @return Result of the BatchGetApplications operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetApplicationsResponse batchGetApplications(BatchGetApplicationsRequest batchGetApplicationsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            BatchLimitExceededException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetApplications");

            return clientHandler.execute(new ClientExecutionParams<BatchGetApplicationsRequest, BatchGetApplicationsResponse>()
                    .withOperationName("BatchGetApplications").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     *
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a <code>BatchGetDeploymentGroups</code> operation.
     * @return Result of the BatchGetDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the user or Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeploymentGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetDeploymentGroupsResponse batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, BatchLimitExceededException, DeploymentConfigDoesNotExistException,
            AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetDeploymentGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeploymentGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentGroupsRequest, BatchGetDeploymentGroupsResponse>()
                            .withOperationName("BatchGetDeploymentGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetDeploymentGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetDeploymentGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types
     * and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of
     * targets that can be returned is 25.
     * </p>
     * <p>
     * The type of targets returned depends on the deployment's compute platform or deployment method:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EC2/On-premises</b>: Information about Amazon EC2 instance targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Lambda</b>: Information about Lambda functions targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon ECS</b>: Information about Amazon ECS service targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack
     * update.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchGetDeploymentTargetsRequest
     * @return Result of the BatchGetDeploymentTargets operation returned by the service.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the user or Amazon Web Services account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws DeploymentTargetIdRequiredException
     *         A deployment target ID was not provided.
     * @throws InvalidDeploymentTargetIdException
     *         The target ID provided was not valid.
     * @throws DeploymentTargetDoesNotExistException
     *         The provided target ID does not belong to the attempted deployment.
     * @throws DeploymentTargetListSizeExceededException
     *         The maximum number of targets that can be associated with an Amazon ECS or Lambda deployment was
     *         exceeded. The target list of both types of deployments must have exactly one item. This exception does
     *         not apply to EC2/On-premises deployments.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeploymentTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetDeploymentTargetsResponse batchGetDeploymentTargets(
            BatchGetDeploymentTargetsRequest batchGetDeploymentTargetsRequest) throws InvalidDeploymentIdException,
            DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentNotStartedException,
            DeploymentTargetIdRequiredException, InvalidDeploymentTargetIdException, DeploymentTargetDoesNotExistException,
            DeploymentTargetListSizeExceededException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetDeploymentTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetDeploymentTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeploymentTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetDeploymentTargetsRequest, BatchGetDeploymentTargetsResponse>()
                            .withOperationName("BatchGetDeploymentTargets").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetDeploymentTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetDeploymentTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     * </p>
     *
     * @param batchGetDeploymentsRequest
     *        Represents the input of a <code>BatchGetDeployments</code> operation.
     * @return Result of the BatchGetDeployments operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetDeploymentsResponse batchGetDeployments(BatchGetDeploymentsRequest batchGetDeploymentsRequest)
            throws DeploymentIdRequiredException, InvalidDeploymentIdException, BatchLimitExceededException, AwsServiceException,
            SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetDeploymentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetDeploymentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetDeployments");

            return clientHandler.execute(new ClientExecutionParams<BatchGetDeploymentsRequest, BatchGetDeploymentsResponse>()
                    .withOperationName("BatchGetDeployments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetDeploymentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetDeploymentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be
     * returned is 25.
     * </p>
     *
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.
     * @return Result of the BatchGetOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.BatchGetOnPremisesInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetOnPremisesInstancesResponse batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, BatchLimitExceededException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetOnPremisesInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetOnPremisesInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetOnPremisesInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetOnPremisesInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResponse>()
                            .withOperationName("BatchGetOnPremisesInstances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetOnPremisesInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetOnPremisesInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     *
     * @param continueDeploymentRequest
     * @return Result of the ContinueDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the user or Amazon Web Services account does not exist.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIsNotInReadyStateException
     *         The deployment does not have a status of Ready and can't continue yet.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws InvalidDeploymentWaitTypeException
     *         The wait type is invalid.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ContinueDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ContinueDeploymentResponse continueDeployment(ContinueDeploymentRequest continueDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentIsNotInReadyStateException, UnsupportedActionForDeploymentTypeException,
            InvalidDeploymentWaitTypeException, InvalidDeploymentStatusException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ContinueDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ContinueDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(continueDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, continueDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ContinueDeployment");

            return clientHandler.execute(new ClientExecutionParams<ContinueDeploymentRequest, ContinueDeploymentResponse>()
                    .withOperationName("ContinueDeployment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(continueDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ContinueDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createApplicationRequest
     *        Represents the input of a <code>CreateApplication</code> operation.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name with the user or Amazon Web Services account already exists.
     * @throws ApplicationLimitExceededException
     *         More applications were attempted to be created than are allowed.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationLimitExceededException, InvalidComputePlatformException, InvalidTagsToAddException, AwsServiceException,
            SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");

            return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                    .withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     *
     * @param createDeploymentRequest
     *        Represents the input of a <code>CreateDeployment</code> operation.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the user or Amazon Web Services account does not exist.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the user or Amazon Web Services account.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the user or Amazon Web Services account.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws DeploymentLimitExceededException
     *         The number of allowed deployments was exceeded.
     * @throws InvalidTargetInstancesException
     *         The target instance configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li>
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidFileExistsBehaviorException
     *         An invalid fileExistsBehavior option was specified to determine how CodeDeploy handles files or
     *         directories that already exist in a deployment target location, but weren't part of the previous
     *         successful deployment. Valid values include "DISALLOW," "OVERWRITE," and "RETAIN."
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidUpdateOutdatedInstancesOnlyValueException
     *         The UpdateOutdatedInstancesOnly value is invalid. For Lambda deployments, <code>false</code> is expected.
     *         For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.
     * @throws InvalidIgnoreApplicationStopFailuresValueException
     *         The IgnoreApplicationStopFailures value is invalid. For Lambda deployments, <code>false</code> is
     *         expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.
     * @throws InvalidGitHubAccountTokenException
     *         The GitHub token is not valid.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            RevisionRequiredException, RevisionDoesNotExistException, InvalidRevisionException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, DescriptionTooLongException,
            DeploymentLimitExceededException, InvalidTargetInstancesException, InvalidAlarmConfigException,
            AlarmsLimitExceededException, InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException,
            InvalidFileExistsBehaviorException, InvalidRoleException, InvalidAutoScalingGroupException, ThrottlingException,
            InvalidUpdateOutdatedInstancesOnlyValueException, InvalidIgnoreApplicationStopFailuresValueException,
            InvalidGitHubAccountTokenException, InvalidTrafficRoutingConfigurationException, AwsServiceException,
            SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");

            return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                    .withOperationName("CreateDeployment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     *
     * @param createDeploymentConfigRequest
     *        Represents the input of a <code>CreateDeploymentConfig</code> operation.
     * @return Result of the CreateDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigAlreadyExistsException
     *         A deployment configuration with the specified name with the user or Amazon Web Services account already
     *         exists.
     * @throws InvalidMinimumHealthyHostValueException
     *         The minimum healthy instance value was specified in an invalid format.
     * @throws DeploymentConfigLimitExceededException
     *         The deployment configurations limit was exceeded.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws InvalidZonalDeploymentConfigurationException
     *         The <code>ZonalConfig</code> object is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeploymentConfigResponse createDeploymentConfig(CreateDeploymentConfigRequest createDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigAlreadyExistsException, InvalidMinimumHealthyHostValueException,
            DeploymentConfigLimitExceededException, InvalidComputePlatformException, InvalidTrafficRoutingConfigurationException,
            InvalidZonalDeploymentConfigurationException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDeploymentConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentConfigRequest, CreateDeploymentConfigResponse>()
                            .withOperationName("CreateDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDeploymentConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDeploymentConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions are deployed.
     * </p>
     *
     * @param createDeploymentGroupRequest
     *        Represents the input of a <code>CreateDeploymentGroup</code> operation.
     * @return Result of the CreateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name with the user or Amazon Web Services account already exists.
     * @throws InvalidEc2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the user or Amazon Web Services account.
     * @throws RoleRequiredException
     *         The role ID was not specified.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws DeploymentGroupLimitExceededException
     *         The deployment groups limit was exceeded.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the limit of 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled, but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled, but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN."
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws InvalidEc2TagCombinationException
     *         A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types
     *         can be used in a single call.
     * @throws InvalidOnPremisesTagCombinationException
     *         A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these
     *         data types can be used in a single call.
     * @throws TagSetListLimitExceededException
     *         The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.
     * @throws InvalidInputException
     *         The input was specified in an invalid format.
     * @throws ThrottlingException
     *         An API function was called too frequently.
     * @throws InvalidEcsServiceException
     *         The Amazon ECS service identifier is not valid.
     * @throws InvalidTargetGroupPairException
     *         A target group pair associated with this deployment is not valid.
     * @throws EcsServiceMappingLimitExceededException
     *         The Amazon ECS service is associated with more than one deployment groups. An Amazon ECS service can be
     *         associated with only one deployment group.
     * @throws InvalidTagsToAddException
     *         The specified tags are not valid.
     * @throws InvalidTrafficRoutingConfigurationException
     *         The configuration that specifies how traffic is routed during a deployment is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.CreateDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeploymentGroupResponse createDeploymentGroup(CreateDeploymentGroupRequest createDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException,
            InvalidEc2TagException, InvalidTagException, InvalidAutoScalingGroupException, InvalidDeploymentConfigNameException,
            DeploymentConfigDoesNotExistException, RoleRequiredException, InvalidRoleException,
            DeploymentGroupLimitExceededException, LifecycleHookLimitExceededException, InvalidTriggerConfigException,
            TriggerTargetsLimitExceededException, InvalidAlarmConfigException, AlarmsLimitExceededException,
            InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException, InvalidDeploymentStyleException,
            InvalidBlueGreenDeploymentConfigurationException, InvalidEc2TagCombinationException,
            InvalidOnPremisesTagCombinationException, TagSetListLimitExceededException, InvalidInputException,
            ThrottlingException, InvalidEcsServiceException, InvalidTargetGroupPairException,
            EcsServiceMappingLimitExceededException, InvalidTagsToAddException, InvalidTrafficRoutingConfigurationException,
            AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDeploymentGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateDeploymentGroupRequest, CreateDeploymentGroupResponse>()
                    .withOperationName("CreateDeploymentGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDeploymentGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeploymentGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     *        Represents the input of a <code>DeleteApplication</code> operation.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, InvalidRoleException, AwsServiceException,
            SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");

            return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                    .withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     *
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a <code>DeleteDeploymentConfig</code> operation.
     * @return Result of the DeleteDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigInUseException
     *         The deployment configuration is still in use.
     * @throws InvalidOperationException
     *         An invalid operation was detected.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeploymentConfigResponse deleteDeploymentConfig(DeleteDeploymentConfigRequest deleteDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException, DeploymentConfigInUseException,
            InvalidOperationException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeploymentConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeploymentConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentConfigRequest, DeleteDeploymentConfigResponse>()
                            .withOperationName("DeleteDeploymentConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDeploymentConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDeploymentConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     *
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a <code>DeleteDeploymentGroup</code> operation.
     * @return Result of the DeleteDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeploymentGroupResponse deleteDeploymentGroup(DeleteDeploymentGroupRequest deleteDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, InvalidRoleException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeploymentGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeploymentGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResponse>()
                    .withOperationName("DeleteDeploymentGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDeploymentGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeploymentGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a GitHub account connection.
     * </p>
     *
     * @param deleteGitHubAccountTokenRequest
     *        Represents the input of a <code>DeleteGitHubAccount</code> operation.
     * @return Result of the DeleteGitHubAccountToken operation returned by the service.
     * @throws GitHubAccountTokenNameRequiredException
     *         The call is missing a required GitHub account connection name.
     * @throws GitHubAccountTokenDoesNotExistException
     *         No GitHub account connection exists with the named specified in the call.
     * @throws InvalidGitHubAccountTokenNameException
     *         The format of the specified GitHub account connection name is invalid.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws OperationNotSupportedException
     *         The API used does not support the deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteGitHubAccountToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGitHubAccountTokenResponse deleteGitHubAccountToken(
            DeleteGitHubAccountTokenRequest deleteGitHubAccountTokenRequest) throws GitHubAccountTokenNameRequiredException,
            GitHubAccountTokenDoesNotExistException, InvalidGitHubAccountTokenNameException, ResourceValidationException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGitHubAccountTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGitHubAccountTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGitHubAccountTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGitHubAccountTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGitHubAccountToken");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteGitHubAccountTokenRequest, DeleteGitHubAccountTokenResponse>()
                            .withOperationName("DeleteGitHubAccountToken").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteGitHubAccountTokenRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteGitHubAccountTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes resources linked to an external ID. This action only applies if you have configured blue/green
     * deployments through CloudFormation.
     * </p>
     * <note>
     * <p>
     * It is not necessary to call this action directly. CloudFormation calls it on your behalf when it needs to delete
     * stack resources. This action is offered publicly in case you need to delete resources to comply with General Data
     * Protection Regulation (GDPR) requirements.
     * </p>
     * </note>
     *
     * @param deleteResourcesByExternalIdRequest
     * @return Result of the DeleteResourcesByExternalId operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeleteResourcesByExternalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteResourcesByExternalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcesByExternalIdResponse deleteResourcesByExternalId(
            DeleteResourcesByExternalIdRequest deleteResourcesByExternalIdRequest) throws AwsServiceException,
            SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcesByExternalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcesByExternalIdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcesByExternalIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcesByExternalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcesByExternalId");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcesByExternalIdRequest, DeleteResourcesByExternalIdResponse>()
                            .withOperationName("DeleteResourcesByExternalId").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteResourcesByExternalIdRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResourcesByExternalIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     *
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.
     * @return Result of the DeregisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.DeregisterOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterOnPremisesInstanceResponse deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterOnPremisesInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterOnPremisesInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterOnPremisesInstanceRequest, DeregisterOnPremisesInstanceResponse>()
                            .withOperationName("DeregisterOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterOnPremisesInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterOnPremisesInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     *
     * @param getApplicationRequest
     *        Represents the input of a <code>GetApplication</code> operation.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplication");

            return clientHandler.execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                    .withOperationName("GetApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     *
     * @param getApplicationRevisionRequest
     *        Represents the input of a <code>GetApplicationRevision</code> operation.
     * @return Result of the GetApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the user or Amazon Web Services account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetApplicationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApplicationRevisionResponse getApplicationRevision(GetApplicationRevisionRequest getApplicationRevisionRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            RevisionDoesNotExistException, RevisionRequiredException, InvalidRevisionException, AwsServiceException,
            SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApplicationRevisionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRevisionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRevisionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationRevision");

            return clientHandler
                    .execute(new ClientExecutionParams<GetApplicationRevisionRequest, GetApplicationRevisionResponse>()
                            .withOperationName("GetApplicationRevision").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getApplicationRevisionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetApplicationRevisionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * <note>
     * <p>
     * The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always
     * null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned
     * <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file.
     * </p>
     * </note>
     *
     * @param getDeploymentRequest
     *        Represents the input of a <code>GetDeployment</code> operation.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the user or Amazon Web Services account does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws DeploymentIdRequiredException,
            InvalidDeploymentIdException, DeploymentDoesNotExistException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                    .withOperationName("GetDeployment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     *
     * @param getDeploymentConfigRequest
     *        Represents the input of a <code>GetDeploymentConfig</code> operation.
     * @return Result of the GetDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the user or Amazon Web Services account.
     * @throws InvalidComputePlatformException
     *         The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>,
     *         or <code>ECS</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeploymentConfigResponse getDeploymentConfig(GetDeploymentConfigRequest getDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigDoesNotExistException, InvalidComputePlatformException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeploymentConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentConfig");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentConfigRequest, GetDeploymentConfigResponse>()
                    .withOperationName("GetDeploymentConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDeploymentConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     *
     * @param getDeploymentGroupRequest
     *        Represents the input of a <code>GetDeploymentGroup</code> operation.
     * @return Result of the GetDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group with the user or Amazon Web Services account does not exist.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the user or Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeploymentGroupResponse getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            DeploymentConfigDoesNotExistException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeploymentGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentGroup");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentGroupRequest, GetDeploymentGroupResponse>()
                    .withOperationName("GetDeploymentGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDeploymentGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a deployment target.
     * </p>
     *
     * @param getDeploymentTargetRequest
     * @return Result of the GetDeploymentTarget operation returned by the service.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment with the user or Amazon Web Services account does not exist.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws DeploymentTargetIdRequiredException
     *         A deployment target ID was not provided.
     * @throws InvalidDeploymentTargetIdException
     *         The target ID provided was not valid.
     * @throws DeploymentTargetDoesNotExistException
     *         The provided target ID does not belong to the attempted deployment.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetDeploymentTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeploymentTargetResponse getDeploymentTarget(GetDeploymentTargetRequest getDeploymentTargetRequest)
            throws InvalidDeploymentIdException, DeploymentIdRequiredException, DeploymentDoesNotExistException,
            DeploymentNotStartedException, DeploymentTargetIdRequiredException, InvalidDeploymentTargetIdException,
            DeploymentTargetDoesNotExistException, InvalidInstanceNameException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeploymentTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentTarget");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentTargetRequest, GetDeploymentTargetResponse>()
                    .withOperationName("GetDeploymentTarget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDeploymentTargetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     *
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a <code>GetOnPremisesInstance</code> operation.
     * @return Result of the GetOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws InvalidInstanceNameException
     *         The on-premises instance name was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.GetOnPremisesInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOnPremisesInstanceResponse getOnPremisesInstance(GetOnPremisesInstanceRequest getOnPremisesInstanceRequest)
            throws InstanceNameRequiredException, InstanceNotRegisteredException, InvalidInstanceNameException,
            AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetOnPremisesInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOnPremisesInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOnPremisesInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOnPremisesInstance");

            return clientHandler.execute(new ClientExecutionParams<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResponse>()
                    .withOperationName("GetOnPremisesInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getOnPremisesInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOnPremisesInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     *
     * @param listApplicationRevisionsRequest
     *        Represents the input of a <code>ListApplicationRevisions</code> operation.
     * @return Result of the ListApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the user or Amazon Web Services account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListApplicationRevisionsResponse listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, InvalidSortByException, InvalidSortOrderException,
            InvalidBucketNameFilterException, InvalidKeyPrefixFilterException, BucketNameFilterRequiredException,
            InvalidDeployedStateFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListApplicationRevisionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationRevisions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListApplicationRevisionsRequest, ListApplicationRevisionsResponse>()
                            .withOperationName("ListApplicationRevisions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listApplicationRevisionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListApplicationRevisionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the applications registered with the user or Amazon Web Services account.
     * </p>
     *
     * @param listApplicationsRequest
     *        Represents the input of a <code>ListApplications</code> operation.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRollbackConfigException::builder).build());
            case "DeploymentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentLimitExceededException::builder).build());
            case "InvalidECSServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidECSServiceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEcsServiceException::builder).build());
            case "InvalidArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidArnException::builder).build());
            case "InvalidTagFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagFilterException::builder).build());
            case "DeploymentAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentAlreadyCompletedException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "DeploymentGroupLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupLimitExceededException::builder).build());
            case "InvalidDeploymentGroupNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentGroupNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentGroupNameException::builder).build());
            case "DeploymentTargetDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetDoesNotExistException::builder).build());
            case "AlarmsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlarmsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlarmsLimitExceededException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "InvalidGitHubAccountTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenException::builder).build());
            case "TriggerTargetsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TriggerTargetsLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TriggerTargetsLimitExceededException::builder).build());
            case "ECSServiceMappingLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ECSServiceMappingLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EcsServiceMappingLimitExceededException::builder).build());
            case "InvalidLoadBalancerInfoException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerInfoException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLoadBalancerInfoException::builder).build());
            case "MultipleIamArnsProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleIamArnsProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MultipleIamArnsProvidedException::builder).build());
            case "InvalidEC2TagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagException::builder).build());
            case "InvalidDeploymentConfigNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentConfigNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentConfigNameException::builder).build());
            case "LifecycleHookLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleHookLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleHookLimitExceededException::builder).build());
            case "IamUserArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamUserArnAlreadyRegisteredException::builder).build());
            case "RevisionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionRequiredException::builder).build());
            case "DeploymentIsNotInReadyStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIsNotInReadyStateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentIsNotInReadyStateException::builder).build());
            case "InvalidGitHubAccountTokenNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGitHubAccountTokenNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidGitHubAccountTokenNameException::builder).build());
            case "InstanceNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNotRegisteredException::builder).build());
            case "InvalidBlueGreenDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlueGreenDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidBlueGreenDeploymentConfigurationException::builder)
                        .build());
            case "ApplicationAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationAlreadyExistsException::builder).build());
            case "InvalidDeployedStateFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeployedStateFilterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeployedStateFilterException::builder).build());
            case "DeploymentTargetIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentTargetIdRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetIdRequiredException::builder).build());
            case "InvalidAlarmConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAlarmConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAlarmConfigException::builder).build());
            case "DescriptionTooLongException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DescriptionTooLongException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DescriptionTooLongException::builder).build());
            case "InvalidInstanceStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceStatusException::builder).build());
            case "InstanceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceLimitExceededException::builder).build());
            case "DeploymentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentIdRequiredException::builder).build());
            case "InvalidIgnoreApplicationStopFailuresValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIgnoreApplicationStopFailuresValueException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIgnoreApplicationStopFailuresValueException::builder).build());
            case "DeploymentConfigNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigNameRequiredException::builder).build());
            case "InvalidTargetGroupPairException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetGroupPairException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetGroupPairException::builder).build());
            case "InvalidTargetFilterNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetFilterNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetFilterNameException::builder).build());
            case "ApplicationLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationLimitExceededException::builder).build());
            case "InvalidRegistrationStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegistrationStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRegistrationStatusException::builder).build());
            case "InvalidLifecycleEventHookExecutionStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionStatusException::builder)
                        .build());
            case "InvalidExternalIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExternalIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidExternalIdException::builder).build());
            case "DeploymentGroupDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupDoesNotExistException::builder).build());
            case "UnsupportedActionForDeploymentTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionForDeploymentTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedActionForDeploymentTypeException::builder)
                        .build());
            case "InvalidMinimumHealthyHostValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMinimumHealthyHostValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidMinimumHealthyHostValueException::builder).build());
            case "BatchLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BatchLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BatchLimitExceededException::builder).build());
            case "ApplicationDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationDoesNotExistException::builder).build());
            case "InvalidTargetInstancesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetInstancesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetInstancesException::builder).build());
            case "TagRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagRequiredException::builder).build());
            case "BucketNameFilterRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BucketNameFilterRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BucketNameFilterRequiredException::builder).build());
            case "InvalidIamUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamUserArnException::builder).build());
            case "InvalidInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceTypeException::builder).build());
            case "InvalidTriggerConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTriggerConfigException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTriggerConfigException::builder).build());
            case "IamArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamArnRequiredException::builder).build());
            case "InvalidKeyPrefixFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyPrefixFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyPrefixFilterException::builder).build());
            case "GitHubAccountTokenNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenNameRequiredException::builder).build());
            case "InvalidBucketNameFilterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBucketNameFilterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBucketNameFilterException::builder).build());
            case "InvalidComputePlatformException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidComputePlatformException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidComputePlatformException::builder).build());
            case "RoleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RoleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RoleRequiredException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "DeploymentNotStartedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentNotStartedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentNotStartedException::builder).build());
            case "LifecycleEventAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LifecycleEventAlreadyCompletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(LifecycleEventAlreadyCompletedException::builder).build());
            case "InvalidIamSessionArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIamSessionArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidIamSessionArnException::builder).build());
            case "DeploymentGroupAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupAlreadyExistsException::builder).build());
            case "InvalidOnPremisesTagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOnPremisesTagCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidOnPremisesTagCombinationException::builder).build());
            case "InstanceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InstanceNameRequiredException::builder).build());
            case "DeploymentConfigLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigLimitExceededException::builder).build());
            case "InvalidRevisionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionException::builder).build());
            case "IamUserArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamUserArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IamUserArnRequiredException::builder).build());
            case "InvalidUpdateOutdatedInstancesOnlyValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdateOutdatedInstancesOnlyValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidUpdateOutdatedInstancesOnlyValueException::builder)
                        .build());
            case "InvalidEC2TagCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEC2TagCombinationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEc2TagCombinationException::builder).build());
            case "InvalidDeploymentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentIdException::builder).build());
            case "ArnNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ArnNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ArnNotSupportedException::builder).build());
            case "DeploymentTargetListSizeExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("DeploymentTargetListSizeExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(DeploymentTargetListSizeExceededException::builder)
                                .build());
            case "InvalidDeploymentStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStatusException::builder).build());
            case "InvalidInstanceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceNameException::builder).build());
            case "DeploymentConfigInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentConfigInUseException::builder).build());
            case "DeploymentConfigAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigAlreadyExistsException::builder).build());
            case "IamSessionArnAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IamSessionArnAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IamSessionArnAlreadyRegisteredException::builder).build());
            case "InstanceNameAlreadyRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNameAlreadyRegisteredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InstanceNameAlreadyRegisteredException::builder).build());
            case "InvalidTagException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidApplicationNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApplicationNameException::builder).build());
            case "InvalidDeploymentStyleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentStyleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeploymentStyleException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "InvalidInputException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInputException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "InvalidDeploymentInstanceTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentInstanceTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentInstanceTypeException::builder).build());
            case "DeploymentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DeploymentDoesNotExistException::builder).build());
            case "InvalidSortOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortOrderException::builder).build());
            case "DeploymentGroupNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentGroupNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentGroupNameRequiredException::builder).build());
            case "RevisionDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionDoesNotExistException::builder).build());
            case "InvalidRoleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidFileExistsBehaviorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileExistsBehaviorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidFileExistsBehaviorException::builder).build());
            case "InvalidDeploymentTargetIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentTargetIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentTargetIdException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "InvalidDeploymentWaitTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeploymentWaitTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeploymentWaitTypeException::builder).build());
            case "InvalidAutoScalingGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoScalingGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutoScalingGroupException::builder).build());
            case "InvalidTrafficRoutingConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrafficRoutingConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidTrafficRoutingConfigurationException::builder)
                        .build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeDeploy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplications");

            return clientHandler.execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                    .withOperationName("ListApplications").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the deployment configurations with the user or Amazon Web Services account.
     * </p>
     *
     * @param listDeploymentConfigsRequest
     *        Represents the input of a <code>ListDeploymentConfigs</code> operation.
     * @return Result of the ListDeploymentConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeDeployException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeploymentConfigsResponse listDeploymentConfigs(ListDeploymentConfigsRequest listDeploymentConfigsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, CodeDeployException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeploymentConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDeploymentConfigsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceValidationException::builder).build());
            case "InvalidZonalDeploymentConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidZonalDeploymentConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidZonalDeploymentConfigurationException::builder)
                        .build());
            case "GitHubAccountTokenDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GitHubAccountTokenDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(GitHubAccountTokenDoesNotExistException::builder).build());
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidTagsToAddException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsToAddException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsToAddException::builder).build());
            case "TagSetListLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagSetListLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagSetListLimitExceededException::builder).build());
            case "DeploymentConfigDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeploymentConfigDoesNotExistException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DeploymentConfigDoesNotExistException::builder).build());
            case "ApplicationNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNameRequiredException::builder).build());
            case "InvalidLifecycleEventHookExecutionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLifecycleEventHookExecutionIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidLifecycleEventHookExecutionIdException::builder)
                        .build());
            case "InvalidAutoRollbackConfigException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutoRollbackConfigException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutoRol