/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.Tag;
import software.amazon.awssdk.services.codedeploy.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceInfo> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(InstanceInfo.getter(InstanceInfo::instanceName)).setter(InstanceInfo.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> IAM_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamSessionArn").getter(InstanceInfo.getter(InstanceInfo::iamSessionArn)).setter(InstanceInfo.setter(Builder::iamSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamSessionArn").build()}).build();
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamUserArn").getter(InstanceInfo.getter(InstanceInfo::iamUserArn)).setter(InstanceInfo.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUserArn").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(InstanceInfo.getter(InstanceInfo::instanceArn)).setter(InstanceInfo.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<Instant> REGISTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("registerTime").getter(InstanceInfo.getter(InstanceInfo::registerTime)).setter(InstanceInfo.setter(Builder::registerTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registerTime").build()}).build();
    private static final SdkField<Instant> DEREGISTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deregisterTime").getter(InstanceInfo.getter(InstanceInfo::deregisterTime)).setter(InstanceInfo.setter(Builder::deregisterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deregisterTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(InstanceInfo.getter(InstanceInfo::tags)).setter(InstanceInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, IAM_SESSION_ARN_FIELD, IAM_USER_ARN_FIELD, INSTANCE_ARN_FIELD, REGISTER_TIME_FIELD, DEREGISTER_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceName;
    private final String iamSessionArn;
    private final String iamUserArn;
    private final String instanceArn;
    private final Instant registerTime;
    private final Instant deregisterTime;
    private final List<Tag> tags;

    private InstanceInfo(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
        this.instanceArn = builder.instanceArn;
        this.registerTime = builder.registerTime;
        this.deregisterTime = builder.deregisterTime;
        this.tags = builder.tags;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final String iamSessionArn() {
        return this.iamSessionArn;
    }

    public final String iamUserArn() {
        return this.iamUserArn;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final Instant registerTime() {
        return this.registerTime;
    }

    public final Instant deregisterTime() {
        return this.deregisterTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deregisterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.iamSessionArn(), other.iamSessionArn()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.registerTime(), other.registerTime()) && Objects.equals(this.deregisterTime(), other.deregisterTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceInfo").add("InstanceName", (Object)this.instanceName()).add("IamSessionArn", (Object)this.iamSessionArn()).add("IamUserArn", (Object)this.iamUserArn()).add("InstanceArn", (Object)this.instanceArn()).add("RegisterTime", (Object)this.registerTime()).add("DeregisterTime", (Object)this.deregisterTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "iamSessionArn": {
                return Optional.ofNullable(clazz.cast(this.iamSessionArn()));
            }
            case "iamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "registerTime": {
                return Optional.ofNullable(clazz.cast(this.registerTime()));
            }
            case "deregisterTime": {
                return Optional.ofNullable(clazz.cast(this.deregisterTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("iamSessionArn", IAM_SESSION_ARN_FIELD);
        map.put("iamUserArn", IAM_USER_ARN_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("registerTime", REGISTER_TIME_FIELD);
        map.put("deregisterTime", DEREGISTER_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceInfo, T> g) {
        return obj -> g.apply((InstanceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String iamSessionArn;
        private String iamUserArn;
        private String instanceArn;
        private Instant registerTime;
        private Instant deregisterTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            this.instanceName(model.instanceName);
            this.iamSessionArn(model.iamSessionArn);
            this.iamUserArn(model.iamUserArn);
            this.instanceArn(model.instanceArn);
            this.registerTime(model.registerTime);
            this.deregisterTime(model.deregisterTime);
            this.tags(model.tags);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getIamSessionArn() {
            return this.iamSessionArn;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final Instant getRegisterTime() {
            return this.registerTime;
        }

        public final void setRegisterTime(Instant registerTime) {
            this.registerTime = registerTime;
        }

        @Override
        public final Builder registerTime(Instant registerTime) {
            this.registerTime = registerTime;
            return this;
        }

        public final Instant getDeregisterTime() {
            return this.deregisterTime;
        }

        public final void setDeregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
        }

        @Override
        public final Builder deregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstanceInfo build() {
            return new InstanceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceInfo> {
        public Builder instanceName(String var1);

        public Builder iamSessionArn(String var1);

        public Builder iamUserArn(String var1);

        public Builder instanceArn(String var1);

        public Builder registerTime(Instant var1);

        public Builder deregisterTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

