/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EC2TagFilterType {
    KEY_ONLY("KEY_ONLY"),
    VALUE_ONLY("VALUE_ONLY"),
    KEY_AND_VALUE("KEY_AND_VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EC2TagFilterType> VALUE_MAP;
    private final String value;

    private EC2TagFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EC2TagFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EC2TagFilterType> knownValues() {
        EnumSet<EC2TagFilterType> knownValues = EnumSet.allOf(EC2TagFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EC2TagFilterType.class, EC2TagFilterType::toString);
    }
}

