/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Diagnostic information about executable scripts that are part of a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Diagnostics implements SdkPojo, Serializable, ToCopyableBuilder<Diagnostics.Builder, Diagnostics> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(Diagnostics::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> SCRIPT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptName").getter(getter(Diagnostics::scriptName)).setter(setter(Builder::scriptName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptName").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(Diagnostics::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> LOG_TAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logTail").getter(getter(Diagnostics::logTail)).setter(setter(Builder::logTail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            SCRIPT_NAME_FIELD, MESSAGE_FIELD, LOG_TAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String scriptName;

    private final String message;

    private final String logTail;

    private Diagnostics(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.scriptName = builder.scriptName;
        this.message = builder.message;
        this.logTail = builder.logTail;
    }

    /**
     * <p>
     * The associated error code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Success: The specified script ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptMissing: The specified script was not found in the specified location.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptNotExecutable: The specified script is not a recognized executable file type.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptTimedOut: The specified script did not finish running in the specified time period.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptFailed: The specified script failed to run as expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * UnknownError: The specified script did not run for an unknown reason.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link LifecycleErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The associated error code:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Success: The specified script ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptMissing: The specified script was not found in the specified location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptNotExecutable: The specified script is not a recognized executable file type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptTimedOut: The specified script did not finish running in the specified time period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptFailed: The specified script failed to run as expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UnknownError: The specified script did not run for an unknown reason.
     *         </p>
     *         </li>
     * @see LifecycleErrorCode
     */
    public final LifecycleErrorCode errorCode() {
        return LifecycleErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The associated error code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Success: The specified script ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptMissing: The specified script was not found in the specified location.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptNotExecutable: The specified script is not a recognized executable file type.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptTimedOut: The specified script did not finish running in the specified time period.
     * </p>
     * </li>
     * <li>
     * <p>
     * ScriptFailed: The specified script failed to run as expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * UnknownError: The specified script did not run for an unknown reason.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link LifecycleErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The associated error code:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Success: The specified script ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptMissing: The specified script was not found in the specified location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptNotExecutable: The specified script is not a recognized executable file type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptTimedOut: The specified script did not finish running in the specified time period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ScriptFailed: The specified script failed to run as expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UnknownError: The specified script did not run for an unknown reason.
     *         </p>
     *         </li>
     * @see LifecycleErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The name of the script.
     * </p>
     * 
     * @return The name of the script.
     */
    public final String scriptName() {
        return scriptName;
    }

    /**
     * <p>
     * The message associated with the error.
     * </p>
     * 
     * @return The message associated with the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The last portion of the diagnostic log.
     * </p>
     * <p>
     * If available, CodeDeploy returns up to the last 4 KB of the diagnostic log.
     * </p>
     * 
     * @return The last portion of the diagnostic log.</p>
     *         <p>
     *         If available, CodeDeploy returns up to the last 4 KB of the diagnostic log.
     */
    public final String logTail() {
        return logTail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scriptName());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(logTail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostics)) {
            return false;
        }
        Diagnostics other = (Diagnostics) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(scriptName(), other.scriptName())
                && Objects.equals(message(), other.message()) && Objects.equals(logTail(), other.logTail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Diagnostics").add("ErrorCode", errorCodeAsString()).add("ScriptName", scriptName())
                .add("Message", message()).add("LogTail", logTail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "scriptName":
            return Optional.ofNullable(clazz.cast(scriptName()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "logTail":
            return Optional.ofNullable(clazz.cast(logTail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("scriptName", SCRIPT_NAME_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("logTail", LOG_TAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Diagnostics, T> g) {
        return obj -> g.apply((Diagnostics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Diagnostics> {
        /**
         * <p>
         * The associated error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Success: The specified script ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptMissing: The specified script was not found in the specified location.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptNotExecutable: The specified script is not a recognized executable file type.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptTimedOut: The specified script did not finish running in the specified time period.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptFailed: The specified script failed to run as expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * UnknownError: The specified script did not run for an unknown reason.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        The associated error code:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Success: The specified script ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptMissing: The specified script was not found in the specified location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptNotExecutable: The specified script is not a recognized executable file type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptTimedOut: The specified script did not finish running in the specified time period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptFailed: The specified script failed to run as expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UnknownError: The specified script did not run for an unknown reason.
         *        </p>
         *        </li>
         * @see LifecycleErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The associated error code:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Success: The specified script ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptMissing: The specified script was not found in the specified location.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptNotExecutable: The specified script is not a recognized executable file type.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptTimedOut: The specified script did not finish running in the specified time period.
         * </p>
         * </li>
         * <li>
         * <p>
         * ScriptFailed: The specified script failed to run as expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * UnknownError: The specified script did not run for an unknown reason.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        The associated error code:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Success: The specified script ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptMissing: The specified script was not found in the specified location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptNotExecutable: The specified script is not a recognized executable file type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptTimedOut: The specified script did not finish running in the specified time period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ScriptFailed: The specified script failed to run as expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UnknownError: The specified script did not run for an unknown reason.
         *        </p>
         *        </li>
         * @see LifecycleErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleErrorCode
         */
        Builder errorCode(LifecycleErrorCode errorCode);

        /**
         * <p>
         * The name of the script.
         * </p>
         * 
         * @param scriptName
         *        The name of the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptName(String scriptName);

        /**
         * <p>
         * The message associated with the error.
         * </p>
         * 
         * @param message
         *        The message associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The last portion of the diagnostic log.
         * </p>
         * <p>
         * If available, CodeDeploy returns up to the last 4 KB of the diagnostic log.
         * </p>
         * 
         * @param logTail
         *        The last portion of the diagnostic log.</p>
         *        <p>
         *        If available, CodeDeploy returns up to the last 4 KB of the diagnostic log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTail(String logTail);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String scriptName;

        private String message;

        private String logTail;

        private BuilderImpl() {
        }

        private BuilderImpl(Diagnostics model) {
            errorCode(model.errorCode);
            scriptName(model.scriptName);
            message(model.message);
            logTail(model.logTail);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getScriptName() {
            return scriptName;
        }

        public final void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        @Override
        public final Builder scriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getLogTail() {
            return logTail;
        }

        public final void setLogTail(String logTail) {
            this.logTail = logTail;
        }

        @Override
        public final Builder logTail(String logTail) {
            this.logTail = logTail;
            return this;
        }

        @Override
        public Diagnostics build() {
            return new Diagnostics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
