/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetApplicationRevisionsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, BatchGetApplicationRevisionsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchGetApplicationRevisionsRequest.getter(BatchGetApplicationRevisionsRequest::applicationName)).setter(BatchGetApplicationRevisionsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<List<RevisionLocation>> REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetApplicationRevisionsRequest.getter(BatchGetApplicationRevisionsRequest::revisions)).setter(BatchGetApplicationRevisionsRequest.setter(Builder::revisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, REVISIONS_FIELD));
    private final String applicationName;
    private final List<RevisionLocation> revisions;

    private BatchGetApplicationRevisionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.revisions = builder.revisions;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<RevisionLocation> revisions() {
        return this.revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsRequest)) {
            return false;
        }
        BatchGetApplicationRevisionsRequest other = (BatchGetApplicationRevisionsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.revisions(), other.revisions());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetApplicationRevisionsRequest").add("ApplicationName", (Object)this.applicationName()).add("Revisions", this.revisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "revisions": {
                return Optional.ofNullable(clazz.cast(this.revisions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetApplicationRevisionsRequest, T> g) {
        return obj -> g.apply((BatchGetApplicationRevisionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private List<RevisionLocation> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.revisions(model.revisions);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<RevisionLocation.Builder> getRevisions() {
            return this.revisions != null ? (Collection)this.revisions.stream().map(RevisionLocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionLocation.Builder> ... revisions) {
            this.revisions(Stream.of(revisions).map(c -> (RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation.BuilderImpl> revisions) {
            this.revisions = RevisionLocationListCopier.copyFromBuilder(revisions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetApplicationRevisionsRequest build() {
            return new BatchGetApplicationRevisionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetApplicationRevisionsRequest> {
        public Builder applicationName(String var1);

        public Builder revisions(Collection<RevisionLocation> var1);

        public Builder revisions(RevisionLocation ... var1);

        public Builder revisions(Consumer<RevisionLocation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

