/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.TargetFilterName;
import software.amazon.awssdk.services.codedeploy.model.TargetFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentTargetsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListDeploymentTargetsRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeploymentTargetsRequest.getter(ListDeploymentTargetsRequest::deploymentId)).setter(ListDeploymentTargetsRequest.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeploymentTargetsRequest.getter(ListDeploymentTargetsRequest::nextToken)).setter(ListDeploymentTargetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Map<String, List<String>>> TARGET_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ListDeploymentTargetsRequest.getter(ListDeploymentTargetsRequest::targetFiltersAsStrings)).setter(ListDeploymentTargetsRequest.setter(Builder::targetFiltersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFilters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, NEXT_TOKEN_FIELD, TARGET_FILTERS_FIELD));
    private final String deploymentId;
    private final String nextToken;
    private final Map<String, List<String>> targetFilters;

    private ListDeploymentTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.nextToken = builder.nextToken;
        this.targetFilters = builder.targetFilters;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Map<TargetFilterName, List<String>> targetFilters() {
        return TypeConverter.convert(this.targetFilters, TargetFilterName::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)TargetFilterName.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, List<String>> targetFiltersAsStrings() {
        return this.targetFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFiltersAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentTargetsRequest)) {
            return false;
        }
        ListDeploymentTargetsRequest other = (ListDeploymentTargetsRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.targetFiltersAsStrings(), other.targetFiltersAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentTargetsRequest").add("DeploymentId", (Object)this.deploymentId()).add("NextToken", (Object)this.nextToken()).add("TargetFilters", this.targetFiltersAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "targetFilters": {
                return Optional.ofNullable(clazz.cast(this.targetFiltersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentTargetsRequest, T> g) {
        return obj -> g.apply((ListDeploymentTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String nextToken;
        private Map<String, List<String>> targetFilters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentTargetsRequest model) {
            super(model);
            this.deploymentId(model.deploymentId);
            this.nextToken(model.nextToken);
            this.targetFiltersWithStrings(model.targetFilters);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Map<String, ? extends Collection<String>> getTargetFiltersAsStrings() {
            return this.targetFilters;
        }

        @Override
        public final Builder targetFiltersWithStrings(Map<String, ? extends Collection<String>> targetFilters) {
            this.targetFilters = TargetFiltersCopier.copy(targetFilters);
            return this;
        }

        @Override
        public final Builder targetFilters(Map<TargetFilterName, ? extends Collection<String>> targetFilters) {
            this.targetFilters = TargetFiltersCopier.copyEnumToString(targetFilters);
            return this;
        }

        public final void setTargetFiltersWithStrings(Map<String, ? extends Collection<String>> targetFilters) {
            this.targetFilters = TargetFiltersCopier.copy(targetFilters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentTargetsRequest build() {
            return new ListDeploymentTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentTargetsRequest> {
        public Builder deploymentId(String var1);

        public Builder nextToken(String var1);

        public Builder targetFiltersWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder targetFilters(Map<TargetFilterName, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

