/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenericRevisionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GenericRevisionInfo> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GenericRevisionInfo.getter(GenericRevisionInfo::description)).setter(GenericRevisionInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> DEPLOYMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentGroups").getter(GenericRevisionInfo.getter(GenericRevisionInfo::deploymentGroups)).setter(GenericRevisionInfo.setter(Builder::deploymentGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> FIRST_USED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstUsedTime").getter(GenericRevisionInfo.getter(GenericRevisionInfo::firstUsedTime)).setter(GenericRevisionInfo.setter(Builder::firstUsedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstUsedTime").build()}).build();
    private static final SdkField<Instant> LAST_USED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUsedTime").getter(GenericRevisionInfo.getter(GenericRevisionInfo::lastUsedTime)).setter(GenericRevisionInfo.setter(Builder::lastUsedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUsedTime").build()}).build();
    private static final SdkField<Instant> REGISTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("registerTime").getter(GenericRevisionInfo.getter(GenericRevisionInfo::registerTime)).setter(GenericRevisionInfo.setter(Builder::registerTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registerTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DEPLOYMENT_GROUPS_FIELD, FIRST_USED_TIME_FIELD, LAST_USED_TIME_FIELD, REGISTER_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenericRevisionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> deploymentGroups;
    private final Instant firstUsedTime;
    private final Instant lastUsedTime;
    private final Instant registerTime;

    private GenericRevisionInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.deploymentGroups = builder.deploymentGroups;
        this.firstUsedTime = builder.firstUsedTime;
        this.lastUsedTime = builder.lastUsedTime;
        this.registerTime = builder.registerTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDeploymentGroups() {
        return this.deploymentGroups != null && !(this.deploymentGroups instanceof SdkAutoConstructList);
    }

    public final List<String> deploymentGroups() {
        return this.deploymentGroups;
    }

    public final Instant firstUsedTime() {
        return this.firstUsedTime;
    }

    public final Instant lastUsedTime() {
        return this.lastUsedTime;
    }

    public final Instant registerTime() {
        return this.registerTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentGroups() ? this.deploymentGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstUsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericRevisionInfo)) {
            return false;
        }
        GenericRevisionInfo other = (GenericRevisionInfo)obj;
        return Objects.equals(this.description(), other.description()) && this.hasDeploymentGroups() == other.hasDeploymentGroups() && Objects.equals(this.deploymentGroups(), other.deploymentGroups()) && Objects.equals(this.firstUsedTime(), other.firstUsedTime()) && Objects.equals(this.lastUsedTime(), other.lastUsedTime()) && Objects.equals(this.registerTime(), other.registerTime());
    }

    public final String toString() {
        return ToString.builder((String)"GenericRevisionInfo").add("Description", (Object)this.description()).add("DeploymentGroups", this.hasDeploymentGroups() ? this.deploymentGroups() : null).add("FirstUsedTime", (Object)this.firstUsedTime()).add("LastUsedTime", (Object)this.lastUsedTime()).add("RegisterTime", (Object)this.registerTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "deploymentGroups": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroups()));
            }
            case "firstUsedTime": {
                return Optional.ofNullable(clazz.cast(this.firstUsedTime()));
            }
            case "lastUsedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUsedTime()));
            }
            case "registerTime": {
                return Optional.ofNullable(clazz.cast(this.registerTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("deploymentGroups", DEPLOYMENT_GROUPS_FIELD);
        map.put("firstUsedTime", FIRST_USED_TIME_FIELD);
        map.put("lastUsedTime", LAST_USED_TIME_FIELD);
        map.put("registerTime", REGISTER_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenericRevisionInfo, T> g) {
        return obj -> g.apply((GenericRevisionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> deploymentGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant firstUsedTime;
        private Instant lastUsedTime;
        private Instant registerTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenericRevisionInfo model) {
            this.description(model.description);
            this.deploymentGroups(model.deploymentGroups);
            this.firstUsedTime(model.firstUsedTime);
            this.lastUsedTime(model.lastUsedTime);
            this.registerTime(model.registerTime);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getDeploymentGroups() {
            if (this.deploymentGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deploymentGroups;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String ... deploymentGroups) {
            this.deploymentGroups(Arrays.asList(deploymentGroups));
            return this;
        }

        public final Instant getFirstUsedTime() {
            return this.firstUsedTime;
        }

        public final void setFirstUsedTime(Instant firstUsedTime) {
            this.firstUsedTime = firstUsedTime;
        }

        @Override
        public final Builder firstUsedTime(Instant firstUsedTime) {
            this.firstUsedTime = firstUsedTime;
            return this;
        }

        public final Instant getLastUsedTime() {
            return this.lastUsedTime;
        }

        public final void setLastUsedTime(Instant lastUsedTime) {
            this.lastUsedTime = lastUsedTime;
        }

        @Override
        public final Builder lastUsedTime(Instant lastUsedTime) {
            this.lastUsedTime = lastUsedTime;
            return this;
        }

        public final Instant getRegisterTime() {
            return this.registerTime;
        }

        public final void setRegisterTime(Instant registerTime) {
            this.registerTime = registerTime;
        }

        @Override
        public final Builder registerTime(Instant registerTime) {
            this.registerTime = registerTime;
            return this;
        }

        public GenericRevisionInfo build() {
            return new GenericRevisionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GenericRevisionInfo> {
        public Builder description(String var1);

        public Builder deploymentGroups(Collection<String> var1);

        public Builder deploymentGroups(String ... var1);

        public Builder firstUsedTime(Instant var1);

        public Builder lastUsedTime(Instant var1);

        public Builder registerTime(Instant var1);
    }
}

