/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an UpdateDeploymentGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeploymentGroupResponse extends CodeDeployResponse implements
        ToCopyableBuilder<UpdateDeploymentGroupResponse.Builder, UpdateDeploymentGroupResponse> {
    private static final SdkField<List<AutoScalingGroup>> HOOKS_NOT_CLEANED_UP_FIELD = SdkField
            .<List<AutoScalingGroup>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDeploymentGroupResponse::hooksNotCleanedUp))
            .setter(setter(Builder::hooksNotCleanedUp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hooksNotCleanedUp").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOKS_NOT_CLEANED_UP_FIELD));

    private final List<AutoScalingGroup> hooksNotCleanedUp;

    private UpdateDeploymentGroupResponse(BuilderImpl builder) {
        super(builder);
        this.hooksNotCleanedUp = builder.hooksNotCleanedUp;
    }

    /**
     * <p>
     * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group,
     * AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the AWS account. If
     * the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the AWS
     * account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If the output contains no data, and the corresponding deployment group contained at least one Auto
     *         Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks
     *         from the AWS account. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling
     *         lifecycle event hooks from the AWS account.
     */
    public List<AutoScalingGroup> hooksNotCleanedUp() {
        return hooksNotCleanedUp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hooksNotCleanedUp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupResponse)) {
            return false;
        }
        UpdateDeploymentGroupResponse other = (UpdateDeploymentGroupResponse) obj;
        return Objects.equals(hooksNotCleanedUp(), other.hooksNotCleanedUp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDeploymentGroupResponse").add("HooksNotCleanedUp", hooksNotCleanedUp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hooksNotCleanedUp":
            return Optional.ofNullable(clazz.cast(hooksNotCleanedUp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentGroupResponse, T> g) {
        return obj -> g.apply((UpdateDeploymentGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeploymentGroupResponse> {
        /**
         * <p>
         * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling
         * group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the AWS
         * account. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks
         * from the AWS account.
         * </p>
         * 
         * @param hooksNotCleanedUp
         *        If the output contains no data, and the corresponding deployment group contained at least one Auto
         *        Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event
         *        hooks from the AWS account. If the output contains data, AWS CodeDeploy could not remove some Auto
         *        Scaling lifecycle event hooks from the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooksNotCleanedUp(Collection<AutoScalingGroup> hooksNotCleanedUp);

        /**
         * <p>
         * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling
         * group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the AWS
         * account. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks
         * from the AWS account.
         * </p>
         * 
         * @param hooksNotCleanedUp
         *        If the output contains no data, and the corresponding deployment group contained at least one Auto
         *        Scaling group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event
         *        hooks from the AWS account. If the output contains data, AWS CodeDeploy could not remove some Auto
         *        Scaling lifecycle event hooks from the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooksNotCleanedUp(AutoScalingGroup... hooksNotCleanedUp);

        /**
         * <p>
         * If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling
         * group, AWS CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the AWS
         * account. If the output contains data, AWS CodeDeploy could not remove some Auto Scaling lifecycle event hooks
         * from the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoScalingGroup>.Builder} avoiding the
         * need to create one manually via {@link List<AutoScalingGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoScalingGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #hooksNotCleanedUp(List<AutoScalingGroup>)}.
         * 
         * @param hooksNotCleanedUp
         *        a consumer that will call methods on {@link List<AutoScalingGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hooksNotCleanedUp(List<AutoScalingGroup>)
         */
        Builder hooksNotCleanedUp(Consumer<AutoScalingGroup.Builder>... hooksNotCleanedUp);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<AutoScalingGroup> hooksNotCleanedUp = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentGroupResponse model) {
            super(model);
            hooksNotCleanedUp(model.hooksNotCleanedUp);
        }

        public final Collection<AutoScalingGroup.Builder> getHooksNotCleanedUp() {
            return hooksNotCleanedUp != null ? hooksNotCleanedUp.stream().map(AutoScalingGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hooksNotCleanedUp(Collection<AutoScalingGroup> hooksNotCleanedUp) {
            this.hooksNotCleanedUp = AutoScalingGroupListCopier.copy(hooksNotCleanedUp);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksNotCleanedUp(AutoScalingGroup... hooksNotCleanedUp) {
            hooksNotCleanedUp(Arrays.asList(hooksNotCleanedUp));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooksNotCleanedUp(Consumer<AutoScalingGroup.Builder>... hooksNotCleanedUp) {
            hooksNotCleanedUp(Stream.of(hooksNotCleanedUp).map(c -> AutoScalingGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHooksNotCleanedUp(Collection<AutoScalingGroup.BuilderImpl> hooksNotCleanedUp) {
            this.hooksNotCleanedUp = AutoScalingGroupListCopier.copyFromBuilder(hooksNotCleanedUp);
        }

        @Override
        public UpdateDeploymentGroupResponse build() {
            return new UpdateDeploymentGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
