/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateDeployment operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends CodeDeployRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::deploymentGroupName)).setter(setter(Builder::deploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build())
            .build();

    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).getter(getter(CreateDeploymentRequest::revision))
            .setter(setter(Builder::revision)).constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::deploymentConfigName)).setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IGNORE_APPLICATION_STOP_FAILURES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateDeploymentRequest::ignoreApplicationStopFailures))
            .setter(setter(Builder::ignoreApplicationStopFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreApplicationStopFailures")
                    .build()).build();

    private static final SdkField<TargetInstances> TARGET_INSTANCES_FIELD = SdkField
            .<TargetInstances> builder(MarshallingType.SDK_POJO).getter(getter(CreateDeploymentRequest::targetInstances))
            .setter(setter(Builder::targetInstances)).constructor(TargetInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstances").build()).build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDeploymentRequest::autoRollbackConfiguration))
            .setter(setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<Boolean> UPDATE_OUTDATED_INSTANCES_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateDeploymentRequest::updateOutdatedInstancesOnly))
            .setter(setter(Builder::updateOutdatedInstancesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateOutdatedInstancesOnly")
                    .build()).build();

    private static final SdkField<String> FILE_EXISTS_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::fileExistsBehaviorAsString)).setter(setter(Builder::fileExistsBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileExistsBehavior").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_NAME_FIELD, REVISION_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, DESCRIPTION_FIELD,
            IGNORE_APPLICATION_STOP_FAILURES_FIELD, TARGET_INSTANCES_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD,
            UPDATE_OUTDATED_INSTANCES_ONLY_FIELD, FILE_EXISTS_BEHAVIOR_FIELD));

    private final String applicationName;

    private final String deploymentGroupName;

    private final RevisionLocation revision;

    private final String deploymentConfigName;

    private final String description;

    private final Boolean ignoreApplicationStopFailures;

    private final TargetInstances targetInstances;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final Boolean updateOutdatedInstancesOnly;

    private final String fileExistsBehavior;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.revision = builder.revision;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.description = builder.description;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.targetInstances = builder.targetInstances;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    /**
     * <p>
     * The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
     * </p>
     * 
     * @return The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of the deployment group.
     * </p>
     * 
     * @return The name of the deployment group.
     */
    public String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The type and location of the revision to deploy.
     * </p>
     * 
     * @return The type and location of the revision to deploy.
     */
    public RevisionLocation revision() {
        return revision;
    }

    /**
     * <p>
     * The name of a deployment configuration associated with the IAM user or AWS account.
     * </p>
     * <p>
     * If not specified, the value configured in the deployment group is used as the default. If the deployment group
     * does not have a deployment configuration associated with it, CodeDeployDefault.OneAtATime is used by default.
     * </p>
     * 
     * @return The name of a deployment configuration associated with the IAM user or AWS account.</p>
     *         <p>
     *         If not specified, the value configured in the deployment group is used as the default. If the deployment
     *         group does not have a deployment configuration associated with it, CodeDeployDefault.OneAtATime is used
     *         by default.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * A comment about the deployment.
     * </p>
     * 
     * @return A comment about the deployment.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If true, then if an ApplicationStop, BeforeBlockTraffic, or AfterBlockTraffic deployment lifecycle event to an
     * instance fails, then the deployment continues to the next deployment lifecycle event. For example, if
     * ApplicationStop fails, the deployment continues with DownloadBundle. If BeforeBlockTraffic fails, the deployment
     * continues with BlockTraffic. If AfterBlockTraffic fails, the deployment continues with ApplicationStop.
     * </p>
     * <p>
     * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment
     * fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not
     * less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
     * </p>
     * <p>
     * During a deployment, the AWS CodeDeploy agent runs the scripts specified for ApplicationStop, BeforeBlockTraffic,
     * and AfterBlockTraffic in the AppSpec file from the previous successful deployment. (All other scripts are run
     * from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run
     * successfully, the deployment can fail.
     * </p>
     * <p>
     * If the cause of the failure is a script from the last successful deployment that will never run successfully,
     * create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the ApplicationStop,
     * BeforeBlockTraffic, and AfterBlockTraffic failures should be ignored.
     * </p>
     * 
     * @return If true, then if an ApplicationStop, BeforeBlockTraffic, or AfterBlockTraffic deployment lifecycle event
     *         to an instance fails, then the deployment continues to the next deployment lifecycle event. For example,
     *         if ApplicationStop fails, the deployment continues with DownloadBundle. If BeforeBlockTraffic fails, the
     *         deployment continues with BlockTraffic. If AfterBlockTraffic fails, the deployment continues with
     *         ApplicationStop. </p>
     *         <p>
     *         If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
     *         deployment fails. If deployment to that instance is part of an overall deployment and the number of
     *         healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next
     *         instance is attempted.
     *         </p>
     *         <p>
     *         During a deployment, the AWS CodeDeploy agent runs the scripts specified for ApplicationStop,
     *         BeforeBlockTraffic, and AfterBlockTraffic in the AppSpec file from the previous successful deployment.
     *         (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts
     *         contains an error and does not run successfully, the deployment can fail.
     *         </p>
     *         <p>
     *         If the cause of the failure is a script from the last successful deployment that will never run
     *         successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that
     *         the ApplicationStop, BeforeBlockTraffic, and AfterBlockTraffic failures should be ignored.
     */
    public Boolean ignoreApplicationStopFailures() {
        return ignoreApplicationStopFailures;
    }

    /**
     * <p>
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about the instances that belong to the replacement environment in a blue/green deployment.
     */
    public TargetInstances targetInstances() {
        return targetInstances;
    }

    /**
     * <p>
     * Configuration information for an automatic rollback that is added when a deployment is created.
     * </p>
     * 
     * @return Configuration information for an automatic rollback that is added when a deployment is created.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Indicates whether to deploy to all instances or only to instances that are not running the latest application
     * revision.
     * </p>
     * 
     * @return Indicates whether to deploy to all instances or only to instances that are not running the latest
     *         application revision.
     */
    public Boolean updateOutdatedInstancesOnly() {
        return updateOutdatedInstancesOnly;
    }

    /**
     * <p>
     * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <p>
     * The fileExistsBehavior parameter takes any of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE: The version of the file from the application revision currently being deployed replaces the version
     * already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileExistsBehavior} will return {@link FileExistsBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #fileExistsBehaviorAsString}.
     * </p>
     * 
     * @return Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <p>
     *         The fileExistsBehavior parameter takes any of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE: The version of the file from the application revision currently being deployed replaces the
     *         version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(fileExistsBehavior);
    }

    /**
     * <p>
     * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <p>
     * The fileExistsBehavior parameter takes any of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE: The version of the file from the application revision currently being deployed replaces the version
     * already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileExistsBehavior} will return {@link FileExistsBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #fileExistsBehaviorAsString}.
     * </p>
     * 
     * @return Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <p>
     *         The fileExistsBehavior parameter takes any of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE: The version of the file from the application revision currently being deployed replaces the
     *         version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public String fileExistsBehaviorAsString() {
        return fileExistsBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(fileExistsBehaviorAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(deploymentGroupName(), other.deploymentGroupName())
                && Objects.equals(revision(), other.revision())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(description(), other.description())
                && Objects.equals(ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures())
                && Objects.equals(targetInstances(), other.targetInstances())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly())
                && Objects.equals(fileExistsBehaviorAsString(), other.fileExistsBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentRequest").add("ApplicationName", applicationName())
                .add("DeploymentGroupName", deploymentGroupName()).add("Revision", revision())
                .add("DeploymentConfigName", deploymentConfigName()).add("Description", description())
                .add("IgnoreApplicationStopFailures", ignoreApplicationStopFailures()).add("TargetInstances", targetInstances())
                .add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .add("UpdateOutdatedInstancesOnly", updateOutdatedInstancesOnly())
                .add("FileExistsBehavior", fileExistsBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupName":
            return Optional.ofNullable(clazz.cast(deploymentGroupName()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ignoreApplicationStopFailures":
            return Optional.ofNullable(clazz.cast(ignoreApplicationStopFailures()));
        case "targetInstances":
            return Optional.ofNullable(clazz.cast(targetInstances()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "updateOutdatedInstancesOnly":
            return Optional.ofNullable(clazz.cast(updateOutdatedInstancesOnly()));
        case "fileExistsBehavior":
            return Optional.ofNullable(clazz.cast(fileExistsBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
         * </p>
         * 
         * @param applicationName
         *        The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of the deployment group.
         * </p>
         * 
         * @param deploymentGroupName
         *        The name of the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The type and location of the revision to deploy.
         * </p>
         * 
         * @param revision
         *        The type and location of the revision to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * The type and location of the revision to deploy.
         * </p>
         * This is a convenience that creates an instance of the {@link RevisionLocation.Builder} avoiding the need to
         * create one manually via {@link RevisionLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #revision(RevisionLocation)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(RevisionLocation)
         */
        default Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return revision(RevisionLocation.builder().applyMutation(revision).build());
        }

        /**
         * <p>
         * The name of a deployment configuration associated with the IAM user or AWS account.
         * </p>
         * <p>
         * If not specified, the value configured in the deployment group is used as the default. If the deployment
         * group does not have a deployment configuration associated with it, CodeDeployDefault.OneAtATime is used by
         * default.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of a deployment configuration associated with the IAM user or AWS account.</p>
         *        <p>
         *        If not specified, the value configured in the deployment group is used as the default. If the
         *        deployment group does not have a deployment configuration associated with it,
         *        CodeDeployDefault.OneAtATime is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * A comment about the deployment.
         * </p>
         * 
         * @param description
         *        A comment about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If true, then if an ApplicationStop, BeforeBlockTraffic, or AfterBlockTraffic deployment lifecycle event to
         * an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if
         * ApplicationStop fails, the deployment continues with DownloadBundle. If BeforeBlockTraffic fails, the
         * deployment continues with BlockTraffic. If AfterBlockTraffic fails, the deployment continues with
         * ApplicationStop.
         * </p>
         * <p>
         * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
         * deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy
         * hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is
         * attempted.
         * </p>
         * <p>
         * During a deployment, the AWS CodeDeploy agent runs the scripts specified for ApplicationStop,
         * BeforeBlockTraffic, and AfterBlockTraffic in the AppSpec file from the previous successful deployment. (All
         * other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an
         * error and does not run successfully, the deployment can fail.
         * </p>
         * <p>
         * If the cause of the failure is a script from the last successful deployment that will never run successfully,
         * create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the
         * ApplicationStop, BeforeBlockTraffic, and AfterBlockTraffic failures should be ignored.
         * </p>
         * 
         * @param ignoreApplicationStopFailures
         *        If true, then if an ApplicationStop, BeforeBlockTraffic, or AfterBlockTraffic deployment lifecycle
         *        event to an instance fails, then the deployment continues to the next deployment lifecycle event. For
         *        example, if ApplicationStop fails, the deployment continues with DownloadBundle. If BeforeBlockTraffic
         *        fails, the deployment continues with BlockTraffic. If AfterBlockTraffic fails, the deployment
         *        continues with ApplicationStop. </p>
         *        <p>
         *        If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
         *        deployment fails. If deployment to that instance is part of an overall deployment and the number of
         *        healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next
         *        instance is attempted.
         *        </p>
         *        <p>
         *        During a deployment, the AWS CodeDeploy agent runs the scripts specified for ApplicationStop,
         *        BeforeBlockTraffic, and AfterBlockTraffic in the AppSpec file from the previous successful deployment.
         *        (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts
         *        contains an error and does not run successfully, the deployment can fail.
         *        </p>
         *        <p>
         *        If the cause of the failure is a script from the last successful deployment that will never run
         *        successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify
         *        that the ApplicationStop, BeforeBlockTraffic, and AfterBlockTraffic failures should be ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures);

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param targetInstances
         *        Information about the instances that belong to the replacement environment in a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(TargetInstances targetInstances);

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetInstances.Builder} avoiding the need to
         * create one manually via {@link TargetInstances#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetInstances.Builder#build()} is called immediately and its
         * result is passed to {@link #targetInstances(TargetInstances)}.
         * 
         * @param targetInstances
         *        a consumer that will call methods on {@link TargetInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetInstances(TargetInstances)
         */
        default Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return targetInstances(TargetInstances.builder().applyMutation(targetInstances).build());
        }

        /**
         * <p>
         * Configuration information for an automatic rollback that is added when a deployment is created.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Configuration information for an automatic rollback that is added when a deployment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Configuration information for an automatic rollback that is added when a deployment is created.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoRollbackConfiguration.Builder} avoiding the
         * need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Indicates whether to deploy to all instances or only to instances that are not running the latest application
         * revision.
         * </p>
         * 
         * @param updateOutdatedInstancesOnly
         *        Indicates whether to deploy to all instances or only to instances that are not running the latest
         *        application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <p>
         * The fileExistsBehavior parameter takes any of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <p>
         *        The fileExistsBehavior parameter takes any of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @see FileExistsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(String fileExistsBehavior);

        /**
         * <p>
         * Information about how AWS CodeDeploy handles files that already exist in a deployment target location but
         * weren't part of the previous successful deployment.
         * </p>
         * <p>
         * The fileExistsBehavior parameter takes any of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how AWS CodeDeploy handles files that already exist in a deployment target location
         *        but weren't part of the previous successful deployment.</p>
         *        <p>
         *        The fileExistsBehavior parameter takes any of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @see FileExistsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private RevisionLocation revision;

        private String deploymentConfigName;

        private String description;

        private Boolean ignoreApplicationStopFailures;

        private TargetInstances targetInstances;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private Boolean updateOutdatedInstancesOnly;

        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            applicationName(model.applicationName);
            deploymentGroupName(model.deploymentGroupName);
            revision(model.revision);
            deploymentConfigName(model.deploymentConfigName);
            description(model.description);
            ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            targetInstances(model.targetInstances);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            fileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final RevisionLocation.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return targetInstances != null ? targetInstances.toBuilder() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final String getFileExistsBehaviorAsString() {
            return fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
