/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentTargetsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<BatchGetDeploymentTargetsRequest.Builder, BatchGetDeploymentTargetsRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetDeploymentTargetsRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<List<String>> TARGET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDeploymentTargetsRequest::targetIds))
            .setter(setter(Builder::targetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            TARGET_IDS_FIELD));

    private final String deploymentId;

    private final List<String> targetIds;

    private BatchGetDeploymentTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.targetIds = builder.targetIds;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the
     * targets and their formats. The maximum number of deployment target IDs you can specify is 25.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises instances
     * IDs, and their target type is <code>instanceTarget</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions, and
     * their target type is <code>instanceTarget</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and
     * services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. Their target type is
     * <code>ecsTarget</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The unique IDs of the deployment targets. The compute platform of the deployment determines the type of
     *         the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises
     *         instances IDs, and their target type is <code>instanceTarget</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda
     *         functions, and their target type is <code>instanceTarget</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters
     *         and services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. Their
     *         target type is <code>ecsTarget</code>.
     *         </p>
     *         </li>
     */
    public List<String> targetIds() {
        return targetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(targetIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentTargetsRequest)) {
            return false;
        }
        BatchGetDeploymentTargetsRequest other = (BatchGetDeploymentTargetsRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(targetIds(), other.targetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetDeploymentTargetsRequest").add("DeploymentId", deploymentId())
                .add("TargetIds", targetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "targetIds":
            return Optional.ofNullable(clazz.cast(targetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentTargetsRequest, T> g) {
        return obj -> g.apply((BatchGetDeploymentTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetDeploymentTargetsRequest> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the
         * targets and their formats. The maximum number of deployment target IDs you can specify is 25.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises
         * instances IDs, and their target type is <code>instanceTarget</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions,
         * and their target type is <code>instanceTarget</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and
         * services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. Their target type
         * is <code>ecsTarget</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetIds
         *        The unique IDs of the deployment targets. The compute platform of the deployment determines the type
         *        of the targets and their formats. The maximum number of deployment target IDs you can specify is
         *        25.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises
         *        instances IDs, and their target type is <code>instanceTarget</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda
         *        functions, and their target type is <code>instanceTarget</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS
         *        clusters and services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         *        Their target type is <code>ecsTarget</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIds(Collection<String> targetIds);

        /**
         * <p>
         * The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the
         * targets and their formats. The maximum number of deployment target IDs you can specify is 25.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises
         * instances IDs, and their target type is <code>instanceTarget</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda functions,
         * and their target type is <code>instanceTarget</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and
         * services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. Their target type
         * is <code>ecsTarget</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetIds
         *        The unique IDs of the deployment targets. The compute platform of the deployment determines the type
         *        of the targets and their formats. The maximum number of deployment target IDs you can specify is
         *        25.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For deployments that use the EC2/On-premises compute platform, the target IDs are EC2 or on-premises
         *        instances IDs, and their target type is <code>instanceTarget</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For deployments that use the AWS Lambda compute platform, the target IDs are the names of Lambda
         *        functions, and their target type is <code>instanceTarget</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS
         *        clusters and services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>.
         *        Their target type is <code>ecsTarget</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIds(String... targetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private List<String> targetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentTargetsRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            targetIds(model.targetIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Collection<String> getTargetIds() {
            return targetIds;
        }

        @Override
        public final Builder targetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdListCopier.copy(targetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIds(String... targetIds) {
            targetIds(Arrays.asList(targetIds));
            return this;
        }

        public final void setTargetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdListCopier.copy(targetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentTargetsRequest build() {
            return new BatchGetDeploymentTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
