/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of an application revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevisionLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<RevisionLocation.Builder, RevisionLocation> {
    private static final SdkField<String> REVISION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RevisionLocation::revisionTypeAsString)).setter(setter(Builder::revisionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionType").build()).build();

    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(RevisionLocation::s3Location)).setter(setter(Builder::s3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<GitHubLocation> GIT_HUB_LOCATION_FIELD = SdkField
            .<GitHubLocation> builder(MarshallingType.SDK_POJO).getter(getter(RevisionLocation::gitHubLocation))
            .setter(setter(Builder::gitHubLocation)).constructor(GitHubLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitHubLocation").build()).build();

    private static final SdkField<RawString> STRING_FIELD = SdkField.<RawString> builder(MarshallingType.SDK_POJO)
            .getter(getter(RevisionLocation::string)).setter(setter(Builder::string)).constructor(RawString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()).build();

    private static final SdkField<AppSpecContent> APP_SPEC_CONTENT_FIELD = SdkField
            .<AppSpecContent> builder(MarshallingType.SDK_POJO).getter(getter(RevisionLocation::appSpecContent))
            .setter(setter(Builder::appSpecContent)).constructor(AppSpecContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appSpecContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_TYPE_FIELD,
            S3_LOCATION_FIELD, GIT_HUB_LOCATION_FIELD, STRING_FIELD, APP_SPEC_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String revisionType;

    private final S3Location s3Location;

    private final GitHubLocation gitHubLocation;

    private final RawString string;

    private final AppSpecContent appSpecContent;

    private RevisionLocation(BuilderImpl builder) {
        this.revisionType = builder.revisionType;
        this.s3Location = builder.s3Location;
        this.gitHubLocation = builder.gitHubLocation;
        this.string = builder.string;
        this.appSpecContent = builder.appSpecContent;
    }

    /**
     * <p>
     * The type of application revision:
     * </p>
     * <ul>
     * <li>
     * <p>
     * S3: An application revision stored in Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
     * </p>
     * </li>
     * <li>
     * <p>
     * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revisionType} will
     * return {@link RevisionLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revisionTypeAsString}.
     * </p>
     * 
     * @return The type of application revision:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         S3: An application revision stored in Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
     *         </p>
     *         </li>
     * @see RevisionLocationType
     */
    public RevisionLocationType revisionType() {
        return RevisionLocationType.fromValue(revisionType);
    }

    /**
     * <p>
     * The type of application revision:
     * </p>
     * <ul>
     * <li>
     * <p>
     * S3: An application revision stored in Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
     * </p>
     * </li>
     * <li>
     * <p>
     * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revisionType} will
     * return {@link RevisionLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revisionTypeAsString}.
     * </p>
     * 
     * @return The type of application revision:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         S3: An application revision stored in Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
     *         </p>
     *         </li>
     * @see RevisionLocationType
     */
    public String revisionTypeAsString() {
        return revisionType;
    }

    /**
     * <p>
     * Information about the location of a revision stored in Amazon S3.
     * </p>
     * 
     * @return Information about the location of a revision stored in Amazon S3.
     */
    public S3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * Information about the location of application artifacts stored in GitHub.
     * </p>
     * 
     * @return Information about the location of application artifacts stored in GitHub.
     */
    public GitHubLocation gitHubLocation() {
        return gitHubLocation;
    }

    /**
     * <p>
     * Information about the location of an AWS Lambda deployment revision stored as a RawString.
     * </p>
     * 
     * @return Information about the location of an AWS Lambda deployment revision stored as a RawString.
     */
    public RawString string() {
        return string;
    }

    /**
     * <p>
     * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON or
     * YAML and stored as a RawString.
     * </p>
     * 
     * @return The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as
     *         JSON or YAML and stored as a RawString.
     */
    public AppSpecContent appSpecContent() {
        return appSpecContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(gitHubLocation());
        hashCode = 31 * hashCode + Objects.hashCode(string());
        hashCode = 31 * hashCode + Objects.hashCode(appSpecContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionLocation)) {
            return false;
        }
        RevisionLocation other = (RevisionLocation) obj;
        return Objects.equals(revisionTypeAsString(), other.revisionTypeAsString())
                && Objects.equals(s3Location(), other.s3Location()) && Objects.equals(gitHubLocation(), other.gitHubLocation())
                && Objects.equals(string(), other.string()) && Objects.equals(appSpecContent(), other.appSpecContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RevisionLocation").add("RevisionType", revisionTypeAsString()).add("S3Location", s3Location())
                .add("GitHubLocation", gitHubLocation()).add("String", string()).add("AppSpecContent", appSpecContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionType":
            return Optional.ofNullable(clazz.cast(revisionTypeAsString()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "gitHubLocation":
            return Optional.ofNullable(clazz.cast(gitHubLocation()));
        case "string":
            return Optional.ofNullable(clazz.cast(string()));
        case "appSpecContent":
            return Optional.ofNullable(clazz.cast(appSpecContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevisionLocation, T> g) {
        return obj -> g.apply((RevisionLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevisionLocation> {
        /**
         * <p>
         * The type of application revision:
         * </p>
         * <ul>
         * <li>
         * <p>
         * S3: An application revision stored in Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
         * </p>
         * </li>
         * <li>
         * <p>
         * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
         * </p>
         * </li>
         * </ul>
         * 
         * @param revisionType
         *        The type of application revision:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        S3: An application revision stored in Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
         *        </p>
         *        </li>
         * @see RevisionLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevisionLocationType
         */
        Builder revisionType(String revisionType);

        /**
         * <p>
         * The type of application revision:
         * </p>
         * <ul>
         * <li>
         * <p>
         * S3: An application revision stored in Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
         * </p>
         * </li>
         * <li>
         * <p>
         * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
         * </p>
         * </li>
         * </ul>
         * 
         * @param revisionType
         *        The type of application revision:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        S3: An application revision stored in Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments only).
         *        </p>
         *        </li>
         * @see RevisionLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevisionLocationType
         */
        Builder revisionType(RevisionLocationType revisionType);

        /**
         * <p>
         * Information about the location of a revision stored in Amazon S3.
         * </p>
         * 
         * @param s3Location
         *        Information about the location of a revision stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3Location s3Location);

        /**
         * <p>
         * Information about the location of a revision stored in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Location(S3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3Location)
         */
        default Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return s3Location(S3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * Information about the location of application artifacts stored in GitHub.
         * </p>
         * 
         * @param gitHubLocation
         *        Information about the location of application artifacts stored in GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubLocation(GitHubLocation gitHubLocation);

        /**
         * <p>
         * Information about the location of application artifacts stored in GitHub.
         * </p>
         * This is a convenience that creates an instance of the {@link GitHubLocation.Builder} avoiding the need to
         * create one manually via {@link GitHubLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link GitHubLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #gitHubLocation(GitHubLocation)}.
         * 
         * @param gitHubLocation
         *        a consumer that will call methods on {@link GitHubLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHubLocation(GitHubLocation)
         */
        default Builder gitHubLocation(Consumer<GitHubLocation.Builder> gitHubLocation) {
            return gitHubLocation(GitHubLocation.builder().applyMutation(gitHubLocation).build());
        }

        /**
         * <p>
         * Information about the location of an AWS Lambda deployment revision stored as a RawString.
         * </p>
         * 
         * @param string
         *        Information about the location of an AWS Lambda deployment revision stored as a RawString.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder string(RawString string);

        /**
         * <p>
         * Information about the location of an AWS Lambda deployment revision stored as a RawString.
         * </p>
         * This is a convenience that creates an instance of the {@link RawString.Builder} avoiding the need to create
         * one manually via {@link RawString#builder()}.
         *
         * When the {@link Consumer} completes, {@link RawString.Builder#build()} is called immediately and its result
         * is passed to {@link #string(RawString)}.
         * 
         * @param string
         *        a consumer that will call methods on {@link RawString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #string(RawString)
         */
        default Builder string(Consumer<RawString.Builder> string) {
            return string(RawString.builder().applyMutation(string).build());
        }

        /**
         * <p>
         * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON
         * or YAML and stored as a RawString.
         * </p>
         * 
         * @param appSpecContent
         *        The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as
         *        JSON or YAML and stored as a RawString.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSpecContent(AppSpecContent appSpecContent);

        /**
         * <p>
         * The content of an AppSpec file for an AWS Lambda or Amazon ECS deployment. The content is formatted as JSON
         * or YAML and stored as a RawString.
         * </p>
         * This is a convenience that creates an instance of the {@link AppSpecContent.Builder} avoiding the need to
         * create one manually via {@link AppSpecContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppSpecContent.Builder#build()} is called immediately and its
         * result is passed to {@link #appSpecContent(AppSpecContent)}.
         * 
         * @param appSpecContent
         *        a consumer that will call methods on {@link AppSpecContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appSpecContent(AppSpecContent)
         */
        default Builder appSpecContent(Consumer<AppSpecContent.Builder> appSpecContent) {
            return appSpecContent(AppSpecContent.builder().applyMutation(appSpecContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String revisionType;

        private S3Location s3Location;

        private GitHubLocation gitHubLocation;

        private RawString string;

        private AppSpecContent appSpecContent;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionLocation model) {
            revisionType(model.revisionType);
            s3Location(model.s3Location);
            gitHubLocation(model.gitHubLocation);
            string(model.string);
            appSpecContent(model.appSpecContent);
        }

        public final String getRevisionTypeAsString() {
            return revisionType;
        }

        @Override
        public final Builder revisionType(String revisionType) {
            this.revisionType = revisionType;
            return this;
        }

        @Override
        public final Builder revisionType(RevisionLocationType revisionType) {
            this.revisionType(revisionType == null ? null : revisionType.toString());
            return this;
        }

        public final void setRevisionType(String revisionType) {
            this.revisionType = revisionType;
        }

        public final S3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public final GitHubLocation.Builder getGitHubLocation() {
            return gitHubLocation != null ? gitHubLocation.toBuilder() : null;
        }

        @Override
        public final Builder gitHubLocation(GitHubLocation gitHubLocation) {
            this.gitHubLocation = gitHubLocation;
            return this;
        }

        public final void setGitHubLocation(GitHubLocation.BuilderImpl gitHubLocation) {
            this.gitHubLocation = gitHubLocation != null ? gitHubLocation.build() : null;
        }

        public final RawString.Builder getString() {
            return string != null ? string.toBuilder() : null;
        }

        @Override
        public final Builder string(RawString string) {
            this.string = string;
            return this;
        }

        public final void setString(RawString.BuilderImpl string) {
            this.string = string != null ? string.build() : null;
        }

        public final AppSpecContent.Builder getAppSpecContent() {
            return appSpecContent != null ? appSpecContent.toBuilder() : null;
        }

        @Override
        public final Builder appSpecContent(AppSpecContent appSpecContent) {
            this.appSpecContent = appSpecContent;
            return this;
        }

        public final void setAppSpecContent(AppSpecContent.BuilderImpl appSpecContent) {
            this.appSpecContent = appSpecContent != null ? appSpecContent.build() : null;
        }

        @Override
        public RevisionLocation build() {
            return new RevisionLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
