/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroup.Builder, AutoScalingGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> HOOK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingGroup::hook)).setter(setter(Builder::hook))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hook").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOOK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String hook;

    private AutoScalingGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.hook = builder.hook;
    }

    /**
     * <p>
     * The Auto Scaling group name.
     * </p>
     * 
     * @return The Auto Scaling group name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An Auto Scaling lifecycle event hook name.
     * </p>
     * 
     * @return An Auto Scaling lifecycle event hook name.
     */
    public String hook() {
        return hook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hook());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(hook(), other.hook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoScalingGroup").add("Name", name()).add("Hook", hook()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "hook":
            return Optional.ofNullable(clazz.cast(hook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroup, T> g) {
        return obj -> g.apply((AutoScalingGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroup> {
        /**
         * <p>
         * The Auto Scaling group name.
         * </p>
         * 
         * @param name
         *        The Auto Scaling group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An Auto Scaling lifecycle event hook name.
         * </p>
         * 
         * @param hook
         *        An Auto Scaling lifecycle event hook name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(String hook);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String hook;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            name(model.name);
            hook(model.hook);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getHook() {
            return hook;
        }

        @Override
        public final Builder hook(String hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(String hook) {
            this.hook = hook;
        }

        @Override
        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
