/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TriggerEventType {
    DEPLOYMENT_START("DeploymentStart"),
    DEPLOYMENT_SUCCESS("DeploymentSuccess"),
    DEPLOYMENT_FAILURE("DeploymentFailure"),
    DEPLOYMENT_STOP("DeploymentStop"),
    DEPLOYMENT_ROLLBACK("DeploymentRollback"),
    DEPLOYMENT_READY("DeploymentReady"),
    INSTANCE_START("InstanceStart"),
    INSTANCE_SUCCESS("InstanceSuccess"),
    INSTANCE_FAILURE("InstanceFailure"),
    INSTANCE_READY("InstanceReady"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TriggerEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TriggerEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TriggerEventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TriggerEventType> knownValues() {
        return Stream.of(TriggerEventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

