/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfigInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfigInfo.Builder, DeploymentConfigInfo> {
    private static final SdkField<String> DEPLOYMENT_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentConfigInfo::deploymentConfigId)).setter(setter(Builder::deploymentConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigId").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentConfigInfo::deploymentConfigName)).setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<MinimumHealthyHosts> MINIMUM_HEALTHY_HOSTS_FIELD = SdkField
            .<MinimumHealthyHosts> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentConfigInfo::minimumHealthyHosts))
            .setter(setter(Builder::minimumHealthyHosts)).constructor(MinimumHealthyHosts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHosts").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DeploymentConfigInfo::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentConfigInfo::computePlatformAsString)).setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIG_FIELD = SdkField
            .<TrafficRoutingConfig> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentConfigInfo::trafficRoutingConfig))
            .setter(setter(Builder::trafficRoutingConfig)).constructor(TrafficRoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficRoutingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_ID_FIELD,
            DEPLOYMENT_CONFIG_NAME_FIELD, MINIMUM_HEALTHY_HOSTS_FIELD, CREATE_TIME_FIELD, COMPUTE_PLATFORM_FIELD,
            TRAFFIC_ROUTING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentConfigId;

    private final String deploymentConfigName;

    private final MinimumHealthyHosts minimumHealthyHosts;

    private final Instant createTime;

    private final String computePlatform;

    private final TrafficRoutingConfig trafficRoutingConfig;

    private DeploymentConfigInfo(BuilderImpl builder) {
        this.deploymentConfigId = builder.deploymentConfigId;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.createTime = builder.createTime;
        this.computePlatform = builder.computePlatform;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
    }

    /**
     * <p>
     * The deployment configuration ID.
     * </p>
     * 
     * @return The deployment configuration ID.
     */
    public String deploymentConfigId() {
        return deploymentConfigId;
    }

    /**
     * <p>
     * The deployment configuration name.
     * </p>
     * 
     * @return The deployment configuration name.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * Information about the number or percentage of minimum healthy instance.
     * </p>
     * 
     * @return Information about the number or percentage of minimum healthy instance.
     */
    public MinimumHealthyHosts minimumHealthyHosts() {
        return minimumHealthyHosts;
    }

    /**
     * <p>
     * The time at which the deployment configuration was created.
     * </p>
     * 
     * @return The time at which the deployment configuration was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
     *         <code>ECS</code>).
     * @see ComputePlatform
     */
    public String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * <p>
     * The configuration that specifies how the deployment traffic is routed. Only deployments with a Lambda compute
     * platform can specify this.
     * </p>
     * 
     * @return The configuration that specifies how the deployment traffic is routed. Only deployments with a Lambda
     *         compute platform can specify this.
     */
    public TrafficRoutingConfig trafficRoutingConfig() {
        return trafficRoutingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficRoutingConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfigInfo)) {
            return false;
        }
        DeploymentConfigInfo other = (DeploymentConfigInfo) obj;
        return Objects.equals(deploymentConfigId(), other.deploymentConfigId())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(minimumHealthyHosts(), other.minimumHealthyHosts())
                && Objects.equals(createTime(), other.createTime())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && Objects.equals(trafficRoutingConfig(), other.trafficRoutingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentConfigInfo").add("DeploymentConfigId", deploymentConfigId())
                .add("DeploymentConfigName", deploymentConfigName()).add("MinimumHealthyHosts", minimumHealthyHosts())
                .add("CreateTime", createTime()).add("ComputePlatform", computePlatformAsString())
                .add("TrafficRoutingConfig", trafficRoutingConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentConfigId":
            return Optional.ofNullable(clazz.cast(deploymentConfigId()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "minimumHealthyHosts":
            return Optional.ofNullable(clazz.cast(minimumHealthyHosts()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "trafficRoutingConfig":
            return Optional.ofNullable(clazz.cast(trafficRoutingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfigInfo, T> g) {
        return obj -> g.apply((DeploymentConfigInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfigInfo> {
        /**
         * <p>
         * The deployment configuration ID.
         * </p>
         * 
         * @param deploymentConfigId
         *        The deployment configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigId(String deploymentConfigId);

        /**
         * <p>
         * The deployment configuration name.
         * </p>
         * 
         * @param deploymentConfigName
         *        The deployment configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * Information about the number or percentage of minimum healthy instance.
         * </p>
         * 
         * @param minimumHealthyHosts
         *        Information about the number or percentage of minimum healthy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts);

        /**
         * <p>
         * Information about the number or percentage of minimum healthy instance.
         * </p>
         * This is a convenience that creates an instance of the {@link MinimumHealthyHosts.Builder} avoiding the need
         * to create one manually via {@link MinimumHealthyHosts#builder()}.
         *
         * When the {@link Consumer} completes, {@link MinimumHealthyHosts.Builder#build()} is called immediately and
         * its result is passed to {@link #minimumHealthyHosts(MinimumHealthyHosts)}.
         * 
         * @param minimumHealthyHosts
         *        a consumer that will call methods on {@link MinimumHealthyHosts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumHealthyHosts(MinimumHealthyHosts)
         */
        default Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return minimumHealthyHosts(MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts).build());
        }

        /**
         * <p>
         * The time at which the deployment configuration was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the deployment configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         * <code>ECS</code>).
         * </p>
         * 
         * @param computePlatform
         *        The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or
         *        <code>ECS</code>).
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The configuration that specifies how the deployment traffic is routed. Only deployments with a Lambda compute
         * platform can specify this.
         * </p>
         * 
         * @param trafficRoutingConfig
         *        The configuration that specifies how the deployment traffic is routed. Only deployments with a Lambda
         *        compute platform can specify this.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig);

        /**
         * <p>
         * The configuration that specifies how the deployment traffic is routed. Only deployments with a Lambda compute
         * platform can specify this.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficRoutingConfig.Builder} avoiding the need
         * to create one manually via {@link TrafficRoutingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficRoutingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficRoutingConfig(TrafficRoutingConfig)}.
         * 
         * @param trafficRoutingConfig
         *        a consumer that will call methods on {@link TrafficRoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficRoutingConfig(TrafficRoutingConfig)
         */
        default Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return trafficRoutingConfig(TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deploymentConfigId;

        private String deploymentConfigName;

        private MinimumHealthyHosts minimumHealthyHosts;

        private Instant createTime;

        private String computePlatform;

        private TrafficRoutingConfig trafficRoutingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfigInfo model) {
            deploymentConfigId(model.deploymentConfigId);
            deploymentConfigName(model.deploymentConfigName);
            minimumHealthyHosts(model.minimumHealthyHosts);
            createTime(model.createTime);
            computePlatform(model.computePlatform);
            trafficRoutingConfig(model.trafficRoutingConfig);
        }

        public final String getDeploymentConfigId() {
            return deploymentConfigId;
        }

        @Override
        public final Builder deploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
            return this;
        }

        public final void setDeploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return minimumHealthyHosts != null ? minimumHealthyHosts.toBuilder() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getComputePlatformAsString() {
            return computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return trafficRoutingConfig != null ? trafficRoutingConfig.toBuilder() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        @Override
        public DeploymentConfigInfo build() {
            return new DeploymentConfigInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
