/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a BatchGetDeploymentGroups operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDeploymentGroupsResponse extends CodeDeployResponse implements
        ToCopyableBuilder<BatchGetDeploymentGroupsResponse.Builder, BatchGetDeploymentGroupsResponse> {
    private static final SdkField<List<DeploymentGroupInfo>> DEPLOYMENT_GROUPS_INFO_FIELD = SdkField
            .<List<DeploymentGroupInfo>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDeploymentGroupsResponse::deploymentGroupsInfo))
            .setter(setter(Builder::deploymentGroupsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentGroupInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentGroupInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetDeploymentGroupsResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_GROUPS_INFO_FIELD,
            ERROR_MESSAGE_FIELD));

    private final List<DeploymentGroupInfo> deploymentGroupsInfo;

    private final String errorMessage;

    private BatchGetDeploymentGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentGroupsInfo = builder.deploymentGroupsInfo;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Information about the deployment groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the deployment groups.
     */
    public List<DeploymentGroupInfo> deploymentGroupsInfo() {
        return deploymentGroupsInfo;
    }

    /**
     * <p>
     * Information about errors that might have occurred during the API call.
     * </p>
     * 
     * @return Information about errors that might have occurred during the API call.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsResponse)) {
            return false;
        }
        BatchGetDeploymentGroupsResponse other = (BatchGetDeploymentGroupsResponse) obj;
        return Objects.equals(deploymentGroupsInfo(), other.deploymentGroupsInfo())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetDeploymentGroupsResponse").add("DeploymentGroupsInfo", deploymentGroupsInfo())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentGroupsInfo":
            return Optional.ofNullable(clazz.cast(deploymentGroupsInfo()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentGroupsResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * 
         * @param deploymentGroupsInfo
         *        Information about the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo);

        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * 
         * @param deploymentGroupsInfo
         *        Information about the deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo);

        /**
         * <p>
         * Information about the deployment groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeploymentGroupInfo>.Builder} avoiding the
         * need to create one manually via {@link List<DeploymentGroupInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentGroupInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentGroupsInfo(List<DeploymentGroupInfo>)}.
         * 
         * @param deploymentGroupsInfo
         *        a consumer that will call methods on {@link List<DeploymentGroupInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentGroupsInfo(List<DeploymentGroupInfo>)
         */
        Builder deploymentGroupsInfo(Consumer<DeploymentGroupInfo.Builder>... deploymentGroupsInfo);

        /**
         * <p>
         * Information about errors that might have occurred during the API call.
         * </p>
         * 
         * @param errorMessage
         *        Information about errors that might have occurred during the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private List<DeploymentGroupInfo> deploymentGroupsInfo = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsResponse model) {
            super(model);
            deploymentGroupsInfo(model.deploymentGroupsInfo);
            errorMessage(model.errorMessage);
        }

        public final Collection<DeploymentGroupInfo.Builder> getDeploymentGroupsInfo() {
            return deploymentGroupsInfo != null ? deploymentGroupsInfo.stream().map(DeploymentGroupInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(DeploymentGroupInfo... deploymentGroupsInfo) {
            deploymentGroupsInfo(Arrays.asList(deploymentGroupsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(Consumer<DeploymentGroupInfo.Builder>... deploymentGroupsInfo) {
            deploymentGroupsInfo(Stream.of(deploymentGroupsInfo).map(c -> DeploymentGroupInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentGroupsInfo(Collection<DeploymentGroupInfo.BuilderImpl> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copyFromBuilder(deploymentGroupsInfo);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchGetDeploymentGroupsResponse build() {
            return new BatchGetDeploymentGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
