/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinueDeploymentRequest extends CodeDeployRequest implements
        ToCopyableBuilder<ContinueDeploymentRequest.Builder, ContinueDeploymentRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContinueDeploymentRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_WAIT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContinueDeploymentRequest::deploymentWaitTypeAsString)).setter(setter(Builder::deploymentWaitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentWaitType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            DEPLOYMENT_WAIT_TYPE_FIELD));

    private final String deploymentId;

    private final String deploymentWaitType;

    private ContinueDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.deploymentWaitType = builder.deploymentWaitType;
    }

    /**
     * <p>
     * The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement
     * environment.
     * </p>
     * 
     * @return The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement
     *         environment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start shifting
     * traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not terminated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentWaitType} will return {@link DeploymentWaitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deploymentWaitTypeAsString}.
     * </p>
     * 
     * @return The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start
     *         shifting traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not
     *         terminated.
     * @see DeploymentWaitType
     */
    public DeploymentWaitType deploymentWaitType() {
        return DeploymentWaitType.fromValue(deploymentWaitType);
    }

    /**
     * <p>
     * The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start shifting
     * traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not terminated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentWaitType} will return {@link DeploymentWaitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deploymentWaitTypeAsString}.
     * </p>
     * 
     * @return The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start
     *         shifting traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not
     *         terminated.
     * @see DeploymentWaitType
     */
    public String deploymentWaitTypeAsString() {
        return deploymentWaitType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentWaitTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueDeploymentRequest)) {
            return false;
        }
        ContinueDeploymentRequest other = (ContinueDeploymentRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentWaitTypeAsString(), other.deploymentWaitTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContinueDeploymentRequest").add("DeploymentId", deploymentId())
                .add("DeploymentWaitType", deploymentWaitTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "deploymentWaitType":
            return Optional.ofNullable(clazz.cast(deploymentWaitTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinueDeploymentRequest, T> g) {
        return obj -> g.apply((ContinueDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, ContinueDeploymentRequest> {
        /**
         * <p>
         * The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement
         * environment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a blue/green deployment for which you want to start rerouting traffic to the
         *        replacement environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start shifting
         * traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not terminated.
         * </p>
         * 
         * @param deploymentWaitType
         *        The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start
         *        shifting traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not
         *        terminated.
         * @see DeploymentWaitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentWaitType
         */
        Builder deploymentWaitType(String deploymentWaitType);

        /**
         * <p>
         * The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start shifting
         * traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not terminated.
         * </p>
         * 
         * @param deploymentWaitType
         *        The status of the deployment's waiting period. READY_WAIT indicates the deployment is ready to start
         *        shifting traffic. TERMINATION_WAIT indicates the traffic is shifted, but the original target is not
         *        terminated.
         * @see DeploymentWaitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentWaitType
         */
        Builder deploymentWaitType(DeploymentWaitType deploymentWaitType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private String deploymentWaitType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueDeploymentRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            deploymentWaitType(model.deploymentWaitType);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDeploymentWaitTypeAsString() {
            return deploymentWaitType;
        }

        @Override
        public final Builder deploymentWaitType(String deploymentWaitType) {
            this.deploymentWaitType = deploymentWaitType;
            return this;
        }

        @Override
        public final Builder deploymentWaitType(DeploymentWaitType deploymentWaitType) {
            this.deploymentWaitType(deploymentWaitType == null ? null : deploymentWaitType.toString());
            return this;
        }

        public final void setDeploymentWaitType(String deploymentWaitType) {
            this.deploymentWaitType = deploymentWaitType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ContinueDeploymentRequest build() {
            return new ContinueDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
