/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Pipeline;

public class ListPipelinesPublisher
implements SdkPublisher<ListPipelinesResponse> {
    private final ElasticTranscoderAsyncClient client;
    private final ListPipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelinesPublisher(ElasticTranscoderAsyncClient client, ListPipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelinesPublisher(ElasticTranscoderAsyncClient client, ListPipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Pipeline> pipelines() {
        Function<ListPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelines() != null) {
                return response.pipelines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListPipelinesPublisher resume(ListPipelinesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPipelinesPublisher(this.client, (ListPipelinesRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPipelinesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPipelinesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPipelinesResponseFetcher
    implements AsyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListPipelinesResponse> nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesPublisher.this.client.listPipelines(ListPipelinesPublisher.this.firstRequest);
            }
            return ListPipelinesPublisher.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

