/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Pipeline;
import software.amazon.awssdk.services.elastictranscoder.model.Warning;
import software.amazon.awssdk.services.elastictranscoder.model.WarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadPipelineResponse
extends ElasticTranscoderResponse
implements ToCopyableBuilder<Builder, ReadPipelineResponse> {
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReadPipelineResponse.getter(ReadPipelineResponse::pipeline)).setter(ReadPipelineResponse.setter(Builder::pipeline)).constructor(Pipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()}).build();
    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReadPipelineResponse.getter(ReadPipelineResponse::warnings)).setter(ReadPipelineResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Warning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD, WARNINGS_FIELD));
    private final Pipeline pipeline;
    private final List<Warning> warnings;

    private ReadPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.warnings = builder.warnings;
    }

    public Pipeline pipeline() {
        return this.pipeline;
    }

    public List<Warning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadPipelineResponse)) {
            return false;
        }
        ReadPipelineResponse other = (ReadPipelineResponse)((Object)obj);
        return Objects.equals(this.pipeline(), other.pipeline()) && Objects.equals(this.warnings(), other.warnings());
    }

    public String toString() {
        return ToString.builder((String)"ReadPipelineResponse").add("Pipeline", (Object)this.pipeline()).add("Warnings", this.warnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pipeline": {
                return Optional.ofNullable(clazz.cast(this.pipeline()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReadPipelineResponse, T> g) {
        return obj -> g.apply((ReadPipelineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderResponse.BuilderImpl
    implements Builder {
        private Pipeline pipeline;
        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReadPipelineResponse model) {
            super(model);
            this.pipeline(model.pipeline);
            this.warnings(model.warnings);
        }

        public final Pipeline.Builder getPipeline() {
            return this.pipeline != null ? this.pipeline.toBuilder() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        public final Collection<Warning.Builder> getWarnings() {
            return this.warnings != null ? (Collection)this.warnings.stream().map(Warning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (Warning)((Warning.Builder)Warning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public ReadPipelineResponse build() {
            return new ReadPipelineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticTranscoderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReadPipelineResponse> {
        public Builder pipeline(Pipeline var1);

        default public Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return this.pipeline((Pipeline)((Pipeline.Builder)Pipeline.builder().applyMutation(pipeline)).build());
        }

        public Builder warnings(Collection<Warning> var1);

        public Builder warnings(Warning ... var1);

        public Builder warnings(Consumer<Warning.Builder> ... var1);
    }
}

