/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.AudioCodecOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioParameters> {
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(AudioParameters.getter(AudioParameters::codec)).setter(AudioParameters.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()}).build();
    private static final SdkField<String> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleRate").getter(AudioParameters.getter(AudioParameters::sampleRate)).setter(AudioParameters.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()}).build();
    private static final SdkField<String> BIT_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitRate").getter(AudioParameters.getter(AudioParameters::bitRate)).setter(AudioParameters.setter(Builder::bitRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitRate").build()}).build();
    private static final SdkField<String> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channels").getter(AudioParameters.getter(AudioParameters::channels)).setter(AudioParameters.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build()}).build();
    private static final SdkField<String> AUDIO_PACKING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioPackingMode").getter(AudioParameters.getter(AudioParameters::audioPackingMode)).setter(AudioParameters.setter(Builder::audioPackingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioPackingMode").build()}).build();
    private static final SdkField<AudioCodecOptions> CODEC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodecOptions").getter(AudioParameters.getter(AudioParameters::codecOptions)).setter(AudioParameters.setter(Builder::codecOptions)).constructor(AudioCodecOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodecOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD, SAMPLE_RATE_FIELD, BIT_RATE_FIELD, CHANNELS_FIELD, AUDIO_PACKING_MODE_FIELD, CODEC_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codec;
    private final String sampleRate;
    private final String bitRate;
    private final String channels;
    private final String audioPackingMode;
    private final AudioCodecOptions codecOptions;

    private AudioParameters(BuilderImpl builder) {
        this.codec = builder.codec;
        this.sampleRate = builder.sampleRate;
        this.bitRate = builder.bitRate;
        this.channels = builder.channels;
        this.audioPackingMode = builder.audioPackingMode;
        this.codecOptions = builder.codecOptions;
    }

    public String codec() {
        return this.codec;
    }

    public String sampleRate() {
        return this.sampleRate;
    }

    public String bitRate() {
        return this.bitRate;
    }

    public String channels() {
        return this.channels;
    }

    public String audioPackingMode() {
        return this.audioPackingMode;
    }

    public AudioCodecOptions codecOptions() {
        return this.codecOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPackingMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioParameters)) {
            return false;
        }
        AudioParameters other = (AudioParameters)obj;
        return Objects.equals(this.codec(), other.codec()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.bitRate(), other.bitRate()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.audioPackingMode(), other.audioPackingMode()) && Objects.equals(this.codecOptions(), other.codecOptions());
    }

    public String toString() {
        return ToString.builder((String)"AudioParameters").add("Codec", (Object)this.codec()).add("SampleRate", (Object)this.sampleRate()).add("BitRate", (Object)this.bitRate()).add("Channels", (Object)this.channels()).add("AudioPackingMode", (Object)this.audioPackingMode()).add("CodecOptions", (Object)this.codecOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "BitRate": {
                return Optional.ofNullable(clazz.cast(this.bitRate()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "AudioPackingMode": {
                return Optional.ofNullable(clazz.cast(this.audioPackingMode()));
            }
            case "CodecOptions": {
                return Optional.ofNullable(clazz.cast(this.codecOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioParameters, T> g) {
        return obj -> g.apply((AudioParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private String sampleRate;
        private String bitRate;
        private String channels;
        private String audioPackingMode;
        private AudioCodecOptions codecOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioParameters model) {
            this.codec(model.codec);
            this.sampleRate(model.sampleRate);
            this.bitRate(model.bitRate);
            this.channels(model.channels);
            this.audioPackingMode(model.audioPackingMode);
            this.codecOptions(model.codecOptions);
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getBitRate() {
            return this.bitRate;
        }

        @Override
        public final Builder bitRate(String bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public final void setBitRate(String bitRate) {
            this.bitRate = bitRate;
        }

        public final String getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channels(String channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(String channels) {
            this.channels = channels;
        }

        public final String getAudioPackingMode() {
            return this.audioPackingMode;
        }

        @Override
        public final Builder audioPackingMode(String audioPackingMode) {
            this.audioPackingMode = audioPackingMode;
            return this;
        }

        public final void setAudioPackingMode(String audioPackingMode) {
            this.audioPackingMode = audioPackingMode;
        }

        public final AudioCodecOptions.Builder getCodecOptions() {
            return this.codecOptions != null ? this.codecOptions.toBuilder() : null;
        }

        @Override
        public final Builder codecOptions(AudioCodecOptions codecOptions) {
            this.codecOptions = codecOptions;
            return this;
        }

        public final void setCodecOptions(AudioCodecOptions.BuilderImpl codecOptions) {
            this.codecOptions = codecOptions != null ? codecOptions.build() : null;
        }

        public AudioParameters build() {
            return new AudioParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioParameters> {
        public Builder codec(String var1);

        public Builder sampleRate(String var1);

        public Builder bitRate(String var1);

        public Builder channels(String var1);

        public Builder audioPackingMode(String var1);

        public Builder codecOptions(AudioCodecOptions var1);

        default public Builder codecOptions(Consumer<AudioCodecOptions.Builder> codecOptions) {
            return this.codecOptions((AudioCodecOptions)((AudioCodecOptions.Builder)AudioCodecOptions.builder().applyMutation(codecOptions)).build());
        }
    }
}

