/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.services.elastictranscoder.model.Notifications;
import software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineRequest
extends ElasticTranscoderRequest
implements ToCopyableBuilder<Builder, UpdatePipelineRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::id)).setter(UpdatePipelineRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::name)).setter(UpdatePipelineRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> INPUT_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputBucket").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::inputBucket)).setter(UpdatePipelineRequest.setter(Builder::inputBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBucket").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::role)).setter(UpdatePipelineRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> AWS_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsKmsKeyArn").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::awsKmsKeyArn)).setter(UpdatePipelineRequest.setter(Builder::awsKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKeyArn").build()}).build();
    private static final SdkField<Notifications> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notifications").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::notifications)).setter(UpdatePipelineRequest.setter(Builder::notifications)).constructor(Notifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()}).build();
    private static final SdkField<PipelineOutputConfig> CONTENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentConfig").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::contentConfig)).setter(UpdatePipelineRequest.setter(Builder::contentConfig)).constructor(PipelineOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentConfig").build()}).build();
    private static final SdkField<PipelineOutputConfig> THUMBNAIL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThumbnailConfig").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::thumbnailConfig)).setter(UpdatePipelineRequest.setter(Builder::thumbnailConfig)).constructor(PipelineOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, INPUT_BUCKET_FIELD, ROLE_FIELD, AWS_KMS_KEY_ARN_FIELD, NOTIFICATIONS_FIELD, CONTENT_CONFIG_FIELD, THUMBNAIL_CONFIG_FIELD));
    private final String id;
    private final String name;
    private final String inputBucket;
    private final String role;
    private final String awsKmsKeyArn;
    private final Notifications notifications;
    private final PipelineOutputConfig contentConfig;
    private final PipelineOutputConfig thumbnailConfig;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.inputBucket = builder.inputBucket;
        this.role = builder.role;
        this.awsKmsKeyArn = builder.awsKmsKeyArn;
        this.notifications = builder.notifications;
        this.contentConfig = builder.contentConfig;
        this.thumbnailConfig = builder.thumbnailConfig;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String inputBucket() {
        return this.inputBucket;
    }

    public String role() {
        return this.role;
    }

    public String awsKmsKeyArn() {
        return this.awsKmsKeyArn;
    }

    public Notifications notifications() {
        return this.notifications;
    }

    public PipelineOutputConfig contentConfig() {
        return this.contentConfig;
    }

    public PipelineOutputConfig thumbnailConfig() {
        return this.thumbnailConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.inputBucket(), other.inputBucket()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.awsKmsKeyArn(), other.awsKmsKeyArn()) && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.contentConfig(), other.contentConfig()) && Objects.equals(this.thumbnailConfig(), other.thumbnailConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePipelineRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("InputBucket", (Object)this.inputBucket()).add("Role", (Object)this.role()).add("AwsKmsKeyArn", (Object)this.awsKmsKeyArn()).add("Notifications", (Object)this.notifications()).add("ContentConfig", (Object)this.contentConfig()).add("ThumbnailConfig", (Object)this.thumbnailConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InputBucket": {
                return Optional.ofNullable(clazz.cast(this.inputBucket()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "AwsKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.awsKmsKeyArn()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "ContentConfig": {
                return Optional.ofNullable(clazz.cast(this.contentConfig()));
            }
            case "ThumbnailConfig": {
                return Optional.ofNullable(clazz.cast(this.thumbnailConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String inputBucket;
        private String role;
        private String awsKmsKeyArn;
        private Notifications notifications;
        private PipelineOutputConfig contentConfig;
        private PipelineOutputConfig thumbnailConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.inputBucket(model.inputBucket);
            this.role(model.role);
            this.awsKmsKeyArn(model.awsKmsKeyArn);
            this.notifications(model.notifications);
            this.contentConfig(model.contentConfig);
            this.thumbnailConfig(model.thumbnailConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInputBucket() {
            return this.inputBucket;
        }

        @Override
        public final Builder inputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
            return this;
        }

        public final void setInputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getAwsKmsKeyArn() {
            return this.awsKmsKeyArn;
        }

        @Override
        public final Builder awsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
            return this;
        }

        public final void setAwsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
        }

        public final Notifications.Builder getNotifications() {
            return this.notifications != null ? this.notifications.toBuilder() : null;
        }

        @Override
        public final Builder notifications(Notifications notifications) {
            this.notifications = notifications;
            return this;
        }

        public final void setNotifications(Notifications.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        public final PipelineOutputConfig.Builder getContentConfig() {
            return this.contentConfig != null ? this.contentConfig.toBuilder() : null;
        }

        @Override
        public final Builder contentConfig(PipelineOutputConfig contentConfig) {
            this.contentConfig = contentConfig;
            return this;
        }

        public final void setContentConfig(PipelineOutputConfig.BuilderImpl contentConfig) {
            this.contentConfig = contentConfig != null ? contentConfig.build() : null;
        }

        public final PipelineOutputConfig.Builder getThumbnailConfig() {
            return this.thumbnailConfig != null ? this.thumbnailConfig.toBuilder() : null;
        }

        @Override
        public final Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig;
            return this;
        }

        public final void setThumbnailConfig(PipelineOutputConfig.BuilderImpl thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig != null ? thumbnailConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticTranscoderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder inputBucket(String var1);

        public Builder role(String var1);

        public Builder awsKmsKeyArn(String var1);

        public Builder notifications(Notifications var1);

        default public Builder notifications(Consumer<Notifications.Builder> notifications) {
            return this.notifications((Notifications)((Notifications.Builder)Notifications.builder().applyMutation(notifications)).build());
        }

        public Builder contentConfig(PipelineOutputConfig var1);

        default public Builder contentConfig(Consumer<PipelineOutputConfig.Builder> contentConfig) {
            return this.contentConfig((PipelineOutputConfig)((PipelineOutputConfig.Builder)PipelineOutputConfig.builder().applyMutation(contentConfig)).build());
        }

        public Builder thumbnailConfig(PipelineOutputConfig var1);

        default public Builder thumbnailConfig(Consumer<PipelineOutputConfig.Builder> thumbnailConfig) {
            return this.thumbnailConfig((PipelineOutputConfig)((PipelineOutputConfig.Builder)PipelineOutputConfig.builder().applyMutation(thumbnailConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

