/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsContentProtection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsContentProtection> {
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Method").getter(HlsContentProtection.getter(HlsContentProtection::method)).setter(HlsContentProtection.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(HlsContentProtection.getter(HlsContentProtection::key)).setter(HlsContentProtection.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> KEY_MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMd5").getter(HlsContentProtection.getter(HlsContentProtection::keyMd5)).setter(HlsContentProtection.setter(Builder::keyMd5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMd5").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVector").getter(HlsContentProtection.getter(HlsContentProtection::initializationVector)).setter(HlsContentProtection.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build()}).build();
    private static final SdkField<String> LICENSE_ACQUISITION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseAcquisitionUrl").getter(HlsContentProtection.getter(HlsContentProtection::licenseAcquisitionUrl)).setter(HlsContentProtection.setter(Builder::licenseAcquisitionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAcquisitionUrl").build()}).build();
    private static final SdkField<String> KEY_STORAGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyStoragePolicy").getter(HlsContentProtection.getter(HlsContentProtection::keyStoragePolicy)).setter(HlsContentProtection.setter(Builder::keyStoragePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStoragePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METHOD_FIELD, KEY_FIELD, KEY_MD5_FIELD, INITIALIZATION_VECTOR_FIELD, LICENSE_ACQUISITION_URL_FIELD, KEY_STORAGE_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String method;
    private final String key;
    private final String keyMd5;
    private final String initializationVector;
    private final String licenseAcquisitionUrl;
    private final String keyStoragePolicy;

    private HlsContentProtection(BuilderImpl builder) {
        this.method = builder.method;
        this.key = builder.key;
        this.keyMd5 = builder.keyMd5;
        this.initializationVector = builder.initializationVector;
        this.licenseAcquisitionUrl = builder.licenseAcquisitionUrl;
        this.keyStoragePolicy = builder.keyStoragePolicy;
    }

    public final String method() {
        return this.method;
    }

    public final String key() {
        return this.key;
    }

    public final String keyMd5() {
        return this.keyMd5;
    }

    public final String initializationVector() {
        return this.initializationVector;
    }

    public final String licenseAcquisitionUrl() {
        return this.licenseAcquisitionUrl;
    }

    public final String keyStoragePolicy() {
        return this.keyStoragePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMd5());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAcquisitionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStoragePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsContentProtection)) {
            return false;
        }
        HlsContentProtection other = (HlsContentProtection)obj;
        return Objects.equals(this.method(), other.method()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.keyMd5(), other.keyMd5()) && Objects.equals(this.initializationVector(), other.initializationVector()) && Objects.equals(this.licenseAcquisitionUrl(), other.licenseAcquisitionUrl()) && Objects.equals(this.keyStoragePolicy(), other.keyStoragePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"HlsContentProtection").add("Method", (Object)this.method()).add("Key", (Object)this.key()).add("KeyMd5", (Object)this.keyMd5()).add("InitializationVector", (Object)this.initializationVector()).add("LicenseAcquisitionUrl", (Object)this.licenseAcquisitionUrl()).add("KeyStoragePolicy", (Object)this.keyStoragePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "KeyMd5": {
                return Optional.ofNullable(clazz.cast(this.keyMd5()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
            case "LicenseAcquisitionUrl": {
                return Optional.ofNullable(clazz.cast(this.licenseAcquisitionUrl()));
            }
            case "KeyStoragePolicy": {
                return Optional.ofNullable(clazz.cast(this.keyStoragePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsContentProtection, T> g) {
        return obj -> g.apply((HlsContentProtection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String method;
        private String key;
        private String keyMd5;
        private String initializationVector;
        private String licenseAcquisitionUrl;
        private String keyStoragePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsContentProtection model) {
            this.method(model.method);
            this.key(model.key);
            this.keyMd5(model.keyMd5);
            this.initializationVector(model.initializationVector);
            this.licenseAcquisitionUrl(model.licenseAcquisitionUrl);
            this.keyStoragePolicy(model.keyStoragePolicy);
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        @Transient
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyMd5() {
            return this.keyMd5;
        }

        public final void setKeyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
        }

        @Override
        @Transient
        public final Builder keyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
            return this;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        @Transient
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final String getLicenseAcquisitionUrl() {
            return this.licenseAcquisitionUrl;
        }

        public final void setLicenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
        }

        @Override
        @Transient
        public final Builder licenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
            return this;
        }

        public final String getKeyStoragePolicy() {
            return this.keyStoragePolicy;
        }

        public final void setKeyStoragePolicy(String keyStoragePolicy) {
            this.keyStoragePolicy = keyStoragePolicy;
        }

        @Override
        @Transient
        public final Builder keyStoragePolicy(String keyStoragePolicy) {
            this.keyStoragePolicy = keyStoragePolicy;
            return this;
        }

        public HlsContentProtection build() {
            return new HlsContentProtection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsContentProtection> {
        public Builder method(String var1);

        public Builder key(String var1);

        public Builder keyMd5(String var1);

        public Builder initializationVector(String var1);

        public Builder licenseAcquisitionUrl(String var1);

        public Builder keyStoragePolicy(String var1);
    }
}

