/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.AudioParameters;
import software.amazon.awssdk.services.elastictranscoder.model.Thumbnails;
import software.amazon.awssdk.services.elastictranscoder.model.VideoParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Preset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Preset> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Preset.getter(Preset::id)).setter(Preset.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Preset.getter(Preset::arn)).setter(Preset.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Preset.getter(Preset::name)).setter(Preset.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Preset.getter(Preset::description)).setter(Preset.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Container").getter(Preset.getter(Preset::container)).setter(Preset.setter(Builder::container)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<AudioParameters> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Audio").getter(Preset.getter(Preset::audio)).setter(Preset.setter(Builder::audio)).constructor(AudioParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()}).build();
    private static final SdkField<VideoParameters> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(Preset.getter(Preset::video)).setter(Preset.setter(Builder::video)).constructor(VideoParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<Thumbnails> THUMBNAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Thumbnails").getter(Preset.getter(Preset::thumbnails)).setter(Preset.setter(Builder::thumbnails)).constructor(Thumbnails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbnails").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Preset.getter(Preset::type)).setter(Preset.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONTAINER_FIELD, AUDIO_FIELD, VIDEO_FIELD, THUMBNAILS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final String container;
    private final AudioParameters audio;
    private final VideoParameters video;
    private final Thumbnails thumbnails;
    private final String type;

    private Preset(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.container = builder.container;
        this.audio = builder.audio;
        this.video = builder.video;
        this.thumbnails = builder.thumbnails;
        this.type = builder.type;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String container() {
        return this.container;
    }

    public final AudioParameters audio() {
        return this.audio;
    }

    public final VideoParameters video() {
        return this.video;
    }

    public final Thumbnails thumbnails() {
        return this.thumbnails;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnails());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preset)) {
            return false;
        }
        Preset other = (Preset)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.audio(), other.audio()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.thumbnails(), other.thumbnails()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"Preset").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Container", (Object)this.container()).add("Audio", (Object)this.audio()).add("Video", (Object)this.video()).add("Thumbnails", (Object)this.thumbnails()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "Audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "Thumbnails": {
                return Optional.ofNullable(clazz.cast(this.thumbnails()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Preset, T> g) {
        return obj -> g.apply((Preset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private String container;
        private AudioParameters audio;
        private VideoParameters video;
        private Thumbnails thumbnails;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Preset model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.container(model.container);
            this.audio(model.audio);
            this.video(model.video);
            this.thumbnails(model.thumbnails);
            this.type(model.type);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContainer() {
            return this.container;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        @Override
        @Transient
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final AudioParameters.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioParameters.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        @Transient
        public final Builder audio(AudioParameters audio) {
            this.audio = audio;
            return this;
        }

        public final VideoParameters.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoParameters.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        @Transient
        public final Builder video(VideoParameters video) {
            this.video = video;
            return this;
        }

        public final Thumbnails.Builder getThumbnails() {
            return this.thumbnails != null ? this.thumbnails.toBuilder() : null;
        }

        public final void setThumbnails(Thumbnails.BuilderImpl thumbnails) {
            this.thumbnails = thumbnails != null ? thumbnails.build() : null;
        }

        @Override
        @Transient
        public final Builder thumbnails(Thumbnails thumbnails) {
            this.thumbnails = thumbnails;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public Preset build() {
            return new Preset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Preset> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder container(String var1);

        public Builder audio(AudioParameters var1);

        default public Builder audio(Consumer<AudioParameters.Builder> audio) {
            return this.audio((AudioParameters)((AudioParameters.Builder)AudioParameters.builder().applyMutation(audio)).build());
        }

        public Builder video(VideoParameters var1);

        default public Builder video(Consumer<VideoParameters.Builder> video) {
            return this.video((VideoParameters)((VideoParameters.Builder)VideoParameters.builder().applyMutation(video)).build());
        }

        public Builder thumbnails(Thumbnails var1);

        default public Builder thumbnails(Consumer<Thumbnails.Builder> thumbnails) {
            return this.thumbnails((Thumbnails)((Thumbnails.Builder)Thumbnails.builder().applyMutation(thumbnails)).build());
        }

        public Builder type(String var1);
    }
}

