/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.Encryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Artwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Artwork> {
    private static final SdkField<String> INPUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputKey").getter(Artwork.getter(Artwork::inputKey)).setter(Artwork.setter(Builder::inputKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputKey").build()}).build();
    private static final SdkField<String> MAX_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxWidth").getter(Artwork.getter(Artwork::maxWidth)).setter(Artwork.setter(Builder::maxWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()}).build();
    private static final SdkField<String> MAX_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxHeight").getter(Artwork.getter(Artwork::maxHeight)).setter(Artwork.setter(Builder::maxHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()}).build();
    private static final SdkField<String> SIZING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SizingPolicy").getter(Artwork.getter(Artwork::sizingPolicy)).setter(Artwork.setter(Builder::sizingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingPolicy").build()}).build();
    private static final SdkField<String> PADDING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaddingPolicy").getter(Artwork.getter(Artwork::paddingPolicy)).setter(Artwork.setter(Builder::paddingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingPolicy").build()}).build();
    private static final SdkField<String> ALBUM_ART_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlbumArtFormat").getter(Artwork.getter(Artwork::albumArtFormat)).setter(Artwork.setter(Builder::albumArtFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlbumArtFormat").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(Artwork.getter(Artwork::encryption)).setter(Artwork.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_KEY_FIELD, MAX_WIDTH_FIELD, MAX_HEIGHT_FIELD, SIZING_POLICY_FIELD, PADDING_POLICY_FIELD, ALBUM_ART_FORMAT_FIELD, ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputKey;
    private final String maxWidth;
    private final String maxHeight;
    private final String sizingPolicy;
    private final String paddingPolicy;
    private final String albumArtFormat;
    private final Encryption encryption;

    private Artwork(BuilderImpl builder) {
        this.inputKey = builder.inputKey;
        this.maxWidth = builder.maxWidth;
        this.maxHeight = builder.maxHeight;
        this.sizingPolicy = builder.sizingPolicy;
        this.paddingPolicy = builder.paddingPolicy;
        this.albumArtFormat = builder.albumArtFormat;
        this.encryption = builder.encryption;
    }

    public final String inputKey() {
        return this.inputKey;
    }

    public final String maxWidth() {
        return this.maxWidth;
    }

    public final String maxHeight() {
        return this.maxHeight;
    }

    public final String sizingPolicy() {
        return this.sizingPolicy;
    }

    public final String paddingPolicy() {
        return this.paddingPolicy;
    }

    public final String albumArtFormat() {
        return this.albumArtFormat;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.albumArtFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artwork)) {
            return false;
        }
        Artwork other = (Artwork)obj;
        return Objects.equals(this.inputKey(), other.inputKey()) && Objects.equals(this.maxWidth(), other.maxWidth()) && Objects.equals(this.maxHeight(), other.maxHeight()) && Objects.equals(this.sizingPolicy(), other.sizingPolicy()) && Objects.equals(this.paddingPolicy(), other.paddingPolicy()) && Objects.equals(this.albumArtFormat(), other.albumArtFormat()) && Objects.equals(this.encryption(), other.encryption());
    }

    public final String toString() {
        return ToString.builder((String)"Artwork").add("InputKey", (Object)this.inputKey()).add("MaxWidth", (Object)this.maxWidth()).add("MaxHeight", (Object)this.maxHeight()).add("SizingPolicy", (Object)this.sizingPolicy()).add("PaddingPolicy", (Object)this.paddingPolicy()).add("AlbumArtFormat", (Object)this.albumArtFormat()).add("Encryption", (Object)this.encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputKey": {
                return Optional.ofNullable(clazz.cast(this.inputKey()));
            }
            case "MaxWidth": {
                return Optional.ofNullable(clazz.cast(this.maxWidth()));
            }
            case "MaxHeight": {
                return Optional.ofNullable(clazz.cast(this.maxHeight()));
            }
            case "SizingPolicy": {
                return Optional.ofNullable(clazz.cast(this.sizingPolicy()));
            }
            case "PaddingPolicy": {
                return Optional.ofNullable(clazz.cast(this.paddingPolicy()));
            }
            case "AlbumArtFormat": {
                return Optional.ofNullable(clazz.cast(this.albumArtFormat()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artwork, T> g) {
        return obj -> g.apply((Artwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputKey;
        private String maxWidth;
        private String maxHeight;
        private String sizingPolicy;
        private String paddingPolicy;
        private String albumArtFormat;
        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(Artwork model) {
            this.inputKey(model.inputKey);
            this.maxWidth(model.maxWidth);
            this.maxHeight(model.maxHeight);
            this.sizingPolicy(model.sizingPolicy);
            this.paddingPolicy(model.paddingPolicy);
            this.albumArtFormat(model.albumArtFormat);
            this.encryption(model.encryption);
        }

        public final String getInputKey() {
            return this.inputKey;
        }

        public final void setInputKey(String inputKey) {
            this.inputKey = inputKey;
        }

        @Override
        public final Builder inputKey(String inputKey) {
            this.inputKey = inputKey;
            return this;
        }

        public final String getMaxWidth() {
            return this.maxWidth;
        }

        public final void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final String getMaxHeight() {
            return this.maxHeight;
        }

        public final void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final String getSizingPolicy() {
            return this.sizingPolicy;
        }

        public final void setSizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
        }

        @Override
        public final Builder sizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
            return this;
        }

        public final String getPaddingPolicy() {
            return this.paddingPolicy;
        }

        public final void setPaddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
        }

        @Override
        public final Builder paddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
            return this;
        }

        public final String getAlbumArtFormat() {
            return this.albumArtFormat;
        }

        public final void setAlbumArtFormat(String albumArtFormat) {
            this.albumArtFormat = albumArtFormat;
        }

        @Override
        public final Builder albumArtFormat(String albumArtFormat) {
            this.albumArtFormat = albumArtFormat;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Artwork build() {
            return new Artwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Artwork> {
        public Builder inputKey(String var1);

        public Builder maxWidth(String var1);

        public Builder maxHeight(String var1);

        public Builder sizingPolicy(String var1);

        public Builder paddingPolicy(String var1);

        public Builder albumArtFormat(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }
    }
}

