/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file format of the output captions. If you leave this value blank, Elastic Transcoder returns an error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionFormat implements SdkPojo, Serializable, ToCopyableBuilder<CaptionFormat.Builder, CaptionFormat> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaptionFormat::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaptionFormat::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionFormat::encryption)).setter(setter(Builder::encryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, PATTERN_FIELD,
            ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String pattern;

    private final Encryption encryption;

    private CaptionFormat(BuilderImpl builder) {
        this.format = builder.format;
        this.pattern = builder.pattern;
        this.encryption = builder.encryption;
    }

    /**
     * <p>
     * The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for this
     * output.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Valid Embedded Caption Formats:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>for FLAC</b>: None
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>For MP3</b>: None
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>For MP4</b>: mov-text
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>For MPEG-TS</b>: None
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>For ogg</b>: None
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>For webm</b>: None
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc, srt, and
     * webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>For FMP4</b>: dfxp
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Non-FMP4 outputs</b>: All sidecar types
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>fmp4</code> captions have an extension of <code>.ismt</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for
     *         this output.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Valid Embedded Caption Formats:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>for FLAC</b>: None
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For MP3</b>: None
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For MP4</b>: mov-text
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For MPEG-TS</b>: None
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For ogg</b>: None
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For webm</b>: None
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc,
     *         srt, and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For FMP4</b>: dfxp
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Non-FMP4 outputs</b>: All sidecar types
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>fmp4</code> captions have an extension of <code>.ismt</code>
     *         </p>
     *         </li>
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>description</i> is a description of the video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter code
     * for the language of the caption in the output file names.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically appends "
     * <code>{language}</code>" to the value that you specify for the description. In addition, Elastic Transcoder
     * automatically appends the count to the end of the segment files.
     * </p>
     * <p>
     * For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and the
     * language of the captions is English (en), the name of the first caption file is be Sydney-en-sunrise00000.srt.
     * </p>
     * 
     * @return The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>description</i> is a description of the video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter
     *         code for the language of the caption in the output file names.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically
     *         appends "<code>{language}</code>" to the value that you specify for the description. In addition, Elastic
     *         Transcoder automatically appends the count to the end of the segment files.
     *         </p>
     *         <p>
     *         For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and
     *         the language of the captions is English (en), the name of the first caption file is be
     *         Sydney-en-sunrise00000.srt.
     */
    public String pattern() {
        return pattern;
    }

    /**
     * <p>
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.
     * </p>
     * 
     * @return The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.
     */
    public Encryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionFormat)) {
            return false;
        }
        CaptionFormat other = (CaptionFormat) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(pattern(), other.pattern())
                && Objects.equals(encryption(), other.encryption());
    }

    @Override
    public String toString() {
        return ToString.builder("CaptionFormat").add("Format", format()).add("Pattern", pattern())
                .add("Encryption", encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "Pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionFormat, T> g) {
        return obj -> g.apply((CaptionFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionFormat> {
        /**
         * <p>
         * The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption for
         * this output.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Valid Embedded Caption Formats:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>for FLAC</b>: None
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For MP3</b>: None
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For MP4</b>: mov-text
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For MPEG-TS</b>: None
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For ogg</b>: None
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>For webm</b>: None
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc, srt,
         * and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>For FMP4</b>: dfxp
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Non-FMP4 outputs</b>: All sidecar types
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>fmp4</code> captions have an extension of <code>.ismt</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The format you specify determines whether Elastic Transcoder generates an embedded or sidecar caption
         *        for this output.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Valid Embedded Caption Formats:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>for FLAC</b>: None
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For MP3</b>: None
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For MP4</b>: mov-text
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For MPEG-TS</b>: None
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For ogg</b>: None
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>For webm</b>: None
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Valid Sidecar Caption Formats:</b> Elastic Transcoder supports dfxp (first div element only), scc,
         *        srt, and webvtt. If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>For FMP4</b>: dfxp
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Non-FMP4 outputs</b>: All sidecar types
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>fmp4</code> captions have an extension of <code>.ismt</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>description</i> is a description of the video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or three-letter
         * code for the language of the caption in the output file names.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder automatically
         * appends "<code>{language}</code>" to the value that you specify for the description. In addition, Elastic
         * Transcoder automatically appends the count to the end of the segment files.
         * </p>
         * <p>
         * For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise", and the
         * language of the captions is English (en), the name of the first caption file is be
         * Sydney-en-sunrise00000.srt.
         * </p>
         * 
         * @param pattern
         *        The prefix for caption filenames, in the form <i>description</i>-<code>{language}</code>, where:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>description</i> is a description of the video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>{language}</code> is a literal value that Elastic Transcoder replaces with the two- or
         *        three-letter code for the language of the caption in the output file names.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't include <code>{language}</code> in the file name pattern, Elastic Transcoder
         *        automatically appends "<code>{language}</code>" to the value that you specify for the description. In
         *        addition, Elastic Transcoder automatically appends the count to the end of the segment files.
         *        </p>
         *        <p>
         *        For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise",
         *        and the language of the captions is English (en), the name of the first caption file is be
         *        Sydney-en-sunrise00000.srt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.
         * </p>
         * 
         * @param encryption
         *        The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your caption formats.
         * </p>
         * This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create
         * one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String pattern;

        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionFormat model) {
            format(model.format);
            pattern(model.pattern);
            encryption(model.encryption);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getPattern() {
            return pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public CaptionFormat build() {
            return new CaptionFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
