/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A section of the response body that provides information about the job that is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements SdkPojo, Serializable, ToCopyableBuilder<Job.Builder, Job> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Job::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Job::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineId").build()).build();

    private static final SdkField<JobInput> INPUT_FIELD = SdkField.<JobInput> builder(MarshallingType.SDK_POJO)
            .getter(getter(Job::input)).setter(setter(Builder::input)).constructor(JobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<List<JobInput>> INPUTS_FIELD = SdkField
            .<List<JobInput>> builder(MarshallingType.LIST)
            .getter(getter(Job::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<JobOutput> OUTPUT_FIELD = SdkField.<JobOutput> builder(MarshallingType.SDK_POJO)
            .getter(getter(Job::output)).setter(setter(Builder::output)).constructor(JobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<List<JobOutput>> OUTPUTS_FIELD = SdkField
            .<List<JobOutput>> builder(MarshallingType.LIST)
            .getter(getter(Job::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::outputKeyPrefix)).setter(setter(Builder::outputKeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeyPrefix").build()).build();

    private static final SdkField<List<Playlist>> PLAYLISTS_FIELD = SdkField
            .<List<Playlist>> builder(MarshallingType.LIST)
            .getter(getter(Job::playlists))
            .setter(setter(Builder::playlists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Playlists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Playlist> builder(MarshallingType.SDK_POJO)
                                            .constructor(Playlist::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Job::userMetadata))
            .setter(setter(Builder::userMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Timing> TIMING_FIELD = SdkField.<Timing> builder(MarshallingType.SDK_POJO)
            .getter(getter(Job::timing)).setter(setter(Builder::timing)).constructor(Timing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            PIPELINE_ID_FIELD, INPUT_FIELD, INPUTS_FIELD, OUTPUT_FIELD, OUTPUTS_FIELD, OUTPUT_KEY_PREFIX_FIELD, PLAYLISTS_FIELD,
            STATUS_FIELD, USER_METADATA_FIELD, TIMING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String pipelineId;

    private final JobInput input;

    private final List<JobInput> inputs;

    private final JobOutput output;

    private final List<JobOutput> outputs;

    private final String outputKeyPrefix;

    private final List<Playlist> playlists;

    private final String status;

    private final Map<String, String> userMetadata;

    private final Timing timing;

    private Job(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.pipelineId = builder.pipelineId;
        this.input = builder.input;
        this.inputs = builder.inputs;
        this.output = builder.output;
        this.outputs = builder.outputs;
        this.outputKeyPrefix = builder.outputKeyPrefix;
        this.playlists = builder.playlists;
        this.status = builder.status;
        this.userMetadata = builder.userMetadata;
        this.timing = builder.timing;
    }

    /**
     * <p>
     * The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to
     * delete the job.
     * </p>
     * 
     * @return The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the
     *         job or to delete the job.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the job.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline
     * determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to
     * transcode and the bucket into which Elastic Transcoder puts the transcoded files.
     * </p>
     * 
     * @return The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline
     *         determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files
     *         to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * <p>
     * A section of the request or response body that provides information about the file that is being transcoded.
     * </p>
     * 
     * @return A section of the request or response body that provides information about the file that is being
     *         transcoded.
     */
    public JobInput input() {
        return input;
    }

    /**
     * <p>
     * Information about the files that you're transcoding. If you specified multiple files for this job, Elastic
     * Transcoder stitches the files together to make one output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the files that you're transcoding. If you specified multiple files for this job,
     *         Elastic Transcoder stitches the files together to make one output.
     */
    public List<JobInput> inputs() {
        return inputs;
    }

    /**
     * <p>
     * If you specified one output for a job, information about that output. If you specified multiple outputs for a
     * job, the Output object lists information about the first output. This duplicates the information that is listed
     * for the first output in the Outputs object.
     * </p>
     * <important>
     * <p>
     * Outputs recommended instead.
     * </p>
     * </important>
     * <p>
     * A section of the request or response body that provides information about the transcoded (target) file.
     * </p>
     * 
     * @return If you specified one output for a job, information about that output. If you specified multiple outputs
     *         for a job, the Output object lists information about the first output. This duplicates the information
     *         that is listed for the first output in the Outputs object.</p> <important>
     *         <p>
     *         Outputs recommended instead.
     *         </p>
     *         </important>
     *         <p>
     *         A section of the request or response body that provides information about the transcoded (target) file.
     */
    public JobOutput output() {
        return output;
    }

    /**
     * <p>
     * Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs, even
     * when you want Elastic Transcoder to transcode a file into only one format. Do not use both the
     * <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30 outputs
     * per job.
     * </p>
     * <p>
     * If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order
     * in which you specify them in the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all
     *         jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the
     *         <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30
     *         outputs per job. </p>
     *         <p>
     *         If you specify more than one output for a job, Elastic Transcoder creates the files for each output in
     *         the order in which you specify them in the job.
     */
    public List<JobOutput> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates,
     * including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the
     * end of the <code>OutputKeyPrefix</code>.
     * </p>
     * 
     * @return The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job
     *         creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other
     *         delimiter to the end of the <code>OutputKeyPrefix</code>.
     */
    public String outputKeyPrefix() {
        return outputKeyPrefix;
    }

    /**
     * <important>
     * <p>
     * Outputs in Fragmented MP4 or MPEG-TS format only.
     * </p>
     * </important>
     * <p>
     * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
     * (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that you
     * want Elastic Transcoder to create.
     * </p>
     * <p>
     * The maximum number of master playlists in a job is 30.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return <p>
     *         Outputs in Fragmented MP4 or MPEG-TS format only.
     *         </p>
     *         </important>
     *         <p>
     *         If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
     *         (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists
     *         that you want Elastic Transcoder to create.
     *         </p>
     *         <p>
     *         The maximum number of master playlists in a job is 30.
     */
    public List<Playlist> playlists() {
        return playlists;
    }

    /**
     * <p>
     * The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>,
     * <code>Canceled</code>, or <code>Error</code>.
     * </p>
     * 
     * @return The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>,
     *         <code>Canceled</code>, or <code>Error</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in
     * <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic Transcoder
     * does not guarantee that <code>key/value</code> pairs are returned in the same order in which you specify them.
     * </p>
     * <p>
     * Metadata <code>keys</code> and <code>values</code> must use characters from the following list:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>0-9</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>A-Z</code> and <code>a-z</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Space</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The following symbols: <code>_.:/=+-%@</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in
     *         <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic
     *         Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which
     *         you specify them.</p>
     *         <p>
     *         Metadata <code>keys</code> and <code>values</code> must use characters from the following list:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>0-9</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>A-Z</code> and <code>a-z</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Space</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The following symbols: <code>_.:/=+-%@</code>
     *         </p>
     *         </li>
     */
    public Map<String, String> userMetadata() {
        return userMetadata;
    }

    /**
     * <p>
     * Details about the timing of a job.
     * </p>
     * 
     * @return Details about the timing of a job.
     */
    public Timing timing() {
        return timing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputs());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(outputKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(playlists());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(userMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(timing());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(pipelineId(), other.pipelineId()) && Objects.equals(input(), other.input())
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(output(), other.output())
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(outputKeyPrefix(), other.outputKeyPrefix())
                && Objects.equals(playlists(), other.playlists()) && Objects.equals(status(), other.status())
                && Objects.equals(userMetadata(), other.userMetadata()) && Objects.equals(timing(), other.timing());
    }

    @Override
    public String toString() {
        return ToString.builder("Job").add("Id", id()).add("Arn", arn()).add("PipelineId", pipelineId()).add("Input", input())
                .add("Inputs", inputs()).add("Output", output()).add("Outputs", outputs())
                .add("OutputKeyPrefix", outputKeyPrefix()).add("Playlists", playlists()).add("Status", status())
                .add("UserMetadata", userMetadata()).add("Timing", timing()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "OutputKeyPrefix":
            return Optional.ofNullable(clazz.cast(outputKeyPrefix()));
        case "Playlists":
            return Optional.ofNullable(clazz.cast(playlists()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "UserMetadata":
            return Optional.ofNullable(clazz.cast(userMetadata()));
        case "Timing":
            return Optional.ofNullable(clazz.cast(timing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Job> {
        /**
         * <p>
         * The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or
         * to delete the job.
         * </p>
         * 
         * @param id
         *        The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the
         *        job or to delete the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline
         * determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to
         * transcode and the bucket into which Elastic Transcoder puts the transcoded files.
         * </p>
         * 
         * @param pipelineId
         *        The <code>Id</code> of the pipeline that you want Elastic Transcoder to use for transcoding. The
         *        pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder
         *        gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * A section of the request or response body that provides information about the file that is being transcoded.
         * </p>
         * 
         * @param input
         *        A section of the request or response body that provides information about the file that is being
         *        transcoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(JobInput input);

        /**
         * <p>
         * A section of the request or response body that provides information about the file that is being transcoded.
         * </p>
         * This is a convenience that creates an instance of the {@link JobInput.Builder} avoiding the need to create
         * one manually via {@link JobInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobInput.Builder#build()} is called immediately and its result is
         * passed to {@link #input(JobInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link JobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(JobInput)
         */
        default Builder input(Consumer<JobInput.Builder> input) {
            return input(JobInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Information about the files that you're transcoding. If you specified multiple files for this job, Elastic
         * Transcoder stitches the files together to make one output.
         * </p>
         * 
         * @param inputs
         *        Information about the files that you're transcoding. If you specified multiple files for this job,
         *        Elastic Transcoder stitches the files together to make one output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<JobInput> inputs);

        /**
         * <p>
         * Information about the files that you're transcoding. If you specified multiple files for this job, Elastic
         * Transcoder stitches the files together to make one output.
         * </p>
         * 
         * @param inputs
         *        Information about the files that you're transcoding. If you specified multiple files for this job,
         *        Elastic Transcoder stitches the files together to make one output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(JobInput... inputs);

        /**
         * <p>
         * Information about the files that you're transcoding. If you specified multiple files for this job, Elastic
         * Transcoder stitches the files together to make one output.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobInput>.Builder} avoiding the need to
         * create one manually via {@link List<JobInput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobInput>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputs(List<JobInput>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on {@link List<JobInput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(List<JobInput>)
         */
        Builder inputs(Consumer<JobInput.Builder>... inputs);

        /**
         * <p>
         * If you specified one output for a job, information about that output. If you specified multiple outputs for a
         * job, the Output object lists information about the first output. This duplicates the information that is
         * listed for the first output in the Outputs object.
         * </p>
         * <important>
         * <p>
         * Outputs recommended instead.
         * </p>
         * </important>
         * <p>
         * A section of the request or response body that provides information about the transcoded (target) file.
         * </p>
         * 
         * @param output
         *        If you specified one output for a job, information about that output. If you specified multiple
         *        outputs for a job, the Output object lists information about the first output. This duplicates the
         *        information that is listed for the first output in the Outputs object.</p> <important>
         *        <p>
         *        Outputs recommended instead.
         *        </p>
         *        </important>
         *        <p>
         *        A section of the request or response body that provides information about the transcoded (target)
         *        file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(JobOutput output);

        /**
         * <p>
         * If you specified one output for a job, information about that output. If you specified multiple outputs for a
         * job, the Output object lists information about the first output. This duplicates the information that is
         * listed for the first output in the Outputs object.
         * </p>
         * <important>
         * <p>
         * Outputs recommended instead.
         * </p>
         * </important>
         * <p>
         * A section of the request or response body that provides information about the transcoded (target) file.
         * </p>
         * This is a convenience that creates an instance of the {@link JobOutput.Builder} avoiding the need to create
         * one manually via {@link JobOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobOutput.Builder#build()} is called immediately and its result
         * is passed to {@link #output(JobOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link JobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(JobOutput)
         */
        default Builder output(Consumer<JobOutput.Builder> output) {
            return output(JobOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs,
         * even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the
         * <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30
         * outputs per job.
         * </p>
         * <p>
         * If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the
         * order in which you specify them in the job.
         * </p>
         * 
         * @param outputs
         *        Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all
         *        jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both
         *        the <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a
         *        maximum of 30 outputs per job. </p>
         *        <p>
         *        If you specify more than one output for a job, Elastic Transcoder creates the files for each output in
         *        the order in which you specify them in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<JobOutput> outputs);

        /**
         * <p>
         * Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs,
         * even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the
         * <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30
         * outputs per job.
         * </p>
         * <p>
         * If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the
         * order in which you specify them in the job.
         * </p>
         * 
         * @param outputs
         *        Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all
         *        jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both
         *        the <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a
         *        maximum of 30 outputs per job. </p>
         *        <p>
         *        If you specify more than one output for a job, Elastic Transcoder creates the files for each output in
         *        the order in which you specify them in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(JobOutput... outputs);

        /**
         * <p>
         * Information about the output files. We recommend that you use the <code>Outputs</code> syntax for all jobs,
         * even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the
         * <code>Outputs</code> and <code>Output</code> syntaxes in the same request. You can create a maximum of 30
         * outputs per job.
         * </p>
         * <p>
         * If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the
         * order in which you specify them in the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobOutput>.Builder} avoiding the need to
         * create one manually via {@link List<JobOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobOutput>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<JobOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<JobOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<JobOutput>)
         */
        Builder outputs(Consumer<JobOutput.Builder>... outputs);

        /**
         * <p>
         * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job
         * creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other
         * delimiter to the end of the <code>OutputKeyPrefix</code>.
         * </p>
         * 
         * @param outputKeyPrefix
         *        The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job
         *        creates, including output files, thumbnails, and playlists. We recommend that you add a / or some
         *        other delimiter to the end of the <code>OutputKeyPrefix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKeyPrefix(String outputKeyPrefix);

        /**
         * <important>
         * <p>
         * Outputs in Fragmented MP4 or MPEG-TS format only.
         * </p>
         * </important>
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         * (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that
         * you want Elastic Transcoder to create.
         * </p>
         * <p>
         * The maximum number of master playlists in a job is 30.
         * </p>
         * 
         * @param playlists
         *        <p>
         *        Outputs in Fragmented MP4 or MPEG-TS format only.
         *        </p>
         *        </important>
         *        <p>
         *        If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         *        (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master
         *        playlists that you want Elastic Transcoder to create.
         *        </p>
         *        <p>
         *        The maximum number of master playlists in a job is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlists(Collection<Playlist> playlists);

        /**
         * <important>
         * <p>
         * Outputs in Fragmented MP4 or MPEG-TS format only.
         * </p>
         * </important>
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         * (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that
         * you want Elastic Transcoder to create.
         * </p>
         * <p>
         * The maximum number of master playlists in a job is 30.
         * </p>
         * 
         * @param playlists
         *        <p>
         *        Outputs in Fragmented MP4 or MPEG-TS format only.
         *        </p>
         *        </important>
         *        <p>
         *        If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         *        (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master
         *        playlists that you want Elastic Transcoder to create.
         *        </p>
         *        <p>
         *        The maximum number of master playlists in a job is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlists(Playlist... playlists);

        /**
         * <important>
         * <p>
         * Outputs in Fragmented MP4 or MPEG-TS format only.
         * </p>
         * </important>
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is fmp4
         * (Fragmented MP4) or ts (MPEG-TS), <code>Playlists</code> contains information about the master playlists that
         * you want Elastic Transcoder to create.
         * </p>
         * <p>
         * The maximum number of master playlists in a job is 30.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Playlist>.Builder} avoiding the need to
         * create one manually via {@link List<Playlist>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Playlist>.Builder#build()} is called immediately and its
         * result is passed to {@link #playlists(List<Playlist>)}.
         * 
         * @param playlists
         *        a consumer that will call methods on {@link List<Playlist>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #playlists(List<Playlist>)
         */
        Builder playlists(Consumer<Playlist.Builder>... playlists);

        /**
         * <p>
         * The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>,
         * <code>Canceled</code>, or <code>Error</code>.
         * </p>
         * 
         * @param status
         *        The status of the job: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>,
         *        <code>Canceled</code>, or <code>Error</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in
         * <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job. Elastic
         * Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order in which you
         * specify them.
         * </p>
         * <p>
         * Metadata <code>keys</code> and <code>values</code> must use characters from the following list:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>0-9</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>A-Z</code> and <code>a-z</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Space</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The following symbols: <code>_.:/=+-%@</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param userMetadata
         *        User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata
         *        in <code>key/value</code> pairs, and you can add up to 10 <code>key/value</code> pairs per job.
         *        Elastic Transcoder does not guarantee that <code>key/value</code> pairs are returned in the same order
         *        in which you specify them.</p>
         *        <p>
         *        Metadata <code>keys</code> and <code>values</code> must use characters from the following list:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>0-9</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>A-Z</code> and <code>a-z</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Space</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following symbols: <code>_.:/=+-%@</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMetadata(Map<String, String> userMetadata);

        /**
         * <p>
         * Details about the timing of a job.
         * </p>
         * 
         * @param timing
         *        Details about the timing of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timing(Timing timing);

        /**
         * <p>
         * Details about the timing of a job.
         * </p>
         * This is a convenience that creates an instance of the {@link Timing.Builder} avoiding the need to create one
         * manually via {@link Timing#builder()}.
         *
         * When the {@link Consumer} completes, {@link Timing.Builder#build()} is called immediately and its result is
         * passed to {@link #timing(Timing)}.
         * 
         * @param timing
         *        a consumer that will call methods on {@link Timing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timing(Timing)
         */
        default Builder timing(Consumer<Timing.Builder> timing) {
            return timing(Timing.builder().applyMutation(timing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String pipelineId;

        private JobInput input;

        private List<JobInput> inputs = DefaultSdkAutoConstructList.getInstance();

        private JobOutput output;

        private List<JobOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private String outputKeyPrefix;

        private List<Playlist> playlists = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private Timing timing;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            id(model.id);
            arn(model.arn);
            pipelineId(model.pipelineId);
            input(model.input);
            inputs(model.inputs);
            output(model.output);
            outputs(model.outputs);
            outputKeyPrefix(model.outputKeyPrefix);
            playlists(model.playlists);
            status(model.status);
            userMetadata(model.userMetadata);
            timing(model.timing);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final JobInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(JobInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(JobInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final Collection<JobInput.Builder> getInputs() {
            return inputs != null ? inputs.stream().map(JobInput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<JobInput> inputs) {
            this.inputs = JobInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(JobInput... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<JobInput.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> JobInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<JobInput.BuilderImpl> inputs) {
            this.inputs = JobInputsCopier.copyFromBuilder(inputs);
        }

        public final JobOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(JobOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(JobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final Collection<JobOutput.Builder> getOutputs() {
            return outputs != null ? outputs.stream().map(JobOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<JobOutput> outputs) {
            this.outputs = JobOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(JobOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<JobOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> JobOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<JobOutput.BuilderImpl> outputs) {
            this.outputs = JobOutputsCopier.copyFromBuilder(outputs);
        }

        public final String getOutputKeyPrefix() {
            return outputKeyPrefix;
        }

        @Override
        public final Builder outputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
            return this;
        }

        public final void setOutputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
        }

        public final Collection<Playlist.Builder> getPlaylists() {
            return playlists != null ? playlists.stream().map(Playlist::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playlists(Collection<Playlist> playlists) {
            this.playlists = PlaylistsCopier.copy(playlists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(Playlist... playlists) {
            playlists(Arrays.asList(playlists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(Consumer<Playlist.Builder>... playlists) {
            playlists(Stream.of(playlists).map(c -> Playlist.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlaylists(Collection<Playlist.BuilderImpl> playlists) {
            this.playlists = PlaylistsCopier.copyFromBuilder(playlists);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getUserMetadata() {
            return userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
        }

        public final Timing.Builder getTiming() {
            return timing != null ? timing.toBuilder() : null;
        }

        @Override
        public final Builder timing(Timing timing) {
            this.timing = timing;
            return this;
        }

        public final void setTiming(Timing.BuilderImpl timing) {
            this.timing = timing != null ? timing.build() : null;
        }

        @Override
        public Job build() {
            return new Job(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
